/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.log.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msisv.isomorphism.core.log.vo.IntegrationLog;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;

public class IntegrationLogService {
    private static final Log log = LogFactory.getLog(IntegrationLogService.class);

    private static DynamicObject[] buildLogDym(List<IntegrationLog> integrationLogs) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(integrationLogs.size());
        for (IntegrationLog integrationLog : integrationLogs) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"msisv_monitorlog");
            dynamicObject.set("exetime", (Object)integrationLog.getExecuteTime());
            dynamicObject.set("entity", (Object)integrationLog.getEntityNumber());
            dynamicObject.set("operationname", (Object)integrationLog.getOpName());
            dynamicObject.set("operation", (Object)integrationLog.getOpKey());
            dynamicObject.set("billid", (Object)integrationLog.getBillId());
            dynamicObject.set("billno", (Object)integrationLog.getBillNo());
            dynamicObject.set("type", (Object)integrationLog.getPipelineType());
            dynamicObject.set("action", (Object)integrationLog.getPipelineName());
            dynamicObject.set("actionnumber", (Object)integrationLog.getPipelineNumber());
            dynamicObject.set("isfinish", (Object)integrationLog.isFinish());
            dynamicObject.set("issuccess", (Object)integrationLog.isSuccess());
            dynamicObject.set("user", (Object)integrationLog.getUserId());
            dynamicObject.set("log_tag", (Object)integrationLog.getResultLog());
            dynamicObject.set("traceid", (Object)integrationLog.getTraceId());
            dynamicObject.set("bizno", (Object)integrationLog.getBizNo());
            dynamicObject.set("batchno", (Object)integrationLog.getBatchNo());
            dynamicObject.set("ecologicmonitor", (Object)integrationLog.getListenerConfigName());
            dynamicObjects.add(dynamicObject);
        }
        log.info("record execute log,size:{}", (Object)CollectionUtils.size(dynamicObjects));
        return (DynamicObject[])dynamicObjects.stream().toArray(DynamicObject[]::new);
    }

    public static void updateMonitorLog(List<Long> logIds, Exception exception) {
        if (ObjectUtils.isEmpty(logIds)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", logIds);
        DynamicObject[] logDymList = BusinessDataServiceHelper.load((String)"msisv_monitorlog", (String)"id,isfinish,issuccess,log_tag", (QFilter[])qFilter.toArray());
        if (null != exception) {
            log.info("\u64cd\u4f5c\u5931\u8d25,\u66f4\u65b0\u76d1\u542c\u65e5\u5fd7:{}", (Object)exception.getMessage());
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(exception.getMessage());
            for (DynamicObject dynamicObject : logDymList) {
                dynamicObject.set("isfinish", (Object)true);
                dynamicObject.set("issuccess", (Object)false);
                dynamicObject.set("log_tag", (Object)errorMsg.toString());
            }
        } else {
            log.info("\u6d41\u6c34\u7ebf\u6267\u884c\u6210\u529f,\u66f4\u65b0\u76d1\u542c\u65e5\u5fd7");
            for (DynamicObject dynamicObject : logDymList) {
                if (dynamicObject.getBoolean("issuccess")) continue;
                dynamicObject.set("isfinish", (Object)true);
                dynamicObject.set("issuccess", (Object)true);
                dynamicObject.set("log_tag", (Object)"");
            }
        }
        TXHandle tx = TX.requiresNew((String)"monitorLogTX");
        Object object = null;
        try {
            log.info("\u8bb0\u5f55\u76d1\u542c\u65e5\u5fd7,\u6570\u91cf:{}", (Object)logDymList.length);
            SaveServiceHelper.update((DynamicObject[])logDymList);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    public static List<Long> saveLog(Map<Long, String> billMap, IntegrationLog logContext, boolean isSync) {
        DynamicObject[] logs;
        block30: {
            TXHandle tx;
            ArrayList<IntegrationLog> logList = new ArrayList<IntegrationLog>(billMap.size());
            for (Map.Entry<Long, String> entry : billMap.entrySet()) {
                IntegrationLog integrationLog = logContext.clone();
                integrationLog.setBillId(entry.getKey());
                integrationLog.setBillNo(entry.getValue());
                logList.add(integrationLog);
            }
            logs = IntegrationLogService.buildLogDym(logList);
            String dbrouter = TX.getWrittenRouteKey();
            if (BooleanUtils.isTrue((Boolean)isSync) || null != dbrouter) {
                tx = TX.requiresNew((String)"monitorLogTX");
                Throwable throwable = null;
                try {
                    log.info("\u8bb0\u5f55\u76d1\u542c\u65e5\u5fd7,\u6570\u91cf:{}", (Object)logs.length);
                    SaveServiceHelper.save((DynamicObject[])logs);
                    break block30;
                }
                catch (Throwable e) {
                    throwable = e;
                    throw e;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable e) {
                                throwable.addSuppressed(e);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            tx = TX.required((String)"monitorLogTX");
            Throwable throwable = null;
            try {
                log.info("\u8bb0\u5f55\u76d1\u542c\u65e5\u5fd7,\u6570\u91cf:{}", (Object)logs.length);
                SaveServiceHelper.save((DynamicObject[])logs);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        return Stream.of(logs).map(item -> (Long)item.getPkValue()).collect(Collectors.toList());
    }

    public static void updateLog(List<Long> logIds) {
        if (ObjectUtils.isEmpty(logIds)) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", logIds);
        DynamicObject[] logDymList = BusinessDataServiceHelper.load((String)"msisv_monitorlog", (String)"id,isfinish,issuccess,log_tag", (QFilter[])qFilter.toArray());
        log.info("\u6d41\u6c34\u7ebf\u6267\u884c\u6210\u529f,\u66f4\u65b0\u76d1\u542c\u65e5\u5fd7");
        for (DynamicObject dynamicObject : logDymList) {
            if (dynamicObject.getBoolean("issuccess")) continue;
            dynamicObject.set("isfinish", (Object)true);
            dynamicObject.set("issuccess", (Object)true);
            dynamicObject.set("log_tag", (Object)"");
        }
        try (TXHandle tx = TX.requiresNew((String)"monitorLogTX");){
            log.info("\u8bb0\u5f55\u76d1\u542c\u65e5\u5fd7,\u6570\u91cf:{}", (Object)logDymList.length);
            SaveServiceHelper.update((DynamicObject[])logDymList);
        }
    }
}

