/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.log.service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msisv.isomorphism.common.helper.EntityHelper;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MasterQtyPropConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PushPipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.ListenerPushPipeline;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.RelationPushPipeline;
import kd.mpscmm.msisv.isomorphism.core.log.vo.UnionPushRecordObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class UnionPushRecordService {
    public static List<UnionPushRecordObject> loadUnionPushRecordsByRel(String entityNumber, Collection<Long> billIdList) {
        QFilter qFilter = new QFilter("relentity", "=", (Object)entityNumber);
        qFilter.and("relbillid", "in", billIdList);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"msisv_unionpush_record", (String)"unionpush,srcentity,srcbillid,srcentryid,relentity,relbillid,relentryid,tgtentity,tgtbillid,tgtentryid", (QFilter[])qFilter.toArray());
        return collection.stream().map(UnionPushRecordObject::new).collect(Collectors.toList());
    }

    private static QFilter buildTgtFilter(List<UnionPushRecordObject> unionPushRecordObjectList, String entryType) {
        Set billIds = unionPushRecordObjectList.stream().map(item -> item.getTgtObj().getBillId()).collect(Collectors.toSet());
        Set entryIds = unionPushRecordObjectList.stream().map(item -> item.getTgtObj().getEntryId()).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", billIds);
        return qFilter.and(entryType + ".id", "in", entryIds);
    }

    public static DataSet loadTgtBillDataSet(String tgtQtyField, List<UnionPushRecordObject> unionPushRecordObjectList, String targetFilterFormula) {
        String entitType = unionPushRecordObjectList.get(0).getTgtObj().getEntityType();
        String entryType = EntityHelper.findEntryType(entitType, tgtQtyField);
        QFilter tgtQFilter = UnionPushRecordService.buildTgtFilter(unionPushRecordObjectList, entryType);
        if (StringUtils.isNotBlank((CharSequence)targetFilterFormula)) {
            tgtQFilter.and(QFilter.of((String)targetFilterFormula, (Object[])new Object[0]));
        }
        UnionPushRecordService.addChargeOffFilter(tgtQFilter, entitType);
        return QueryServiceHelper.queryDataSet((String)UnionPushRecordService.class.getName(), (String)entitType, (String)("id,billno," + entryType + ".id as entryid," + tgtQtyField + " as qty"), (QFilter[])tgtQFilter.toArray(), null);
    }

    private static void addChargeOffFilter(QFilter qFilter, String entityType) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
        if (mainEntityType.getFields().containsKey("ischargeoffed")) {
            qFilter.and("ischargeoffed", "=", (Object)Boolean.FALSE);
        }
    }

    public static void saveUnionPushRecord(PipelineConfig pipelineConfig, List<UnionPushRecordObject> unionPushRecordObjectList, Long targetBillId) {
        if (pipelineConfig instanceof PushPipelineConfig && CollectionUtils.isNotEmpty(unionPushRecordObjectList)) {
            Date now = TimeServiceHelper.now();
            Long userId = RequestContext.get().getCurrUserId();
            String traceId = RequestContext.get().getTraceId();
            List filterRecords = unionPushRecordObjectList.stream().filter(item -> targetBillId.equals(item.getTgtObj().getBillId())).collect(Collectors.toList());
            DynamicObject[] unionPushRecordDyms = new DynamicObject[filterRecords.size()];
            for (int i = 0; i < filterRecords.size(); ++i) {
                UnionPushRecordObject.UnionPushEntity tgtObj;
                UnionPushRecordObject.UnionPushEntity relObj;
                UnionPushRecordObject unionPushRecordObject = (UnionPushRecordObject)filterRecords.get(i);
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"msisv_unionpush_record");
                dynamicObject.set("unionpush", (Object)pipelineConfig.getPipelineId());
                dynamicObject.set("traceid", (Object)traceId);
                dynamicObject.set("creator", (Object)userId);
                dynamicObject.set("createdate", (Object)now);
                UnionPushRecordObject.UnionPushEntity srcObj = unionPushRecordObject.getSrcObj();
                if (null != srcObj) {
                    dynamicObject.set("srcentity", (Object)srcObj.getEntityType());
                    dynamicObject.set("srcbillno", (Object)srcObj.getBillNo());
                    dynamicObject.set("srcbillid", (Object)srcObj.getBillId());
                    dynamicObject.set("srcentryid", (Object)srcObj.getEntryId());
                }
                if (null != (relObj = unionPushRecordObject.getRelObj())) {
                    dynamicObject.set("relentity", (Object)relObj.getEntityType());
                    dynamicObject.set("relbillno", (Object)relObj.getBillNo());
                    dynamicObject.set("relbillid", (Object)relObj.getBillId());
                    dynamicObject.set("relentryid", (Object)relObj.getEntryId());
                }
                if (null != (tgtObj = unionPushRecordObject.getTgtObj())) {
                    dynamicObject.set("tgtentity", (Object)tgtObj.getEntityType());
                    dynamicObject.set("tgtbillno", (Object)tgtObj.getBillNo());
                    dynamicObject.set("tgtbillid", (Object)tgtObj.getBillId());
                    dynamicObject.set("tgtentryid", (Object)tgtObj.getEntryId());
                }
                unionPushRecordDyms[i] = dynamicObject;
            }
            try (TXHandle h = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])unionPushRecordDyms);
            }
        }
    }

    public static List<UnionPushRecordObject> loadUnionPushRecord(PipelineConfig pipelineConfig, String entityNumber, List<IntegrationObject> bizObjects) {
        String className = pipelineConfig.getPipeline();
        Object[] pushPipelineList = new String[]{ListenerPushPipeline.class.getName(), RelationPushPipeline.class.getName()};
        if (!ArrayUtils.contains((Object[])pushPipelineList, (Object)className)) {
            return Collections.emptyList();
        }
        PushPipelineConfig pushPipelineConfig = (PushPipelineConfig)pipelineConfig;
        MasterQtyPropConfig masterQtyPropConfig = pushPipelineConfig.getRelationObjectConfig().getMasterQtyPropConfig();
        String tgtQtyField = masterQtyPropConfig.getTargetBillMasterQtyPropName();
        String srcEntity = pushPipelineConfig.getBotpConfig().getSourceBizObjectConfig().getBillNumber();
        String tgtEntity = pushPipelineConfig.getBotpConfig().getTargetBizObjectConfig().getBillNumber();
        String relEntity = pushPipelineConfig.getRelationObjectConfig().getRelationBizObjectConfig().getBillNumber();
        Set billIds = bizObjects.stream().map(IntegrationObject::getBillPkValue).collect(Collectors.toSet());
        Set entryIds = bizObjects.stream().map(IntegrationObject::getEntryPkValue).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        if (ListenerPushPipeline.class.getName().equals(className)) {
            qFilter.and("srcentity", "=", (Object)entityNumber);
            qFilter.and("srcbillid", "in", billIds);
            qFilter.and("srcentryid", "in", entryIds);
            qFilter.and("relentity", "=", (Object)relEntity);
            qFilter.and("tgtentity", "=", (Object)tgtEntity);
        } else if (RelationPushPipeline.class.getName().equals(className)) {
            qFilter.and("relentity", "=", (Object)entityNumber);
            qFilter.and("relbillid", "in", billIds);
            qFilter.and("relentryid", "in", entryIds);
            qFilter.and("srcentity", "=", (Object)srcEntity);
            qFilter.and("tgtentity", "=", (Object)tgtEntity);
        }
        DynamicObjectCollection unionPushRecords = QueryServiceHelper.query((String)"msisv_unionpush_record", (String)"unionpush,relentity,relbillid,relentryid,tgtentity,tgtbillid,tgtentryid", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)unionPushRecords)) {
            return Collections.emptyList();
        }
        Map<Long, BigDecimal> tgtQtyMap = UnionPushRecordService.getEntryQtyMap(tgtEntity, tgtQtyField, (List<DynamicObject>)unionPushRecords, "tgtbillid", "tgtentryid", null);
        Iterator iterator = unionPushRecords.iterator();
        while (iterator.hasNext()) {
            DynamicObject dym = (DynamicObject)iterator.next();
            Long tgtentryid = dym.getLong("tgtentryid");
            if (tgtQtyMap.containsKey(tgtentryid)) continue;
            iterator.remove();
        }
        return unionPushRecords.stream().map(UnionPushRecordObject::new).collect(Collectors.toList());
    }

    public static Map<Long, BigDecimal> getEntryQtyMap(String entityType, String qtyField, List<DynamicObject> unionPushRecords, String billid, String entryid, String filterFormula) {
        String entryType = EntityHelper.findEntryType(entityType, qtyField);
        QFilter qfilter = UnionPushRecordService.buildFilter(unionPushRecords, billid, entryid, entryType);
        if (StringUtils.isNotBlank((CharSequence)filterFormula)) {
            qfilter.and(QFilter.of((String)filterFormula, (Object[])new Object[0]));
        }
        UnionPushRecordService.addChargeOffFilter(qfilter, entityType);
        String selectFields = "id," + qtyField;
        selectFields = StringUtils.isNotBlank((CharSequence)entryType) ? selectFields + "," + entryType + ".id as entryid" : selectFields + ",id as entryid";
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityType, (String)selectFields, (QFilter[])qfilter.toArray());
        if (CollectionUtils.isEmpty((Collection)bills)) {
            return Collections.emptyMap();
        }
        HashMap<Long, BigDecimal> qtyMap = new HashMap<Long, BigDecimal>(bills.size());
        for (DynamicObject bill : bills) {
            qtyMap.put(bill.getLong("entryid"), bill.getBigDecimal(qtyField).abs());
        }
        return qtyMap;
    }

    private static QFilter buildFilter(List<DynamicObject> unionPushRecords, String idField, String entryIdField, String entryType) {
        Set billIds = unionPushRecords.stream().map(item -> item.getLong(idField)).collect(Collectors.toSet());
        Set entryIds = unionPushRecords.stream().map(item -> item.getLong(entryIdField)).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", billIds);
        if (StringUtils.isNotBlank((CharSequence)entryType)) {
            qFilter.and(entryType + ".id", "in", entryIds);
        }
        return qFilter;
    }

    public static Map<Long, BigDecimal> queryPushedRemainQty(PipelineConfig pipelineConfig, String entityNumber, List<IntegrationObject> integrationObjectList, boolean returnRelQty) {
        HashMap<Long, Collection<Long>> billIdMap = new HashMap<Long, Collection<Long>>(2);
        for (IntegrationObject integrationObject : integrationObjectList) {
            Long billId = (Long)integrationObject.getBillPkValue();
            HashSet<Long> entryIds = (HashSet<Long>)billIdMap.get(billId);
            if (null == entryIds) {
                entryIds = new HashSet<Long>(2);
                billIdMap.put(billId, entryIds);
            }
            entryIds.add((Long)integrationObject.getEntryPkValue());
        }
        return UnionPushRecordService.queryPushedRemainQty(pipelineConfig, entityNumber, billIdMap, returnRelQty);
    }

    public static Map<Long, BigDecimal> queryPushedRemainQty(PipelineConfig pipelineConfig, String entityNumber, Map<Long, Collection<Long>> billIdMap, boolean returnRelQty) {
        String className = pipelineConfig.getPipeline();
        Object[] pushPipelineList = new String[]{ListenerPushPipeline.class.getName(), RelationPushPipeline.class.getName()};
        if (!ArrayUtils.contains((Object[])pushPipelineList, (Object)className)) {
            return Collections.emptyMap();
        }
        PushPipelineConfig pushPipelineConfig = (PushPipelineConfig)pipelineConfig;
        MasterQtyPropConfig masterQtyPropConfig = pushPipelineConfig.getRelationObjectConfig().getMasterQtyPropConfig();
        String srcEntity = pushPipelineConfig.getBotpConfig().getSourceBizObjectConfig().getBillNumber();
        String tgtEntity = pushPipelineConfig.getBotpConfig().getTargetBizObjectConfig().getBillNumber();
        String tgtQtyField = masterQtyPropConfig.getTargetBillMasterQtyPropName();
        String relEntity = pushPipelineConfig.getRelationObjectConfig().getRelationBizObjectConfig().getBillNumber();
        String relQtyField = masterQtyPropConfig.getRelationBillMasterQtyPropName();
        Set<Long> billIds = billIdMap.keySet();
        HashSet<Long> entryIds = new HashSet<Long>(billIds.size());
        for (Map.Entry<Long, Collection<Long>> mapEntry : billIdMap.entrySet()) {
            entryIds.addAll(mapEntry.getValue());
        }
        boolean isRel = RelationPushPipeline.class.getName().equals(className);
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        if (ListenerPushPipeline.class.getName().equals(className)) {
            qFilter.and("srcentity", "=", (Object)entityNumber);
            qFilter.and("srcbillid", "in", billIds);
            qFilter.and("srcentryid", "in", entryIds);
            qFilter.and("relentity", "=", (Object)relEntity);
            qFilter.and("tgtentity", "=", (Object)tgtEntity);
        } else if (RelationPushPipeline.class.getName().equals(className)) {
            qFilter.and("relentity", "=", (Object)entityNumber);
            qFilter.and("relbillid", "in", billIds);
            qFilter.and("relentryid", "in", entryIds);
            qFilter.and("srcentity", "=", (Object)srcEntity);
            qFilter.and("tgtentity", "=", (Object)tgtEntity);
        }
        HashSet<Long> validateUnionPushIds = new HashSet<Long>(2);
        validateUnionPushIds.add(pipelineConfig.getPipelineId());
        Object unionPushRecords = QueryServiceHelper.query((String)"msisv_unionpush_record", (String)"unionpush,srcentity,srcbillid,srcentryid,relentity,relbillid,relentryid,tgtentity,tgtbillid,tgtentryid", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)unionPushRecords)) {
            return Collections.emptyMap();
        }
        Set unionPushIds = unionPushRecords.stream().map(item -> item.getLong("unionpush")).collect(Collectors.toSet());
        QFilter idFileter = new QFilter("id", "in", unionPushIds);
        Map configMap = BusinessDataServiceHelper.loadFromCache((String)"msisv_unionpush", (String)"srcbillmainfieldkey,relateobjmainfieldkey,tarbillmainfieldkey", (QFilter[])idFileter.toArray());
        MultiKeyMap qtyMap = new MultiKeyMap();
        qtyMap.put((Object)masterQtyPropConfig.getSourceBillMasterQtyPropName(), (Object)masterQtyPropConfig.getRelationBillMasterQtyPropName(), (Object)masterQtyPropConfig.getTargetBillMasterQtyPropName(), (Object)"1");
        for (Map.Entry entry : configMap.entrySet()) {
            DynamicObject configDym = (DynamicObject)entry.getValue();
            if (!qtyMap.containsKey((Object)configDym.getString("srcbillmainfieldkey"), (Object)configDym.getString("relateobjmainfieldkey"), (Object)configDym.getString("tarbillmainfieldkey"))) continue;
            validateUnionPushIds.add((Long)entry.getKey());
        }
        unionPushRecords = unionPushRecords.stream().filter(item -> validateUnionPushIds.contains(item.getLong("unionpush"))).collect(Collectors.toList());
        String targetFormula = pushPipelineConfig.getBotpConfig().getTargetBillFilterExpression();
        Map<Long, BigDecimal> relQtyMap = UnionPushRecordService.getEntryQtyMap(relEntity, relQtyField, (List<DynamicObject>)unionPushRecords, "relbillid", "relentryid", null);
        Map<Long, BigDecimal> tgtQtyMap = UnionPushRecordService.getEntryQtyMap(tgtEntity, tgtQtyField, (List<DynamicObject>)unionPushRecords, "tgtbillid", "tgtentryid", targetFormula);
        HashMap<Long, BigDecimal> relCalQtyMap = new HashMap<Long, BigDecimal>(unionPushRecords.size());
        Iterator iterator = unionPushRecords.iterator();
        while (iterator.hasNext()) {
            DynamicObject dym = (DynamicObject)iterator.next();
            Long relentryid = dym.getLong("relentryid");
            Long tgtentryid = dym.getLong("tgtentryid");
            BigDecimal tgtQty = tgtQtyMap.get(tgtentryid);
            tgtQty = (BigDecimal)ObjectUtils.defaultIfNull((Object)tgtQty, (Object)BigDecimal.ZERO);
            BigDecimal relCalQty = (BigDecimal)relCalQtyMap.get(relentryid);
            relCalQty = (BigDecimal)ObjectUtils.defaultIfNull((Object)relCalQty, (Object)BigDecimal.ZERO);
            relCalQtyMap.put(relentryid, relCalQty.abs().add(tgtQty.abs()));
        }
        String entryIdField = isRel ? "relentryid" : "srcentryid";
        HashMap<Long, BigDecimal> remainAbsQtyMap = new HashMap<Long, BigDecimal>(unionPushRecords.size());
        Iterator iterator2 = unionPushRecords.iterator();
        while (iterator2.hasNext()) {
            DynamicObject unionPushRecord = (DynamicObject)iterator2.next();
            Long relentryid = unionPushRecord.getLong("relentryid");
            BigDecimal relQty = relQtyMap.get(relentryid);
            relQty = (BigDecimal)ObjectUtils.defaultIfNull((Object)relQty, (Object)BigDecimal.ZERO);
            BigDecimal relCalQty = (BigDecimal)relCalQtyMap.get(relentryid);
            if (returnRelQty) {
                remainAbsQtyMap.put(relentryid, relQty.abs().subtract(relCalQty));
                continue;
            }
            BigDecimal remainQty = (BigDecimal)remainAbsQtyMap.get(unionPushRecord.getLong(entryIdField));
            if (null != remainQty && remainQty.compareTo(BigDecimal.ZERO) > 0) continue;
            remainAbsQtyMap.put(unionPushRecord.getLong(entryIdField), relQty.abs().subtract(relCalQty));
        }
        return remainAbsQtyMap;
    }
}

