/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msisv.isomorphism.common.helper.FormShowHelper;
import kd.mpscmm.msisv.isomorphism.common.util.FormUtils;

public class EcologicMonitorEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
BeforeQuickAddNewListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"type", "serviceaction", "monitoroperation"});
        FormUtils.addF7Listener(this, "monitorobj", "pushaction", "updateaction");
        BasedataEdit pushEdit = (BasedataEdit)this.getControl("pushaction");
        pushEdit.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
        BasedataEdit updateEdit = (BasedataEdit)this.getControl("updateaction");
        updateEdit.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.isChange(e)) {
            return;
        }
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (propertyName) {
            case "monitorobj": {
                this.monitorObjChange(newValue, oldValue);
                break;
            }
            case "monitoroperation": {
                this.operationChange(newValue);
                break;
            }
            case "pushaction": 
            case "updateaction": {
                this.pushAndUpdateActionChange(rowIndex);
                break;
            }
            case "type": {
                this.typeChange(newValue, rowIndex);
                break;
            }
            case "serviceaction": {
                this.serviceActionChange(newValue, rowIndex);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String fieldKey;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (fieldKey = control.getKey()) {
            case "serviceaction": {
                this.clickInvokeService(control);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowHelper.setOperationItems(this.getModel(), this.getView(), "monitorobj", "monitoroperation");
        this.updateCommonFilter();
        FilterGrid filterGrid = (FilterGrid)this.getControl("commonfilter");
        String commonFilterJson = this.getModel().getDataEntity().getString("filterjson_tag");
        FilterCondition condition = StringUtils.isBlank((CharSequence)commonFilterJson) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)commonFilterJson, FilterCondition.class);
        filterGrid.SetValue(condition);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateActionEntry();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if ("actionentry".equals(entryName)) {
            RowDataEntity[] rows;
            for (RowDataEntity row : rows = e.getRowDataEntities()) {
                int rowIndex = row.getRowIndex();
                DynamicObject actionEntry = row.getDataEntity();
                String type = actionEntry.getString("type");
                this.setActionEnable(type, rowIndex);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        String customValue = event.getCustomVaule();
        if ("monitorobjCB".equals(callBackId)) {
            this.monitorConfirmCB(result, customValue);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (actionId == null || returnData == null) {
            return;
        }
        if ("serviceactionCB".equals(actionId)) {
            this.closeCallServiceAction(returnData);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent selectEvent) {
        String propertyName = selectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)selectEvent.getFormShowParameter();
        DynamicObject monitorObj = this.getModel().getDataEntity().getDynamicObject("monitorobj");
        switch (propertyName) {
            case "monitorobj": {
                this.beforeF7Monitor(showParameter);
                break;
            }
            case "pushaction": 
            case "updateaction": {
                this.beforeF7Action(selectEvent, showParameter, monitorObj);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                this.beforeSave();
                break;
            }
        }
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent e) {
        DynamicObject monitorObj;
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if (("pushaction".equals(key) || "updateaction".equals(key)) && (monitorObj = this.getModel().getDataEntity().getDynamicObject("monitorobj")) != null) {
            e.getShowParameter().setCustomParam("quickAddNew", (Object)Boolean.TRUE);
            e.getShowParameter().setCustomParam("monitorobj", monitorObj.getPkValue());
        }
    }

    private void clickInvokeService(Control control) {
        int currentRowIndex = control.getModel().getEntryCurrentRowIndex("actionentry");
        DynamicObject monitorObj = this.getModel().getDataEntity().getDynamicObject("monitorobj");
        if (monitorObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76d1\u542c\u5bf9\u8c61\u3002", (String)"EcologicMonitorEditPlugin_0", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        String serviceAction = (String)this.getModel().getValue("serviceactionjson_tag", currentRowIndex);
        FormShowHelper.showEntryRegisterForm((AbstractFormPlugin)this, currentRowIndex, serviceAction, "serviceactionCB");
    }

    private void beforeF7Monitor(ListShowParameter showParameter) {
        QFilter billFilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        showParameter.getListFilterParameter().setFilter(billFilter);
    }

    private void beforeF7Action(BeforeF7SelectEvent e, ListShowParameter showParameter, DynamicObject monitorObj) {
        if (monitorObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76d1\u542c\u5bf9\u8c61\u3002", (String)"EcologicMonitorEditPlugin_0", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String monitorNum = monitorObj.getString("number");
        QFilter monitorFilter = new QFilter("monitorobj.number", "=", (Object)monitorNum).and("enable", "=", (Object)"1");
        showParameter.getListFilterParameter().setFilter(monitorFilter);
    }

    private void beforeSave() {
        IDataModel model = this.getModel();
        FilterGrid grid = (FilterGrid)this.getControl("commonfilter");
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        DynamicObject monitorObj = this.getModel().getDataEntity().getDynamicObject("monitorobj");
        if (monitorObj == null) {
            return;
        }
        String monitorObjNum = monitorObj.getString("number");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)monitorObjNum);
        FilterBuilder filterBuilder = new FilterBuilder(entityType, condition);
        filterBuilder.buildFilter(false);
        String[] scripts = filterBuilder.buildFilterScript();
        model.setValue("filterjson_tag", (Object)jsonStr);
        model.setValue("filterformula_tag", (Object)scripts[0]);
    }

    private void monitorObjChange(Object newValue, Object oldValue) {
        if (oldValue != null) {
            DynamicObject oldMonitor = (DynamicObject)oldValue;
            HashMap<String, Object> confirmInfo = new HashMap<String, Object>(16);
            confirmInfo.put("monitorobj", oldMonitor.getPkValue());
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u76d1\u542c\u5bf9\u8c61\u5c06\u6e05\u9664\u9875\u9762\u76d1\u542c\u5bf9\u8c61\u914d\u7f6e\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"EcologicMonitorEditPlugin_1", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("monitorobjCB", (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        } else {
            this.updateBizApp();
            this.updateCommonFilter();
            FormShowHelper.setOperationItems(this.getModel(), this.getView(), "monitorobj", "monitoroperation");
            this.getModel().setValue("monitoroperation", null);
        }
    }

    private void operationChange(Object newValue) {
        if (newValue != null) {
            DynamicObject monitorObj = this.getModel().getDataEntity().getDynamicObject("monitorobj");
            if (monitorObj == null) {
                return;
            }
            String monitorObjNum = monitorObj.getString("number");
            List operations = EntityMetadataCache.getDataEntityOperate((String)monitorObjNum);
            for (Map operation : operations) {
                String opKey = (String)operation.get("key");
                if (!opKey.equals(newValue)) continue;
                this.getModel().setValue("operationname", operation.get("name"));
            }
        } else {
            this.getModel().setValue("operationname", null);
        }
    }

    private void pushAndUpdateActionChange(int rowIndex) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("actionentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length != 0) {
            int selectRow = selectRows[0];
            Object type = this.getModel().getValue("type", selectRow);
            this.getModel().setValue("type", type, rowIndex);
        }
    }

    private void serviceActionChange(Object newValue, int rowIndex) {
        if (newValue == null || "".equals(newValue)) {
            this.getModel().setValue("serviceactionjson_tag", null, rowIndex);
        }
    }

    private void typeChange(Object newValue, int rowIndex) {
        this.setActionEnable((String)newValue, rowIndex);
    }

    private void monitorConfirmCB(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            FormShowHelper.setOperationItems(this.getModel(), this.getView(), "monitorobj", "monitoroperation");
            this.getModel().setValue("monitoroperation", null);
            this.updateBizApp();
            this.updateCommonFilter();
            this.getModel().setValue("filterformula_tag", null);
            this.getModel().setValue("filterjson_tag", null);
            this.getModel().deleteEntryData("actionentry");
            this.getModel().createNewEntryRow("actionentry");
        } else {
            Object monitorObj = confirmInfo.get("monitorobj");
            this.getModel().beginInit();
            this.getModel().setValue("monitorobj", monitorObj);
            this.getView().updateView("monitorobj");
            this.getModel().endInit();
        }
    }

    private void closeCallServiceAction(Object returnData) {
        String cacheRowIndex = this.getPageCache().get("rowIndex");
        if (cacheRowIndex == null) {
            return;
        }
        int rowIndex = Integer.parseInt(cacheRowIndex);
        Map serviceMap = (Map)returnData;
        this.getModel().setValue("serviceaction", serviceMap.get("displayname"), rowIndex);
        this.getModel().setValue("serviceactionjson_tag", (Object)SerializationUtils.toJsonString((Object)serviceMap), rowIndex);
    }

    private void updateActionEntry() {
        DynamicObjectCollection actionEntrys = this.getModel().getDataEntity().getDynamicObjectCollection("actionentry");
        for (int i = 0; i < actionEntrys.size(); ++i) {
            DynamicObject actionEntry = (DynamicObject)actionEntrys.get(i);
            String type = actionEntry.getString("type");
            this.setActionEnable(type, i);
        }
        this.getView().updateView("actionentry");
    }

    private void setActionEnable(String type, int rowIndex) {
        if (StringUtils.isBlank((CharSequence)type)) {
            this.getModel().setValue("pushaction", null, rowIndex);
            this.getModel().setValue("updateaction", null, rowIndex);
            this.getModel().setValue("serviceaction", null, rowIndex);
            this.getModel().setValue("serviceactionjson_tag", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"pushaction", "updateaction", "serviceaction"});
            return;
        }
        switch (type) {
            case "A": {
                this.getModel().setValue("updateaction", null, rowIndex);
                this.getModel().setValue("serviceaction", null, rowIndex);
                this.getModel().setValue("serviceactionjson_tag", null, rowIndex);
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"pushaction"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"updateaction", "serviceaction"});
                break;
            }
            case "B": {
                this.getModel().setValue("pushaction", null, rowIndex);
                this.getModel().setValue("serviceaction", null, rowIndex);
                this.getModel().setValue("serviceactionjson_tag", null, rowIndex);
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"updateaction"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"pushaction", "serviceaction"});
                break;
            }
            case "C": {
                this.getModel().setValue("pushaction", null, rowIndex);
                this.getModel().setValue("updateaction", null, rowIndex);
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"serviceaction"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"pushaction", "updateaction"});
                break;
            }
        }
    }

    private void updateBizApp() {
        DynamicObject monitorObj = this.getModel().getDataEntity().getDynamicObject("monitorobj");
        if (monitorObj == null) {
            this.getModel().setValue("bizapp", null);
        } else {
            DynamicObject bizAppId = monitorObj.getDynamicObject("bizappid");
            this.getModel().setValue("bizapp", (Object)bizAppId);
        }
    }

    private void updateCommonFilter() {
        DynamicObject monitorObj = this.getModel().getDataEntity().getDynamicObject("monitorobj");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfilter");
        if (monitorObj == null) {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(new ArrayList());
            filterGrid.setEntityNumber(null);
        } else {
            String monitorObjNum = monitorObj.getString("number");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)monitorObjNum);
            FilterFieldBuildOption option = new FilterFieldBuildOption();
            option.addInvalidClassTypes(FlexProp.class);
            option.addInvalidClassTypes(MuliLangTextProp.class);
            option.getSelectedEntity().add(monitorObjNum);
            List filterColumns = FormTreeBuilder.buildFilterColumns((MainEntityType)entityType, (FilterFieldBuildOption)option);
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(filterColumns);
        }
        this.getView().updateView("commonfilter");
    }

    private boolean isChange(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        if (newValue instanceof DynamicObject && oldValue instanceof DynamicObject && ((DynamicObject)newValue).getPkValue().equals(((DynamicObject)oldValue).getPkValue())) {
            return false;
        }
        return !(newValue instanceof BigDecimal) || !(oldValue instanceof BigDecimal) || ((BigDecimal)newValue).compareTo((BigDecimal)oldValue) != 0;
    }
}

