/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msisv.isomorphism.common.consts.PropertyDataType;
import kd.mpscmm.msisv.isomorphism.common.helper.FieldLangFormTranslator;
import kd.mpscmm.msisv.isomorphism.common.helper.FormShowHelper;
import kd.mpscmm.msisv.isomorphism.common.util.strategy.EntrySelectStrategy;
import kd.mpscmm.msisv.isomorphism.form.base.BaseEditPlugin;

public class RelateUpdateEditPlugin
extends BaseEditPlugin {
    private static final Log log = LogFactory.getLog(RelateUpdateEditPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"tarbillmatchfield", "condition"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        IDataModel model = this.getModel();
        Control control = (Control)evt.getSource();
        String fieldKey = control.getKey();
        DynamicObject monitorObj = model.getDataEntity().getDynamicObject("monitorobj");
        if (monitorObj == null) {
            return;
        }
        switch (fieldKey) {
            case "tarbillmatchfield": {
                this.clickTarBillMatchField(model, control);
                break;
            }
            case "condition": {
                this.clickTarBillCondition(model, control);
                break;
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.translate();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.translate();
    }

    private void translate() {
        try {
            IDataModel model = this.getModel();
            Object relObj = model.getValue("relateobj");
            Object targetObj = model.getValue("tarbill");
            String relBillNumber = relObj instanceof DynamicObject ? ((DynamicObject)relObj).getString("number") : "";
            String targetObjNumber = targetObj instanceof DynamicObject ? ((DynamicObject)targetObj).getString("number") : "";
            FieldLangFormTranslator fieldLangFormTranslator = FieldLangFormTranslator.create(this.getModel());
            fieldLangFormTranslator.headFieldTranslate(relBillNumber, "relateobjmainfieldkey", "relateobjmainfield");
            fieldLangFormTranslator.headFieldTranslate(targetObjNumber, "tarbillmainfieldkey", "tarbillmainfield");
            fieldLangFormTranslator.entryFieldTranslate("matchentry", relBillNumber, "relateobjmatchfieldkey", "relateobjmatchfield");
            fieldLangFormTranslator.entryFieldTranslate("matchentry", relBillNumber, "tarbillmatchfieldkey", "tarbillmatchfield");
            fieldLangFormTranslator.filterTranslate(relBillNumber, "relateobjfilterjson_tag", "relateobjfilter");
            fieldLangFormTranslator.entryFieldTranslate("assignentry", relBillNumber, "relateobjassignfieldkey", "relateobjassignfield");
            fieldLangFormTranslator.entryFieldTranslate("assignentry", targetObjNumber, "tarbillassignfieldkey", "tarbillassignfield");
            fieldLangFormTranslator.entryFilterTranslate("operateentry", relBillNumber, "conditionjson_tag", "condition");
            model.setDataChanged(false);
        }
        catch (Exception e) {
            log.error("\u591a\u8bed\u8a00\u7ffb\u8bd1\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (propertyName) {
            case "monitorobj": {
                this.monitorObjChange(newValue, oldValue);
                break;
            }
            case "relateobj": {
                this.relateObjChange();
                break;
            }
            case "tarbillmatchfield": {
                this.entryFieldChange(newValue, "tarbillmatchfieldkey", rowIndex);
                break;
            }
            case "condition": {
                this.entryConditionChange(newValue, "conditionformula_tag", "conditionjson_tag", rowIndex);
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        String returnData = (String)evt.getReturnData();
        IDataModel dataModel = this.getModel();
        IPageCache pageCache = this.getPageCache();
        if (actionId == null || returnData == null) {
            return;
        }
        switch (actionId) {
            case "tarbillmatchfieldCB": {
                FormShowHelper.closeCallSetEntryField(dataModel, pageCache, returnData, "tarbillmatchfield", "tarbillmatchfieldkey");
                break;
            }
            case "conditionCB": {
                FormShowHelper.closeCallSetEntryCondition(dataModel, pageCache, returnData, "condition", "conditionjson_tag", "conditionformula_tag");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent closedEvent) {
        super.confirmCallBack(closedEvent);
        String callBackId = closedEvent.getCallBackId();
        MessageBoxResult result = closedEvent.getResult();
        String customValue = closedEvent.getCustomVaule();
        switch (callBackId) {
            case "monitorobjCB": {
                this.monitorConfirmCB(result, customValue);
                break;
            }
            case "tarbillCB": {
                this.tarBillConfirmCB(result, customValue);
                break;
            }
        }
    }

    private void monitorObjChange(Object newValue, Object oldValue) {
        if (oldValue != null) {
            DynamicObject oldMonitor = (DynamicObject)oldValue;
            HashMap<String, Object> confirmInfo = new HashMap<String, Object>(16);
            confirmInfo.put("monitorobj", oldMonitor.getPkValue());
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u76d1\u542c\u5bf9\u8c61\u5c06\u6e05\u9664\u9875\u9762\u7684\u76ee\u6807\u5355\u636e\u548c\u5173\u8054\u5bf9\u8c61\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"RelateUpdateEditPlugin_1", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("monitorobjCB", (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        } else {
            this.getModel().setValue("relateobj", newValue);
        }
    }

    private void relateObjChange() {
        this.getModel().setValue("relateobjfilter", null);
    }

    private void monitorConfirmCB(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.getModel().beginInit();
            this.getModel().setValue("tarbill", null);
            this.getModel().endInit();
            this.getView().updateView("tarbill");
            Object newMonitorObj = this.getModel().getValue("monitorobj");
            this.getModel().setValue("relateobj", newMonitorObj);
            this.deleteFieldAndEntry();
        } else {
            Object monitorObj = confirmInfo.get("monitorobj");
            this.getModel().beginInit();
            this.getModel().setValue("monitorobj", monitorObj);
            this.getView().updateView("monitorobj");
            this.getModel().endInit();
        }
    }

    private void tarBillConfirmCB(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.deleteFieldAndEntry();
        } else {
            Object tarBill = confirmInfo.get("tarbill");
            this.getModel().beginInit();
            this.getModel().setValue("tarbill", tarBill);
            this.getView().updateView("tarbill");
            this.getModel().endInit();
        }
    }

    private void filterChange(Object newValue, String filterFormula, String filterJson) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(filterFormula, null);
            this.getModel().setValue(filterJson, null);
        }
    }

    private void entryConditionChange(Object newValue, String conditionFormula, String conditionJson, int rowIndex) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(conditionFormula, null, rowIndex);
            this.getModel().setValue(conditionJson, null, rowIndex);
        }
    }

    private void entryFieldChange(Object newValue, String filedKey, int rowIndex) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(filedKey, null, rowIndex);
        }
    }

    private void clickTarBillCondition(IDataModel model, Control control) {
        int currentRowIndex = control.getModel().getEntryCurrentRowIndex("operateentry");
        DynamicObject targetBill = model.getDataEntity().getDynamicObject("tarbill");
        if (targetBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76ee\u6807\u5355\u636e\u3002", (String)"RelateUpdateEditPlugin_0", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        String tarBillNum = targetBill.getString("number");
        FormShowHelper.showEntryFilterForm((AbstractFormPlugin)this, model, tarBillNum, currentRowIndex, "conditionjson_tag", "conditionCB");
    }

    private void clickTarBillMatchField(IDataModel model, Control control) {
        int currentRowIndex = control.getModel().getEntryCurrentRowIndex("matchentry");
        DynamicObject tarBill = model.getDataEntity().getDynamicObject("tarbill");
        if (tarBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76ee\u6807\u5355\u636e\u3002", (String)"RelateUpdateEditPlugin_0", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        String tarBillNum = tarBill.getString("number");
        ArrayList<String> filterFields = new ArrayList<String>(16);
        DynamicObjectCollection matchEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("matchentry");
        for (DynamicObject matchEntry : matchEntrys) {
            String tarMatchField = matchEntry.getString("tarbillmatchfieldkey");
            filterFields.add(tarMatchField);
        }
        FormShowHelper.showEntryColsTreeForm((AbstractFormPlugin)this, tarBillNum, currentRowIndex, new EntrySelectStrategy(), filterFields, Boolean.TRUE, "tarbillmatchfieldCB", new PropertyDataType[0]);
    }

    private void deleteFieldAndEntry() {
        this.getModel().setValue("tarbillfilter", null);
        this.getModel().setValue("tarbillmainfield", null);
        this.getModel().setValue("relateobjmainfield", null);
        this.getModel().deleteEntryData("matchentry");
        this.getModel().createNewEntryRow("matchentry");
        this.getModel().deleteEntryData("assignentry");
        this.getModel().createNewEntryRow("assignentry");
        this.getModel().deleteEntryData("operateentry");
        this.getModel().createNewEntryRow("operateentry");
        FormShowHelper.setOperationItems(this.getModel(), this.getView(), "tarbill", "operation");
    }
}

