/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msisv.isomorphism.common.consts.PropertyDataType;
import kd.mpscmm.msisv.isomorphism.common.helper.FieldLangFormTranslator;
import kd.mpscmm.msisv.isomorphism.common.helper.FormShowHelper;
import kd.mpscmm.msisv.isomorphism.common.helper.SnHelper;
import kd.mpscmm.msisv.isomorphism.common.util.FormUtils;
import kd.mpscmm.msisv.isomorphism.common.util.strategy.EntrySelectStrategy;
import kd.mpscmm.msisv.isomorphism.form.base.BaseEditPlugin;

public class UnionPushEditPlugin
extends BaseEditPlugin {
    private static final Log log = LogFactory.getLog(UnionPushEditPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srcbillfilter", "srcbillmatchfield", "isinvorelateobj", "srcbillmainfield", "assignformula"});
        FormUtils.addF7Listener(this, "botprule", "srcbill");
        UnionPushEditPlugin.showConvertRuleEdit(this.getView(), "botprule");
    }

    public static void showConvertRuleEdit(IFormView view, String botpEdit) {
        BasedataEdit botpIdEdit = (BasedataEdit)view.getControl(botpEdit);
        if (botpIdEdit != null) {
            botpIdEdit.addBeforeF7ViewDetailListener(t -> {
                t.setCancel(true);
                Object pkId = t.getPkId();
                DynamicObject botpObj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkId, (String)"botp_crlist");
                String srcEntity = botpObj.getString("sourceentitynumber.number");
                String tgtEntity = botpObj.getString("targetentitynumber.number");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("botp_convertrule");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("SourceBill", (Object)srcEntity);
                showParameter.setCustomParam("TargetBill", (Object)tgtEntity);
                showParameter.setCustomParam("ruleId", pkId);
                showParameter.getCustomParams().put("checkRightAppId", "bpm");
                showParameter.setPageId(pkId + "_" + srcEntity + "_" + tgtEntity);
                showParameter.setStatus(OperationStatus.VIEW);
                showParameter.setAppId("sbs");
                showParameter.addCustPlugin("kd.mpscmm.msisv.isomorphism.ext.ConvertRuleLockEdit");
                view.showForm(showParameter);
            });
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.enableCarrySn();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.translate();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.translate();
    }

    private void translate() {
        try {
            IDataModel model = this.getModel();
            Object sourceBill = model.getValue("srcbill");
            Object relObj = model.getValue("relateobj");
            Object targetObj = model.getValue("tarbill");
            String sourceBillNumber = sourceBill instanceof DynamicObject ? ((DynamicObject)sourceBill).getString("number") : "";
            String relBillNumber = relObj instanceof DynamicObject ? ((DynamicObject)relObj).getString("number") : "";
            String targetObjNumber = targetObj instanceof DynamicObject ? ((DynamicObject)targetObj).getString("number") : "";
            FieldLangFormTranslator fieldLangFormTranslator = FieldLangFormTranslator.create(this.getModel());
            fieldLangFormTranslator.headFieldTranslate(sourceBillNumber, "srcbillmainfieldkey", "srcbillmainfield");
            fieldLangFormTranslator.headFieldTranslate(relBillNumber, "relateobjmainfieldkey", "relateobjmainfield");
            fieldLangFormTranslator.headFieldTranslate(targetObjNumber, "tarbillmainfieldkey", "tarbillmainfield");
            fieldLangFormTranslator.entryFieldTranslate("matchentry", sourceBillNumber, "srcbillmatchfieldkey", "srcbillmatchfield");
            fieldLangFormTranslator.entryFieldTranslate("matchentry", relBillNumber, "relateobjmatchfieldkey", "relateobjmatchfield");
            fieldLangFormTranslator.filterTranslate(sourceBillNumber, "srcbillfilterjson_tag", "srcbillfilter");
            fieldLangFormTranslator.filterTranslate(relBillNumber, "relateobjfilterjson_tag", "relateobjfilter");
            fieldLangFormTranslator.entryFieldTranslate("assignentry", relBillNumber, "relateobjassignfieldkey", "relateobjassignfield");
            fieldLangFormTranslator.entryFieldTranslate("assignentry", targetObjNumber, "tarbillassignfieldkey", "tarbillassignfield");
            fieldLangFormTranslator.entryFormulaTranslate("assignentry", targetObjNumber, "assignformulajson_tag", "assignformula");
            model.setDataChanged(false);
        }
        catch (Exception e) {
            log.error("\u591a\u8bed\u8a00\u7ffb\u8bd1\u5931\u8d25", (Throwable)e);
        }
    }

    private void enableCarrySn() {
        boolean iscarrysn = false;
        DynamicObject relObj = (DynamicObject)this.getModel().getValue("relateobj");
        if (null != relObj) {
            String entityKey = relObj.getString("number");
            iscarrysn = SnHelper.enableSnCfg(entityKey);
        }
        this.getView().setEnable(Boolean.valueOf(iscarrysn), new String[]{"iscarrysn"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        IDataModel model = this.getModel();
        Control control = (Control)evt.getSource();
        String fieldKey = control.getKey();
        DynamicObject monitorObj = model.getDataEntity().getDynamicObject("monitorobj");
        if (monitorObj == null) {
            return;
        }
        switch (fieldKey) {
            case "srcbillfilter": {
                this.clickSrcBillFilter(model);
                break;
            }
            case "srcbillmainfield": {
                this.clickSrcBillMainField(model);
                break;
            }
            case "srcbillmatchfield": {
                this.clickSrcBillMatchField(model, control);
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String propertyName = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (propertyName) {
            case "srcbill": {
                this.beforeF7SrcBill(e, showParameter);
                break;
            }
            case "botprule": {
                this.beforeF7BotpRule(e, showParameter);
                break;
            }
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        boolean involveRelate = this.getModel().getDataEntity().getBoolean("isinvorelateobj");
        this.getView().setVisible(Boolean.valueOf(involveRelate), new String[]{"flexpanel"});
        if (Boolean.FALSE.equals(involveRelate)) {
            this.getModel().deleteEntryData("matchentry");
            this.getModel().deleteEntryData("assignentry");
            this.getModel().setDataChanged(false);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (propertyName) {
            case "monitorobj": {
                this.monitorObjChange(newValue, oldValue);
                break;
            }
            case "srcbill": {
                this.srcBillChange(oldValue);
                break;
            }
            case "relateobj": {
                this.relateObjChange(oldValue);
                break;
            }
            case "isinvorelateobj": {
                this.involveRelateChange(newValue);
                break;
            }
            case "srcbillfilter": {
                this.filterChange(newValue, "srcbillfilterformula_tag", "srcbillfilterjson_tag");
                break;
            }
            case "srcbillmainfield": {
                this.fieldChange(newValue, "srcbillmainfieldkey");
                break;
            }
            case "srcbillmatchfield": {
                this.entryFieldChange(newValue, "srcbillmatchfieldkey", rowIndex);
                break;
            }
            case "tarbillassignfieldkey": {
                this.tarAssignFieldKeyChange(newValue, rowIndex);
                break;
            }
            case "assignmethod": {
                this.assignMethodChange(newValue, rowIndex);
                break;
            }
        }
    }

    @Override
    protected void tarAssignFieldKeyChange(Object newValue, int rowIndex) {
        super.tarAssignFieldKeyChange(newValue, rowIndex);
        this.getModel().setValue("assignformula", null, rowIndex);
        this.getModel().setValue("assignformulajson_tag", (Object)"A", rowIndex);
    }

    @Override
    protected void assignMethodChange(Object newValue, int rowIndex) {
        super.assignMethodChange(newValue, rowIndex);
        this.getModel().beginInit();
        this.getModel().setValue("assignformula", null, rowIndex);
        this.getModel().setValue("assignformulajson_tag", null, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("assignformula", rowIndex);
        this.getView().updateView("assignformulajson_tag", rowIndex);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        String returnData = (String)evt.getReturnData();
        IDataModel dataModel = this.getModel();
        IPageCache pageCache = this.getPageCache();
        if (actionId == null || returnData == null) {
            return;
        }
        switch (actionId) {
            case "srcbillfilter_CB": {
                FormShowHelper.closeCallSetFilter(dataModel, pageCache, returnData, "srcbillfilter", "srcbillfilterjson_tag", "srcbillfilterformula_tag");
                break;
            }
            case "srcbillmainfieldCB": {
                FormShowHelper.closeCallSetField(dataModel, returnData, "srcbillmainfield", "srcbillmainfieldkey");
                break;
            }
            case "srcbillmatchfieldCB": {
                FormShowHelper.closeCallSetEntryField(dataModel, pageCache, returnData, "srcbillmatchfield", "srcbillmatchfieldkey");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent closedEvent) {
        super.confirmCallBack(closedEvent);
        String callBackId = closedEvent.getCallBackId();
        MessageBoxResult result = closedEvent.getResult();
        String customValue = closedEvent.getCustomVaule();
        switch (callBackId) {
            case "monitorobjCB": {
                this.monitorObjConfirmCB(result, customValue);
                break;
            }
            case "srcbillCB": {
                this.srcBillConfirmCB(result, customValue);
                break;
            }
            case "tarbillCB": {
                this.tarBillConfirmCB(result, customValue);
                break;
            }
            case "relateobjCB": {
                this.relateObjConfirmCB(result, customValue);
                break;
            }
        }
    }

    private void monitorObjChange(Object newValue, Object oldValue) {
        if (oldValue != null) {
            DynamicObject oldMonitor = (DynamicObject)oldValue;
            DynamicObject newMonitor = (DynamicObject)newValue;
            HashMap<String, Object> confirmInfo = new HashMap<String, Object>(16);
            confirmInfo.put("monitorobj", oldMonitor.getPkValue());
            if (newMonitor != null) {
                confirmInfo.put("newmonitorobj", newMonitor.getPkValue());
            }
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u76d1\u542c\u5bf9\u8c61\u5c06\u6e05\u9664\u9875\u9762\u7684\u6765\u6e90\u5355\u636e\u3001\u76ee\u6807\u5355\u636e\u548c\u5173\u8054\u5bf9\u8c61\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"UnionPushEditPlugin_4", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("monitorobjCB", (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        } else {
            boolean isInvolve = this.getModel().getDataEntity().getBoolean("isinvorelateobj");
            if (!isInvolve) {
                this.getModel().setValue("srcbill", newValue);
            } else {
                this.getModel().setValue("relateobj", newValue);
            }
        }
    }

    private void srcBillChange(Object oldValue) {
        if (oldValue != null) {
            DynamicObject oldSrcBill = (DynamicObject)oldValue;
            HashMap<String, Object> confirmInfo = new HashMap<String, Object>(16);
            confirmInfo.put("srcbill", oldSrcBill.getPkValue());
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u6765\u6e90\u5355\u636e\u5c06\u6e05\u9664\u9875\u9762\u7684\u6765\u6e90\u5355\u636e\u914d\u7f6e\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"UnionPushEditPlugin_5", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("srcbillCB", (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        }
    }

    private void relateObjChange(Object oldValue) {
        if (oldValue != null) {
            DynamicObject oldRelateObj = (DynamicObject)oldValue;
            HashMap<String, Object> confirmInfo = new HashMap<String, Object>(16);
            confirmInfo.put("relateobj", oldRelateObj.getPkValue());
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u5173\u8054\u5bf9\u8c61\u5c06\u6e05\u9664\u9875\u9762\u7684\u5173\u8054\u5bf9\u8c61\u914d\u7f6e\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"UnionPushEditPlugin_6", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("relateobjCB", (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        }
        this.enableCarrySn();
    }

    private void monitorObjConfirmCB(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            boolean involveRelate = this.getModel().getDataEntity().getBoolean("isinvorelateobj");
            Object newMonitorObj = confirmInfo.get("newmonitorobj");
            this.getModel().beginInit();
            this.getModel().setValue("srcbill", null);
            this.getModel().endInit();
            this.getView().updateView("srcbill");
            this.getModel().setValue("srcbillfilter", null);
            this.getModel().beginInit();
            this.getModel().setValue("tarbill", null);
            this.getModel().endInit();
            this.getView().updateView("tarbill");
            this.getModel().setValue("tarbillfilter", null);
            this.getModel().setValue("botprule", null);
            this.clearRelateObjConfig();
            if (involveRelate) {
                this.getModel().setValue("relateobj", newMonitorObj);
            }
            this.getModel().endInit();
            this.getView().updateView("relateobj");
            this.getModel().createNewEntryRow("matchentry");
            this.getModel().createNewEntryRow("assignentry");
            this.getModel().deleteEntryData("operateentry");
            this.getModel().createNewEntryRow("operateentry");
            FormShowHelper.setOperationItems(this.getModel(), this.getView(), "tarbill", "operation");
        } else {
            Object oldMonitorObj = confirmInfo.get("monitorobj");
            this.getModel().beginInit();
            this.getModel().setValue("monitorobj", oldMonitorObj);
            this.getView().updateView("monitorobj");
            this.getModel().endInit();
        }
    }

    private void srcBillConfirmCB(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.getModel().setValue("srcbillfilter", null);
            this.getModel().setValue("botprule", null);
            this.getModel().setValue("srcbillmainfield", null);
            this.getModel().setValue("tarbillmainfield", null);
            this.getModel().setValue("relateobjmainfield", null);
            this.getModel().deleteEntryData("matchentry");
            this.getModel().createNewEntryRow("matchentry");
        } else {
            Object srcBill = confirmInfo.get("srcbill");
            this.getModel().beginInit();
            this.getModel().setValue("srcbill", srcBill);
            this.getView().updateView("srcbill");
            this.getModel().endInit();
        }
    }

    private void tarBillConfirmCB(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.getModel().setValue("tarbillfilter", null);
            this.getModel().setValue("botprule", null);
            this.getModel().setValue("srcbillmainfield", null);
            this.getModel().setValue("tarbillmainfield", null);
            this.getModel().setValue("relateobjmainfield", null);
            this.getModel().deleteEntryData("assignentry");
            this.getModel().createNewEntryRow("assignentry");
            this.getModel().deleteEntryData("operateentry");
            this.getModel().createNewEntryRow("operateentry");
            FormShowHelper.setOperationItems(this.getModel(), this.getView(), "tarbill", "operation");
        } else {
            Object tarBill = confirmInfo.get("tarbill");
            this.getModel().beginInit();
            this.getModel().setValue("tarbill", tarBill);
            this.getView().updateView("tarbill");
            this.getModel().endInit();
        }
    }

    private void relateObjConfirmCB(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.getModel().setValue("relateobjfilter", null);
            this.getModel().setValue("srcbillmainfield", null);
            this.getModel().setValue("tarbillmainfield", null);
            this.getModel().setValue("relateobjmainfield", null);
            this.getModel().setValue("iscarrysn", (Object)false);
            this.getModel().deleteEntryData("matchentry");
            this.getModel().createNewEntryRow("matchentry");
            this.getModel().deleteEntryData("assignentry");
            this.getModel().createNewEntryRow("assignentry");
        } else {
            Object relateObj = confirmInfo.get("relateobj");
            this.getModel().beginInit();
            this.getModel().setValue("relateobj", relateObj);
            this.getView().updateView("relateobj");
            this.getModel().endInit();
        }
    }

    private void involveRelateChange(Object newValue) {
        this.getView().setVisible((Boolean)newValue, new String[]{"flexpanel"});
        Object monitorObj = this.getModel().getValue("monitorobj");
        if (Boolean.FALSE.equals(newValue)) {
            this.clearRelateObjConfig();
        } else {
            this.getModel().beginInit();
            this.getModel().setValue("relateobj", monitorObj);
            this.getView().updateView("relateobj");
            this.getModel().endInit();
            this.getModel().createNewEntryRow("matchentry");
            this.getModel().createNewEntryRow("assignentry");
        }
    }

    private void beforeF7SrcBill(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        IDataModel model = this.getModel();
        DynamicObject monitorObj = model.getDataEntity().getDynamicObject("monitorobj");
        if (monitorObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76d1\u542c\u5bf9\u8c61\u3002", (String)"UnionPushEditPlugin_0", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter billFilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        showParameter.getListFilterParameter().setFilter(billFilter);
    }

    private void beforeF7BotpRule(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        IDataModel model = this.getModel();
        DynamicObject monitorObj = model.getDataEntity().getDynamicObject("monitorobj");
        if (monitorObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76d1\u542c\u5bf9\u8c61\u3002", (String)"UnionPushEditPlugin_0", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject srcBill = model.getDataEntity().getDynamicObject("srcbill");
        if (srcBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6765\u6e90\u5355\u636e\u3002", (String)"UnionPushEditPlugin_1", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String srcBillNum = srcBill.getString("number");
        DynamicObject tarBill = model.getDataEntity().getDynamicObject("tarbill");
        if (tarBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76ee\u6807\u5355\u636e\u3002", (String)"UnionPushEditPlugin_3", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String tarBillNum = tarBill.getString("number");
        QFilter botpRuleFilter = new QFilter("sourceentitynumber.number", "=", (Object)srcBillNum).and("targetentitynumber.number", "=", (Object)tarBillNum);
        botpRuleFilter.and("enabled", "=", (Object)Boolean.TRUE);
        showParameter.getListFilterParameter().setFilter(botpRuleFilter);
    }

    private void filterChange(Object newValue, String filterFormula, String filterJson) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(filterFormula, null);
            this.getModel().setValue(filterJson, null);
        }
    }

    private void fieldChange(Object newValue, String fieldKey) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(fieldKey, null);
        }
    }

    protected void entryFieldChange(Object newValue, String filedKey, int rowIndex) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(filedKey, null, rowIndex);
            this.getModel().setValue(filedKey, null, rowIndex);
        }
    }

    private void clickSrcBillFilter(IDataModel model) {
        DynamicObject srcBill = model.getDataEntity().getDynamicObject("srcbill");
        if (srcBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6765\u6e90\u5355\u636e\u3002", (String)"UnionPushEditPlugin_1", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        String tarBillNum = srcBill.getString("number");
        FormShowHelper.showFilterForm((AbstractFormPlugin)this, model, tarBillNum, "srcbillfilterjson_tag", "srcbillfilter_CB");
    }

    private void clickSrcBillMainField(IDataModel model) {
        DynamicObject srcBill = model.getDataEntity().getDynamicObject("srcbill");
        if (srcBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6765\u6e90\u5355\u636e\u3002", (String)"UnionPushEditPlugin_1", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        String srcBillNum = srcBill.getString("number");
        ArrayList<String> filterFields = new ArrayList<String>(16);
        String billFiled = (String)this.getModel().getValue("srcbillmainfieldkey");
        filterFields.add(billFiled);
        FormShowHelper.showColsTreeForm((AbstractFormPlugin)this, srcBillNum, null, filterFields, Boolean.FALSE, "srcbillmainfieldCB", PropertyDataType.QTY);
    }

    private void clickSrcBillMatchField(IDataModel model, Control control) {
        int currentRowIndex = control.getModel().getEntryCurrentRowIndex("matchentry");
        DynamicObject srcBill = model.getDataEntity().getDynamicObject("srcbill");
        if (srcBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u6765\u6e90\u5355\u636e\u3002", (String)"UnionPushEditPlugin_1", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        String srcBillNum = srcBill.getString("number");
        ArrayList<String> filterFields = new ArrayList<String>(16);
        DynamicObjectCollection matchEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("matchentry");
        for (DynamicObject matchEntry : matchEntrys) {
            String srcMatchField = matchEntry.getString("srcbillmatchfieldkey");
            filterFields.add(srcMatchField);
        }
        FormShowHelper.showEntryColsTreeForm((AbstractFormPlugin)this, srcBillNum, currentRowIndex, new EntrySelectStrategy(), filterFields, Boolean.TRUE, "srcbillmatchfieldCB", new PropertyDataType[0]);
    }

    private void clearRelateObjConfig() {
        this.getModel().beginInit();
        this.getModel().setValue("relateobj", null);
        this.getView().updateView("relateobj");
        this.getModel().endInit();
        this.getModel().setValue("relateobjfilter", null);
        this.getModel().setValue("srcbillmainfield", null);
        this.getModel().setValue("tarbillmainfield", null);
        this.getModel().setValue("relateobjmainfield", null);
        this.getModel().deleteEntryData("matchentry");
        this.getModel().deleteEntryData("assignentry");
    }
}

