/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.form.base;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.mpscmm.msisv.isomorphism.common.consts.PropertyDataType;
import kd.mpscmm.msisv.isomorphism.common.helper.FormShowHelper;
import kd.mpscmm.msisv.isomorphism.common.helper.MetaHelper;
import kd.mpscmm.msisv.isomorphism.common.util.FormUtils;
import kd.mpscmm.msisv.isomorphism.common.util.strategy.AssignEntrySelectStrategy;
import kd.mpscmm.msisv.isomorphism.common.util.strategy.EntrySelectStrategy;
import kd.mpscmm.msisv.isomorphism.common.util.strategy.TypeSelectStrategy;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class BaseEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"tarbillfilter", "relateobjfilter", "tarbillmainfield", "relateobjmainfield", "relateobjmatchfield", "tarbillassignfield", "relateobjassignfield"});
        this.addItemClickListeners(new String[]{"tbmain"});
        FormUtils.addF7Listener(this, "monitorobj", "tarbill", "relateobj", "assignmethodbd");
    }

    public void click(EventObject evt) {
        super.click(evt);
        IDataModel model = this.getModel();
        Control control = (Control)evt.getSource();
        String fieldKey = control.getKey();
        DynamicObject monitorObj = model.getDataEntity().getDynamicObject("monitorobj");
        if (monitorObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76d1\u542c\u5bf9\u8c61\u3002", (String)"BaseEditPlugin_0", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        switch (fieldKey) {
            case "tarbillfilter": {
                this.clickTarBillFilter(model);
                break;
            }
            case "relateobjfilter": {
                this.clickRelateObjFilter(model);
                break;
            }
            case "tarbillmainfield": {
                this.clickTarBillMainField(model);
                break;
            }
            case "relateobjmainfield": {
                this.clickRelateObjMainField(model);
                break;
            }
            case "relateobjmatchfield": {
                this.clickRelateObjMatchField(model, control);
                break;
            }
            case "tarbillassignfield": {
                this.clickTarBillAssignField(model, control);
                break;
            }
            case "relateobjassignfield": {
                this.clickRelateObjAssignField(model, control);
                break;
            }
            case "assignformula": {
                this.clickAssignFormula(model, control);
                break;
            }
        }
    }

    private void clickAssignFormula(IDataModel model, Control control) {
        int currentRowIndex = control.getModel().getEntryCurrentRowIndex("assignentry");
        String tarBillNum = model.getDataEntity().getString("tarbill.number");
        if (tarBillNum == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76ee\u6807\u5355\u636e\u3002", (String)"BaseEditPlugin_1", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        String relBillNum = model.getDataEntity().getString("relateobj.number");
        if (relBillNum == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u5173\u8054\u5bf9\u8c61\u3002", (String)"BaseEditPlugin_2", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setOnlyPhysicsField(true);
        option.setIncludePKField(true);
        option.setIncludeEntryEntityAsKeyPrefix(true);
        String targetField = (String)model.getValue("tarbillassignfieldkey", currentRowIndex);
        this.getPageCache().put("rowIndex", String.valueOf(currentRowIndex));
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)relBillNum);
        String fieldformulajson = (String)model.getValue("assignformulajson_tag", currentRowIndex);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainEntityType, (PropTreeBuildOption)option);
        String treeNodeJson = SerializationUtils.toJsonString((Object)treeNode);
        String method = (String)model.getValue("assignmethod", currentRowIndex);
        if ("F".equals(method)) {
            DynamicProperty targetProp = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)targetField);
            FormShowHelper.showConditionFormulaForm(this, tarBillNum, fieldformulajson, treeNodeJson, "ASSIGN_CONDITION_FORMULA_CB", (IDataEntityProperty)targetProp);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (!this.isChange(e)) {
            return;
        }
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (propertyName) {
            case "tarbill": {
                this.tarBillChange(oldValue);
                break;
            }
            case "tarbillfilter": {
                this.filterChange(newValue, "tarbillfilterformula_tag", "tarbillfilterjson_tag");
                break;
            }
            case "relateobjfilter": {
                this.filterChange(newValue, "relateobjfilterformula_tag", "relateobjfilterjson_tag");
                break;
            }
            case "tarbillmainfield": {
                this.fieldChange(newValue, "tarbillmainfieldkey");
                break;
            }
            case "relateobjmainfield": {
                this.fieldChange(newValue, "relateobjmainfieldkey");
                break;
            }
            case "relateobjmatchfield": {
                this.entryFieldChange(newValue, "relateobjmatchfieldkey", rowIndex);
                break;
            }
            case "tarbillassignfield": {
                this.entryFieldChange(newValue, "tarbillassignfieldkey", rowIndex);
                break;
            }
            case "tarbillassignfieldkey": {
                this.tarAssignFieldKeyChange(newValue, rowIndex);
                break;
            }
            case "relateobjassignfield": {
                this.entryFieldChange(newValue, "relateobjassignfieldkey", rowIndex);
                break;
            }
            case "relateobjassignfieldkey": {
                this.relateAssignFieldKeyChange(newValue, rowIndex);
                break;
            }
            case "matchmethod": {
                this.matchMethodChange();
                break;
            }
            case "assignmethod": {
                this.assignMethodChange(newValue, rowIndex);
                break;
            }
            case "assignmethodbd": {
                this.assignMethodBdChange(newValue, rowIndex);
                break;
            }
            case "assignformula": {
                this.assignFormulaChange(newValue, rowIndex);
                break;
            }
        }
    }

    private void assignMethodBdChange(Object newValue, int rowIndex) {
        DynamicObject dym = (DynamicObject)newValue;
        if (null == dym) {
            this.getModel().setValue("assignmethod", (Object)"A", rowIndex);
        } else {
            String number = dym.getString("number");
            this.getModel().setValue("assignmethod", (Object)number, rowIndex);
        }
    }

    private void matchMethodChange() {
        IDataModel model = this.getModel();
        model.deleteEntryData("matchentry");
    }

    private void assignFormulaChange(Object newValue, int rowIndex) {
        if (ObjectUtils.isNotEmpty((Object)newValue)) {
            this.getModel().setValue("relateobjassignfield", null, rowIndex);
            this.getModel().setValue("relateobjassignfieldkey", null, rowIndex);
        } else {
            this.getModel().setValue("assignformulajson_tag", null, rowIndex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        String returnData = (String)evt.getReturnData();
        IDataModel dataModel = this.getModel();
        IPageCache pageCache = this.getPageCache();
        if (actionId == null || returnData == null) {
            return;
        }
        String currentRowIndex = pageCache.get("rowIndex");
        int rowIndex = NumberUtils.toInt((String)currentRowIndex, (int)0);
        switch (actionId) {
            case "tarbillfilterCB": {
                FormShowHelper.closeCallSetFilter(dataModel, pageCache, returnData, "tarbillfilter", "tarbillfilterjson_tag", "tarbillfilterformula_tag");
                break;
            }
            case "relateobjfilterCB": {
                FormShowHelper.closeCallSetFilter(dataModel, pageCache, returnData, "relateobjfilter", "relateobjfilterjson_tag", "relateobjfilterformula_tag");
                break;
            }
            case "tarbillmainfieldCB": {
                FormShowHelper.closeCallSetField(dataModel, returnData, "tarbillmainfield", "tarbillmainfieldkey");
                break;
            }
            case "relateobjmainfieldkeyCB": {
                FormShowHelper.closeCallSetField(dataModel, returnData, "relateobjmainfield", "relateobjmainfieldkey");
                break;
            }
            case "relateobjmatchfieldCB": {
                FormShowHelper.closeCallSetEntryField(dataModel, pageCache, returnData, "relateobjmatchfield", "relateobjmatchfieldkey");
                break;
            }
            case "tarbillassignfieldCB": {
                FormShowHelper.closeCallSetEntryField(dataModel, pageCache, returnData, "tarbillassignfield", "tarbillassignfieldkey");
                break;
            }
            case "relateobjassignfieldCB": {
                FormShowHelper.closeCallSetEntryField(dataModel, pageCache, returnData, "relateobjassignfield", "relateobjassignfieldkey");
                break;
            }
            case "ASSIGN_CONDITION_FORMULA_CB": {
                this.updateAssignFormulaJson(dataModel, rowIndex, returnData, "description");
                break;
            }
        }
    }

    private void updateAssignFormulaJson(IDataModel dataModel, int rowIndex, String json, String field) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            dataModel.setValue("assignformula", JSONObject.parseObject((String)json).get((Object)field), rowIndex);
        }
        dataModel.beginInit();
        dataModel.setValue("assignformulajson_tag", (Object)json, rowIndex);
        dataModel.beginInit();
        this.getView().updateView("assignformula", rowIndex);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"assignmethodbd"});
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"relateobjassignfield"});
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"isnegate"});
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rows = e.getRowDataEntities();
        String entryName = e.getEntryProp().getName();
        if ("assignentry".equals(entryName)) {
            for (RowDataEntity row : rows) {
                int rowIndex = row.getRowIndex();
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"assignmethodbd"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"relateobjassignfield"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"isnegate"});
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowHelper.setOperationItems(this.getModel(), this.getView(), "tarbill", "operation");
        Boolean quickAddNew = (Boolean)this.getView().getFormShowParameter().getCustomParam("quickAddNew");
        Object monitorObj = this.getView().getFormShowParameter().getCustomParam("monitorobj");
        if (quickAddNew != null && quickAddNew.booleanValue()) {
            this.getModel().setValue("monitorobj", monitorObj);
            this.getView().setEnable(Boolean.FALSE, new String[]{"monitorobj"});
        }
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"relateobjassignfield"});
        DynamicObjectCollection rows = this.getModel().getEntryEntity("assignentry");
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            this.getModel().beginInit();
            for (int rowIdx = 0; rowIdx < rows.size(); ++rowIdx) {
                DynamicObject row = (DynamicObject)rows.get(rowIdx);
                String assignMethod = row.getString("assignmethod");
                this.getModel().setItemValueByNumber("assignmethodbd", assignMethod, rowIdx);
                row.getDataEntityState().setBizChanged(false);
            }
            this.getModel().endInit();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setViewEnable();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propertyName = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject monitorObj = this.getModel().getDataEntity().getDynamicObject("monitorobj");
        switch (propertyName) {
            case "monitorobj": {
                this.beforeF7Bill(showParameter);
                break;
            }
            case "tarbill": 
            case "relateobj": {
                if (monitorObj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76d1\u542c\u5bf9\u8c61\u3002", (String)"BaseEditPlugin_0", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                this.beforeF7Bill(showParameter);
                break;
            }
            case "assignmethodbd": {
                this.beforeF7AssignMethod(e);
                break;
            }
        }
    }

    protected void beforeF7AssignMethod(BeforeF7SelectEvent beforeF7SelectEvent) {
        String tarFieldKey;
        String tarEntityKey;
        MainEntityType entityType = this.getModel().getDataEntityType();
        if (StringUtils.equals((CharSequence)"msisv_relateupdate", (CharSequence)entityType.getName())) {
            QFilter qFilter = new QFilter("number", "!=", (Object)"F");
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex("assignentry");
        DynamicObject tarBill = (DynamicObject)this.getModel().getValue("tarbill");
        if (null != tarBill && rowIndex >= 0 && !this.isNum(tarEntityKey = tarBill.getString("number"), tarFieldKey = (String)this.getModel().getValue("tarbillassignfieldkey", rowIndex))) {
            QFilter qFilter = new QFilter("number", "in", (Object)new Object[]{"A", "F"});
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
    }

    private void beforeF7Bill(ListShowParameter showParameter) {
        QFilter billFilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        showParameter.getListFilterParameter().setFilter(billFilter);
    }

    private void clickTarBillFilter(IDataModel model) {
        DynamicObject targetBill = model.getDataEntity().getDynamicObject("tarbill");
        if (targetBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76ee\u6807\u5355\u636e\u3002", (String)"RelateUpdateEditPlugin_0", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        String tarBillNum = targetBill.getString("number");
        FormShowHelper.showFilterForm((AbstractFormPlugin)this, model, tarBillNum, "tarbillfilterjson_tag", "tarbillfilterCB");
    }

    private void clickRelateObjFilter(IDataModel model) {
        DynamicObject relateObj = model.getDataEntity().getDynamicObject("relateobj");
        if (relateObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u5173\u8054\u5bf9\u8c61\u3002", (String)"BaseEditPlugin_2", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        String relateObjNum = relateObj.getString("number");
        FormShowHelper.showFilterForm((AbstractFormPlugin)this, model, relateObjNum, "relateobjfilterjson_tag", "relateobjfilterCB");
    }

    private void clickTarBillMainField(IDataModel model) {
        DynamicObject targetBill = model.getDataEntity().getDynamicObject("tarbill");
        if (targetBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76ee\u6807\u5355\u636e\u3002", (String)"BaseEditPlugin_1", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        String tarBillNum = targetBill.getString("number");
        ArrayList<String> filterFields = new ArrayList<String>(16);
        String billFiled = this.getModel().getDataEntity().getString("tarbillmainfieldkey");
        filterFields.add(billFiled);
        FormShowHelper.showColsTreeForm((AbstractFormPlugin)this, tarBillNum, null, filterFields, Boolean.FALSE, "tarbillmainfieldCB", PropertyDataType.QTY);
    }

    private void clickRelateObjMainField(IDataModel model) {
        DynamicObject relateObj = model.getDataEntity().getDynamicObject("relateobj");
        if (relateObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u5173\u8054\u5bf9\u8c61\u3002", (String)"BaseEditPlugin_2", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        String relateObjNum = relateObj.getString("number");
        ArrayList<String> filterFields = new ArrayList<String>(16);
        String billFiled = this.getModel().getDataEntity().getString("relateobjmainfieldkey");
        filterFields.add(billFiled);
        FormShowHelper.showColsTreeForm((AbstractFormPlugin)this, relateObjNum, null, filterFields, Boolean.FALSE, "relateobjmainfieldkeyCB", PropertyDataType.QTY);
    }

    private void clickRelateObjMatchField(IDataModel model, Control control) {
        int currentRowIndex = control.getModel().getEntryCurrentRowIndex("matchentry");
        DynamicObject relateObj = model.getDataEntity().getDynamicObject("relateobj");
        if (relateObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u5173\u8054\u5bf9\u8c61\u3002", (String)"BaseEditPlugin_2", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        String relateObjNum = relateObj.getString("number");
        ArrayList<String> filterFields = new ArrayList<String>(16);
        DynamicObjectCollection matchEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("matchentry");
        for (DynamicObject matchEntry : matchEntrys) {
            String relateMatchField = matchEntry.getString("relateobjmatchfieldkey");
            filterFields.add(relateMatchField);
        }
        FormShowHelper.showEntryColsTreeForm((AbstractFormPlugin)this, relateObjNum, currentRowIndex, new EntrySelectStrategy(), filterFields, Boolean.TRUE, "relateobjmatchfieldCB", new PropertyDataType[0]);
    }

    private void clickTarBillAssignField(IDataModel model, Control control) {
        int currentRowIndex = control.getModel().getEntryCurrentRowIndex("assignentry");
        DynamicObject tarBill = model.getDataEntity().getDynamicObject("tarbill");
        if (tarBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u76ee\u6807\u5355\u636e\u3002", (String)"BaseEditPlugin_1", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        String tarBillNum = tarBill.getString("number");
        ArrayList<String> filterFields = new ArrayList<String>(16);
        DynamicObjectCollection assignEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("assignentry");
        for (DynamicObject assignEntry : assignEntrys) {
            String tarAssignField = assignEntry.getString("tarbillassignfieldkey");
            if (!StringUtils.isNotBlank((CharSequence)tarAssignField)) continue;
            filterFields.add(tarAssignField);
        }
        String tarMainField = this.getModel().getDataEntity().getString("tarbillmainfieldkey");
        if (StringUtils.isNotBlank((CharSequence)tarMainField)) {
            // empty if block
        }
        FormShowHelper.showEntryColsTreeForm((AbstractFormPlugin)this, tarBillNum, currentRowIndex, new AssignEntrySelectStrategy(), filterFields, Boolean.TRUE, "tarbillassignfieldCB", new PropertyDataType[0]);
    }

    private void clickRelateObjAssignField(IDataModel model, Control control) {
        int currentRowIndex = control.getModel().getEntryCurrentRowIndex("assignentry");
        DynamicObject tarBill = model.getDataEntity().getDynamicObject("tarbill");
        DynamicObject relateObj = model.getDataEntity().getDynamicObject("relateobj");
        if (relateObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u5173\u8054\u5bf9\u8c61\u3002", (String)"BaseEditPlugin_2", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        String relateObjNum = relateObj.getString("number");
        ArrayList<String> filterFields = new ArrayList<String>(16);
        String tarAssignField = (String)this.getModel().getValue("tarbillassignfieldkey", currentRowIndex);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)tarBill.getString("number"));
        String[] fields = tarAssignField.split("\\.");
        if (fields.length > 1) {
            tarAssignField = fields[fields.length - 1];
        }
        IDataEntityProperty property = dataEntityType.findProperty(tarAssignField);
        TypeSelectStrategy selectStrategy = new TypeSelectStrategy(property, tarAssignField);
        DynamicObjectCollection assignEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("assignentry");
        for (DynamicObject assignEntry : assignEntrys) {
            String relateAssignField = assignEntry.getString("relateobjassignfieldkey");
            if (!StringUtils.isNotBlank((CharSequence)relateAssignField)) continue;
            filterFields.add(relateAssignField);
        }
        FormShowHelper.showEntryColsTreeForm((AbstractFormPlugin)this, relateObjNum, currentRowIndex, selectStrategy, filterFields, Boolean.TRUE, "relateobjassignfieldCB", new PropertyDataType[0]);
    }

    private void tarBillChange(Object oldValue) {
        if (oldValue != null) {
            DynamicObject oldTarBill = (DynamicObject)oldValue;
            HashMap<String, Object> confirmInfo = new HashMap<String, Object>(16);
            confirmInfo.put("tarbill", oldTarBill.getPkValue());
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u76ee\u6807\u5355\u636e\u5c06\u6e05\u9664\u9875\u9762\u7684\u76ee\u6807\u5355\u636e\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"BaseEditPlugin_4", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("tarbillCB", (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        } else {
            FormShowHelper.setOperationItems(this.getModel(), this.getView(), "tarbill", "operation");
        }
    }

    private void filterChange(Object newValue, String filterFormula, String filterJson) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(filterFormula, null);
            this.getModel().setValue(filterJson, null);
        }
    }

    private void fieldChange(Object newValue, String filedKey) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(filedKey, null);
        }
    }

    private void entryFieldChange(Object newValue, String filedKey, int rowIndex) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue(filedKey, null, rowIndex);
        }
    }

    protected void tarAssignFieldKeyChange(Object newValue, int rowIndex) {
        this.getModel().setValue("relateobjassignfield", null, rowIndex);
        this.getModel().setValue("assignmethod", (Object)"A", rowIndex);
        this.getModel().setItemValueByNumber("assignmethodbd", "A", rowIndex);
        this.getModel().setValue("isnegate", (Object)Boolean.FALSE, rowIndex);
        this.setNegateEnable(newValue, rowIndex);
        if (StringUtils.isNotBlank((Object)newValue)) {
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"relateobjassignfield"});
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"assignmethodbd"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"relateobjassignfield"});
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"assignmethodbd"});
        }
    }

    private void relateAssignFieldKeyChange(Object newValue, int rowIndex) {
        if (null == newValue) {
            this.getModel().setValue("isnegate", (Object)rowIndex);
        }
        this.setNegateEnable(newValue, rowIndex);
    }

    protected void assignMethodChange(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.setValue("relateobjassignfield", null, rowIndex);
        model.setValue("relateobjassignfieldkey", null, rowIndex);
        model.setValue("isnegate", (Object)false, rowIndex);
        model.endInit();
        this.getView().updateView("relateobjassignfield", rowIndex);
        this.getView().updateView("relateobjassignfieldkey", rowIndex);
        this.getView().updateView("isnegate", rowIndex);
        String relateAssignField = (String)model.getValue("relateobjassignfieldkey", rowIndex);
        this.setNegateEnable(relateAssignField, rowIndex);
        this.setAssignMethodEnable(newValue, rowIndex);
    }

    private void setViewEnable() {
        DynamicObject tarBill = this.getModel().getDataEntity().getDynamicObject("tarbill");
        if (tarBill == null) {
            return;
        }
        DynamicObject relateObj = this.getModel().getDataEntity().getDynamicObject("relateobj");
        if (relateObj == null) {
            return;
        }
        DynamicObjectCollection assignEntrys = this.getModel().getDataEntity().getDynamicObjectCollection("assignentry");
        for (int i = 0; i < assignEntrys.size(); ++i) {
            DynamicObject assignEntry = (DynamicObject)assignEntrys.get(i);
            String relateAssignField = assignEntry.getString("relateobjassignfieldkey");
            this.setNegateEnable(relateAssignField, i);
            String assignMethod = assignEntry.getString("assignmethod");
            this.setAssignMethodEnable(assignMethod, i);
        }
    }

    private void setNegateEnable(Object newValue, int rowIndex) {
        String fieldDataType = null;
        DynamicObject relObj = (DynamicObject)this.getModel().getValue("relateobj");
        if (null != relObj && null != newValue) {
            String billNum = relObj.getString("number");
            fieldDataType = this.getFieldDataType(newValue, billNum);
        }
        String assignMethod = (String)this.getModel().getValue("assignmethod", rowIndex);
        if (null != fieldDataType) {
            String numberType = Arrays.toString((Object[])PropertyDataType.getNumberType());
            if (numberType.contains(fieldDataType.toUpperCase())) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"isnegate"});
            } else {
                this.getModel().setValue("isnegate", (Object)Boolean.FALSE, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"isnegate"});
            }
        } else if ("D".equals(assignMethod)) {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"isnegate"});
        } else {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"isnegate"});
        }
    }

    private boolean isNum(String entityKey, String fieldKey) {
        if (StringUtils.isBlank((CharSequence)entityKey) || StringUtils.isBlank((CharSequence)fieldKey)) {
            return false;
        }
        String fieldDataType = this.getFieldDataType(fieldKey, entityKey);
        if (null == fieldDataType) {
            return false;
        }
        String numberType = Arrays.toString((Object[])PropertyDataType.getNumberType());
        return numberType.contains(fieldDataType.toUpperCase());
    }

    private void setAssignMethodEnable(Object newValue, int rowIndex) {
        if ("D".equals(newValue)) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"relateobjassignfield"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"relateobjassignfield"});
        }
    }

    private String getFieldDataType(Object newValue, String billNum) {
        String proDataType = null;
        MainEntityType relateObjType = MetadataServiceHelper.getDataEntityType((String)billNum);
        Map allFields = relateObjType.getAllFields();
        IDataEntityProperty fieldPro = null;
        if (newValue != null) {
            String[] keys;
            for (String key : keys = StringUtils.split((String)newValue.toString(), (String)".")) {
                if (!allFields.containsKey(key)) continue;
                fieldPro = (IDataEntityProperty)allFields.get(key);
            }
        }
        if (fieldPro != null) {
            proDataType = MetaHelper.getProDataType(fieldPro);
        }
        return proDataType;
    }

    private boolean isChange(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        if (newValue instanceof DynamicObject && oldValue instanceof DynamicObject && ((DynamicObject)newValue).getPkValue().equals(((DynamicObject)oldValue).getPkValue())) {
            return false;
        }
        return !(newValue instanceof BigDecimal) || !(oldValue instanceof BigDecimal) || ((BigDecimal)newValue).compareTo((BigDecimal)oldValue) != 0;
    }
}

