/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.mservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.mpscmm.msisv.isomorphism.common.util.ContextHolderUtils;
import kd.mpscmm.msisv.isomorphism.common.util.MonitorLogUtils;
import kd.mpscmm.msisv.isomorphism.core.config.service.IsvConfigService;
import kd.mpscmm.msisv.isomorphism.core.config.vo.ListenerConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.IsvIntegrationEngine;
import kd.mpscmm.msisv.isomorphism.core.engine.ec.PipelineEcService;
import kd.mpscmm.msisv.isomorphism.core.engine.filter.BillFilter;
import kd.mpscmm.msisv.isomorphism.core.log.service.IntegrationLogService;
import kd.mpscmm.msisv.isomorphism.core.log.vo.IntegrationLog;
import org.apache.commons.collections4.CollectionUtils;

public class IsvIntegrationService {
    public String process(List<Long> ids, String entityNumber, String operationKey) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        ContextHolderUtils.put("bizno", UUID.randomUUID().toString());
        ContextHolderUtils.put("execute_again", false);
        ContextHolderUtils.put("user", RequestContext.get().getCurrUserId());
        String bizNo = UUID.randomUUID().toString();
        return IsvIntegrationEngine.process(bizNo, entityNumber, ids, operationKey);
    }

    public List<Map<String, Object>> loadIsvPipelineList(String entityType, List<Long> billIds, String operationKey) {
        ArrayList<Map<String, Object>> configList = new ArrayList<Map<String, Object>>(2);
        Map<Long, String> billMap = IsvIntegrationEngine.loadBillNoMap(entityType, billIds);
        String bizNo = RequestContext.get().getTraceId();
        List<ListenerConfig> listenerConfigList = IsvConfigService.loadListenerConfig(entityType, operationKey);
        for (ListenerConfig listenerConfig : listenerConfigList) {
            List<Long> filterBillIds = BillFilter.filterBySql(entityType, billIds, listenerConfig.getQfilterStr());
            if (CollectionUtils.isEmpty(filterBillIds)) continue;
            List<PipelineConfig> pipelineConfigList = listenerConfig.getPipelineConfigs();
            listenerConfig.setPipelineConfigs(Collections.emptyList());
            for (PipelineConfig pipelineConfig : pipelineConfigList) {
                IntegrationLog logContext = MonitorLogUtils.createLogContext(bizNo, entityType, listenerConfig, pipelineConfig);
                List<Long> logIds = IntegrationLogService.saveLog(billMap, logContext, listenerConfig.isSync());
                PipelineEcService.PushParam pushParam = new PipelineEcService.PushParam();
                pushParam.setBizNo(bizNo);
                pushParam.setEntityNumber(entityType);
                pushParam.setOpKey(operationKey);
                pushParam.setBillIds(billIds);
                pushParam.setListenerConfig(listenerConfig);
                pushParam.setPipelineConfig(pipelineConfig);
                pushParam.setUserId(RequestContext.get().getCurrUserId());
                pushParam.setLogIds(logIds);
                HashMap<String, String> configMap = new HashMap<String, String>(4);
                configMap.put("config", SerializationUtils.serializeToBase64((Object)((Object)pushParam)));
                configMap.put("cloudId", "mpscmm");
                configMap.put("appId", "msisv");
                configMap.put("serviceName", "PipelineEcService");
                configList.add(configMap);
            }
        }
        return configList;
    }
}

