/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msisv.isomorphism.core.log.service.UnionPushRecordService;
import kd.mpscmm.msisv.isomorphism.core.log.vo.UnionPushRecordObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class MsisvUnionPushRecordService {
    public Map<Long, Boolean> existUnionPushRecordByRelationObj(String entityType, Collection<Long> relBillIdList) {
        List<UnionPushRecordObject> unionPushRecordObjectList = UnionPushRecordService.loadUnionPushRecordsByRel(entityType, relBillIdList);
        if (ObjectUtils.isEmpty(unionPushRecordObjectList)) {
            HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(relBillIdList.size());
            for (Long billId : relBillIdList) {
                resultMap.put(billId, Boolean.FALSE);
            }
            return resultMap;
        }
        Map groupUnionPushRecord = unionPushRecordObjectList.stream().collect(Collectors.groupingBy(UnionPushRecordObject::getUnionPushId, Collectors.toList()));
        QFilter qFilter = new QFilter("id", "in", groupUnionPushRecord.keySet());
        DynamicObjectCollection configDymList = QueryServiceHelper.query((String)"msisv_unionpush", (String)"id,relateobjmainfieldkey,tarbillmainfieldkey,tarbillfilterformula_tag", (QFilter[])qFilter.toArray());
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(relBillIdList.size());
        MultiKeyMap targetIdMap = new MultiKeyMap();
        for (DynamicObject configDym : configDymList) {
            List<UnionPushRecordObject> subUnionPushRecords = groupUnionPushRecord.get(configDym.getLong("id"));
            if ((subUnionPushRecords = subUnionPushRecords.stream().filter(item -> {
                Boolean isPushed = (Boolean)resultMap.get(item.getRelObj().getBillId());
                return BooleanUtils.isNotTrue((Boolean)isPushed);
            }).collect(Collectors.toList())).isEmpty()) continue;
            for (UnionPushRecordObject subUnionPushRecord : subUnionPushRecords) {
                targetIdMap.put((Object)subUnionPushRecord.getTgtObj().getBillId(), (Object)subUnionPushRecord.getTgtObj().getEntryId(), (Object)subUnionPushRecord.getRelObj().getBillId());
            }
            String tgtQtyField = configDym.getString("tarbillmainfieldkey");
            DataSet dataSet = UnionPushRecordService.loadTgtBillDataSet(tgtQtyField, subUnionPushRecords, null);
            Throwable throwable = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long targetBillId = row.getLong("id");
                    Long targetEntryId = row.getLong("entryid");
                    BigDecimal qty = row.getBigDecimal("qty");
                    Long relBillId = (Long)targetIdMap.get((Object)targetBillId, (Object)targetEntryId);
                    if (BooleanUtils.isTrue((Boolean)((Boolean)resultMap.get(relBillId)))) continue;
                    resultMap.put(relBillId, qty.abs().compareTo(BigDecimal.ZERO) > 0);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        return resultMap;
    }

    public Map<Long, Map<String, Object>> findUnionPushRecordByRelationObj(String entityType, Collection<Long> relBillIdList) {
        List<UnionPushRecordObject> unionPushRecordObjectList = UnionPushRecordService.loadUnionPushRecordsByRel(entityType, relBillIdList);
        Map trackMap = null;
        if (ObjectUtils.isEmpty(unionPushRecordObjectList) && ObjectUtils.isNotEmpty((Object)(trackMap = this.getTrackMap(entityType, relBillIdList)))) {
            String srcEntityType = MapUtils.getString((Map)trackMap, (Object)entityType);
            trackMap.remove(entityType);
            unionPushRecordObjectList = UnionPushRecordService.loadUnionPushRecordsByRel(srcEntityType, trackMap.values());
        }
        if (ObjectUtils.isEmpty(unionPushRecordObjectList)) {
            return Collections.emptyMap();
        }
        Map groupUnionPushRecord = unionPushRecordObjectList.stream().collect(Collectors.groupingBy(UnionPushRecordObject::getUnionPushId, Collectors.toList()));
        QFilter qFilter = new QFilter("id", "in", groupUnionPushRecord.keySet());
        DynamicObjectCollection configDymList = QueryServiceHelper.query((String)"msisv_unionpush", (String)"id,relateobjmainfieldkey,tarbillmainfieldkey,tarbillfilterformula_tag", (QFilter[])qFilter.toArray());
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>(relBillIdList.size());
        MultiKeyMap targetIdMap = new MultiKeyMap();
        for (DynamicObject configDym : configDymList) {
            List<UnionPushRecordObject> subUnionPushRecords = groupUnionPushRecord.get(configDym.getLong("id"));
            HashMap<Long, Map<String, Object>> finalResultMap = resultMap;
            if ((subUnionPushRecords = subUnionPushRecords.stream().filter(item -> !finalResultMap.containsKey(item.getRelObj().getBillId())).collect(Collectors.toList())).isEmpty()) continue;
            for (UnionPushRecordObject subUnionPushRecord : subUnionPushRecords) {
                targetIdMap.put((Object)subUnionPushRecord.getTgtObj().getBillId(), (Object)subUnionPushRecord.getTgtObj().getEntryId(), (Object)subUnionPushRecord.getRelObj().getBillId());
            }
            String targetEntityType = ((UnionPushRecordObject)subUnionPushRecords.get(0)).getTgtObj().getEntityType();
            String tgtQtyField = configDym.getString("tarbillmainfieldkey");
            DataSet dataSet = UnionPushRecordService.loadTgtBillDataSet(tgtQtyField, subUnionPushRecords, null);
            Throwable throwable = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long targetBillId = row.getLong("id");
                    String billno = row.getString("billno");
                    Long targetEntryId = row.getLong("entryid");
                    Long relBillId = (Long)targetIdMap.get((Object)targetBillId, (Object)targetEntryId);
                    HashMap<String, Object> targetBillMap = (HashMap<String, Object>)resultMap.get(relBillId);
                    if (null == targetBillMap) {
                        targetBillMap = new HashMap<String, Object>(2);
                        targetBillMap.put("entitytype", targetEntityType);
                        targetBillMap.put("billno", new ArrayList(2));
                        targetBillMap.put("billid", new ArrayList(2));
                        resultMap.put(relBillId, targetBillMap);
                    }
                    List billIdList = (List)targetBillMap.get("billid");
                    billIdList.add(targetBillId);
                    List billNoList = (List)targetBillMap.get("billno");
                    billNoList.add(billno);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        if (MapUtils.isNotEmpty((Map)trackMap)) {
            HashMap newMap = new HashMap(relBillIdList.size());
            for (Long relBilId : relBillIdList) {
                Long srcBillId = MapUtils.getLong((Map)trackMap, (Object)relBilId, (Long)relBilId);
                if (!resultMap.containsKey(srcBillId)) continue;
                newMap.put(relBilId, resultMap.get(srcBillId));
            }
            resultMap = newMap;
        }
        return resultMap;
    }

    private Map getTrackMap(String entityNumber, Collection<Long> billIdList) {
        QFilter qFilter = new QFilter("id", "in", billIdList);
        DynamicObjectCollection resultBills = QueryServiceHelper.query((String)entityNumber, (String)"id,splitbatchentity.m_srcentitynumber AS m_srcentitynumber,splitbatchentity.m_srcbillid AS m_srcbillid,splitbatchentity.m_srcbillentryid AS m_srcbillentryid", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)resultBills)) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>(billIdList.size());
        String srcEntityType = ((DynamicObject)resultBills.get(0)).getString("m_srcentitynumber");
        resultMap.put(entityNumber, srcEntityType);
        for (DynamicObject resultBill : resultBills) {
            resultMap.put(resultBill.getLong("id"), resultBill.getLong("m_srcbillid"));
        }
        return resultMap;
    }

    public List<Map<String, Object>> queryAllRelationUnionPushRecord(String targetEntityKey, List<Long> targetEntryIdList, String relEntityKey) {
        if (StringUtils.isBlank((CharSequence)targetEntityKey) || ObjectUtils.isEmpty(targetEntryIdList) || StringUtils.isBlank((CharSequence)relEntityKey)) {
            return Collections.emptyList();
        }
        HashSet<Long> relBillIdSet = new HashSet<Long>(16);
        HashSet<Long> relEntryIdSet = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("tgtentity", "=", (Object)targetEntityKey);
        qFilter.and("tgtentryid", "in", targetEntryIdList);
        qFilter.and("relentity", "=", (Object)relEntityKey);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"MsisvUnionPushRecordService", (String)"msisv_unionpush_record", (String)"relbillid,relentryid", (QFilter[])qFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                relBillIdSet.add(row.getLong("relbillid"));
                relEntryIdSet.add(row.getLong("relentryid"));
            }
        }
        if (ObjectUtils.isEmpty(relBillIdSet) || ObjectUtils.isEmpty(relEntryIdSet)) {
            return Collections.emptyList();
        }
        QFilter queryFilter = new QFilter("tgtentity", "=", (Object)targetEntityKey);
        queryFilter.and("relentity", "=", (Object)relEntityKey);
        queryFilter.and("relbillid", "in", relBillIdSet);
        queryFilter.and("relentryid", "in", relEntryIdSet);
        ArrayList<Map<String, Object>> relationList = new ArrayList<Map<String, Object>>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"MsisvUnionPushRecordService", (String)"msisv_unionpush_record", (String)"relentity,relbillid,relentryid,tgtentity,tgtbillid,tgtentryid", (QFilter[])queryFilter.toArray(), null);){
            RowMeta rowMeta = dataSet.getRowMeta();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> relationMap = new HashMap<String, Object>(8);
                for (String fieldName : rowMeta.getFieldNames()) {
                    relationMap.put(fieldName, row.get(fieldName));
                }
                relationList.add(relationMap);
            }
        }
        return relationList;
    }
}

