/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.mservice;

import java.util.Collection;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mpscmm.msisv.isomorphism.common.consts.MonitorResultLogConst;
import kd.mpscmm.msisv.isomorphism.common.util.IdempotentPropertiesUtils;
import kd.mpscmm.msisv.isomorphism.core.config.vo.ListenerConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IdempotentKey;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class OperatorIdempotentService
extends BaseECService
implements IdempotentService {
    private static final Log log = LogFactory.getLog(OperatorIdempotentService.class);
    private static OperateOption operateOption = OperateOption.create();

    public DtxResponse execute(Object param, Object lastReturn) throws Exception {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            DtxResponse dtxResponse = super.execute(param, lastReturn);
            return dtxResponse;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object lastReturn) {
        TargetOperatorParam targetOperatorParam = (TargetOperatorParam)((Object)param);
        ListenerConfig listenerConfig = targetOperatorParam.getListenerConfig();
        PipelineConfig pipelineConfig = targetOperatorParam.getPipelineConfig();
        IdempotentKey idempotentKey = new IdempotentKey();
        idempotentKey.setBizNo(targetOperatorParam.getBizNo());
        idempotentKey.setEntityNumber(targetOperatorParam.getTargetEntityNumber());
        idempotentKey.setOpKey(listenerConfig.getOperateKey());
        idempotentKey.setListenerNumber(listenerConfig.getNumber());
        idempotentKey.setActionNumber(pipelineConfig.getPipeNumber());
        idempotentKey.setActionOperate(targetOperatorParam.getActionOp());
        idempotentKey.setTargetFid(targetOperatorParam.getTargetFid());
        IdempotentProperties idempotentProperties = IdempotentPropertiesUtils.generate(((Object)((Object)this)).getClass().getName(), idempotentKey);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)targetOperatorParam.getTargetEntityNumber());
        idempotentProperties.setDbRoute(DBRoute.of((String)mainEntityType.getDBRouteKey()));
        return idempotentProperties;
    }

    protected DtxResponse doExecute(Object param, Object lastReturn) throws Exception {
        OperationResult operationResult;
        TargetOperatorParam targetOperatorParam = (TargetOperatorParam)((Object)param);
        try (TXHandle h = TX.notSupported();){
            String billJson = targetOperatorParam.getTargetBillJson();
            if (StringUtils.isNotBlank((CharSequence)billJson)) {
                DynamicObject targetBill = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)billJson);
                operationResult = OperationServiceHelper.executeOperate((String)targetOperatorParam.getActionOp(), (String)targetOperatorParam.getTargetEntityNumber(), (DynamicObject[])new DynamicObject[]{targetBill}, (OperateOption)operateOption);
            } else {
                operationResult = OperationServiceHelper.executeOperate((String)targetOperatorParam.getActionOp(), (String)targetOperatorParam.getTargetEntityNumber(), (Object[])new Object[]{targetOperatorParam.getTargetFid()}, (OperateOption)operateOption);
            }
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, MonitorResultLogConst.getTargetBillOperatorErrorMsg(), new Object[0]);
        }
        if (operationResult == null) {
            return null;
        }
        if (!operationResult.isSuccess()) {
            StringBuilder errorMsgBuilder = new StringBuilder();
            errorMsgBuilder.append((String)ObjectUtils.defaultIfNull((Object)operationResult.getMessage(), (Object)""));
            if (CollectionUtils.isNotEmpty((Collection)operationResult.getAllErrorOrValidateInfo())) {
                errorMsgBuilder.append(operationResult.getAllErrorOrValidateInfo().toString());
            }
            throw new KDBizException(errorMsgBuilder.toString());
        }
        return null;
    }

    static {
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("WF", String.valueOf(false));
    }

    public static class TargetOperatorParam
    extends CommonParam {
        private String bizNo;
        private ListenerConfig listenerConfig;
        private PipelineConfig pipelineConfig;
        private String actionOp;
        private String targetBillJson;
        private String targetEntityNumber;
        private Long targetFid;

        public String getBizNo() {
            return this.bizNo;
        }

        public TargetOperatorParam setBizNo(String bizNo) {
            this.bizNo = bizNo;
            return this;
        }

        public String getTargetEntityNumber() {
            return this.targetEntityNumber;
        }

        public TargetOperatorParam setTargetEntityNumber(String targetEntityNumber) {
            this.targetEntityNumber = targetEntityNumber;
            return this;
        }

        public ListenerConfig getListenerConfig() {
            return this.listenerConfig;
        }

        public TargetOperatorParam setListenerConfig(ListenerConfig listenerConfig) {
            this.listenerConfig = listenerConfig;
            return this;
        }

        public PipelineConfig getPipelineConfig() {
            return this.pipelineConfig;
        }

        public TargetOperatorParam setPipelineConfig(PipelineConfig pipelineConfig) {
            this.pipelineConfig = pipelineConfig;
            return this;
        }

        public String getActionOp() {
            return this.actionOp;
        }

        public TargetOperatorParam setActionOp(String actionOp) {
            this.actionOp = actionOp;
            return this;
        }

        public Long getTargetFid() {
            return this.targetFid;
        }

        public TargetOperatorParam setTargetFid(Long targetFid) {
            this.targetFid = targetFid;
            return this;
        }

        public String getTargetBillJson() {
            return this.targetBillJson;
        }

        public TargetOperatorParam setTargetBillJson(String targetBillJson) {
            this.targetBillJson = targetBillJson;
            return this;
        }
    }
}

