/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.op.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msisv.isomorphism.common.util.ContextHolderUtils;
import kd.mpscmm.msisv.isomorphism.core.engine.IsvIntegrationEngine;

public class MonitorLogExcuteOp
extends AbstractOperationServicePlugIn {
    private static String SELECT_FIELDS = new StringJoiner(",").add("bizno").add("billid").add("entity").add("operation").add("isfinish").add("issuccess").toString();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("bizno");
        e.getFieldKeys().add("entity");
        e.getFieldKeys().add("isfinish");
        e.getFieldKeys().add("issuccess");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("operation");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] monitorLogs = e.getDataEntities();
        if (monitorLogs == null || monitorLogs.length == 0) {
            return;
        }
        for (DynamicObject monitorLog : monitorLogs) {
            monitorLog.set("isfinish", (Object)Boolean.FALSE);
        }
        this.checkTxExecuting(monitorLogs);
        SaveServiceHelper.save((DynamicObject[])monitorLogs);
        this.executeAgain(monitorLogs);
    }

    private void checkTxExecuting(DynamicObject[] monitorLogs) {
        List bizNoList = Stream.of(monitorLogs).map(item -> item.getString("bizno")).distinct().collect(Collectors.toList());
        QFilter filter = new QFilter("bizno", "in", bizNoList);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"msisv_monitorlog", (String)SELECT_FIELDS, (QFilter[])filter.toArray());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            if (dynamicObject.getBoolean("isfinish")) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"IsvListenerExecuting", (String)"bos-ext-scmc", (Object[])new Object[0]), new Object[0]));
        }
    }

    private void executeAgain(DynamicObject[] monitorLogs) {
        List bizNoList = Stream.of(monitorLogs).map(item -> item.getString("bizno")).distinct().collect(Collectors.toList());
        QFilter filter = new QFilter("bizno", "in", bizNoList);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"msisv_monitorlog", (String)SELECT_FIELDS, (QFilter[])filter.toArray());
        HashMap<String, List> groups = new HashMap<String, List>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String bizNo2 = dynamicObject.getString("bizno");
            ArrayList<DynamicObject> srcBillNoList = (ArrayList<DynamicObject>)groups.get(bizNo2);
            if (srcBillNoList == null) {
                srcBillNoList = new ArrayList<DynamicObject>(4);
                groups.put(bizNo2, srcBillNoList);
            }
            srcBillNoList.add(dynamicObject);
        }
        groups.forEach((bizNo, dynamicObjects) -> {
            String entityNumber = ((DynamicObject)dynamicObjects.get(0)).getString("entity");
            String operationKey = ((DynamicObject)dynamicObjects.get(0)).getString("operation");
            List<Long> billIds = dynamicObjects.stream().map(item -> item.getLong("billid")).distinct().sorted().collect(Collectors.toList());
            ContextHolderUtils.put("execute_again", true);
            IsvIntegrationEngine.process(bizNo, entityNumber, billIds, operationKey);
        });
    }
}

