/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.op.validator;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class EcologicMonitorSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            this.checkOperation(dataEntity);
            this.checkMonitorAction(dataEntity);
        }
    }

    private void checkOperation(ExtendedDataEntity dataEntity) {
        HashSet<String> opKeys = new HashSet<String>(16);
        String operationNum = dataEntity.getDataEntity().getString("monitoroperation");
        DynamicObject monitorObj = dataEntity.getDataEntity().getDynamicObject("monitorobj");
        if (monitorObj == null) {
            return;
        }
        String monitorObjNum = monitorObj.getString("number");
        List operations = EntityMetadataCache.getDataEntityOperate((String)monitorObjNum);
        for (Map operation : operations) {
            String opKey = (String)operation.get("key");
            opKeys.add(opKey);
        }
        if (!opKeys.contains(operationNum)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u76d1\u542c\u64cd\u4f5c\u201d\u3002", (String)"EcologicMonitorSaveValidator_3", (String)"scmc-im-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkMonitorAction(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection actionEntrys = dataEntity.getDataEntity().getDynamicObjectCollection("actionentry");
        block10: for (int i = 0; i < actionEntrys.size(); ++i) {
            DynamicObject actionEntry = (DynamicObject)actionEntrys.get(i);
            String type = actionEntry.getString("type");
            if (StringUtils.isBlank((CharSequence)type)) {
                return;
            }
            switch (type) {
                case "A": {
                    Object pushAction = actionEntry.get("pushaction");
                    if (pushAction != null) continue block10;
                    String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u76d1\u542c\u884c\u4e3a\u201d\u7b2c%s\u884c:\u201c\u8054\u5408\u4e0b\u63a8\u201d\u3002", (String)"EcologicMonitorSaveValidator_0", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]), i + 1);
                    this.addErrorMessage(dataEntity, msg);
                    continue block10;
                }
                case "B": {
                    Object updateAction = actionEntry.get("updateaction");
                    if (updateAction != null) continue block10;
                    String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u76d1\u542c\u884c\u4e3a\u201d\u7b2c%s\u884c:\u201c\u5173\u8054\u66f4\u65b0\u201d\u3002", (String)"EcologicMonitorSaveValidator_1", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]), i + 1);
                    this.addErrorMessage(dataEntity, msg);
                    continue block10;
                }
                case "C": {
                    String serviceAction = actionEntry.getString("serviceaction");
                    if (serviceAction != null && !StringUtils.isBlank((CharSequence)serviceAction)) continue block10;
                    String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u76d1\u542c\u884c\u4e3a\u201d\u7b2c%s\u884c:\u201c\u670d\u52a1\u8c03\u7528\u201d\u3002", (String)"EcologicMonitorSaveValidator_2", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]), i + 1);
                    this.addErrorMessage(dataEntity, msg);
                    continue block10;
                }
            }
        }
    }
}

