/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.op.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class UnionPushSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            this.checkRelateConfigInfo(dataEntity);
        }
    }

    private void checkRelateConfigInfo(ExtendedDataEntity dataEntity) {
        DynamicObject entity = dataEntity.getDataEntity();
        boolean isInvolved = entity.getBoolean("isinvorelateobj");
        if (isInvolved) {
            this.checkBill(dataEntity, entity);
            this.checkQtyMainField(dataEntity, entity);
            this.checkMatchEntry(dataEntity, entity);
            this.checkAssignEntry(dataEntity, entity);
        }
    }

    private void checkBill(ExtendedDataEntity dataEntity, DynamicObject entity) {
        DynamicObject monitorObj = entity.getDynamicObject("monitorobj");
        if (monitorObj == null) {
            return;
        }
        String monitorObjNum = monitorObj.getString("number");
        DynamicObject relateObj = entity.getDynamicObject("relateobj");
        if (relateObj == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5173\u8054\u5bf9\u8c61\u201d\u3002", (String)"UnionPushSaveValidator_0", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
            return;
        }
        String relateObjNum = relateObj.getString("number");
        DynamicObject srcBill = entity.getDynamicObject("srcbill");
        if (srcBill == null) {
            return;
        }
        String srcBillNum = srcBill.getString("number");
        if (!StringUtils.equals((CharSequence)monitorObjNum, (CharSequence)relateObjNum) && !StringUtils.equals((CharSequence)monitorObjNum, (CharSequence)srcBillNum)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6d89\u53ca\u5173\u8054\u5bf9\u8c61\u65f6\uff0c\u76d1\u542c\u5bf9\u8c61\u9700\u7b49\u4e8e\u6765\u6e90\u5355\u636e\u6216\u8005\u5173\u8054\u5bf9\u8c61\u3002", (String)"UnionPushSaveValidator_11", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
        }
    }

    private void checkQtyMainField(ExtendedDataEntity dataEntity, DynamicObject entity) {
        String relateMainField;
        String tarMainField;
        String srcMainField = entity.getString("srcbillmainfieldkey");
        if (StringUtils.isBlank((CharSequence)srcMainField)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6765\u6e90\u5355\u636e\u5b57\u6bb5\u201d\u3002", (String)"UnionPushSaveValidator_12", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)(tarMainField = entity.getString("tarbillmainfieldkey")))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u76ee\u6807\u5355\u636e\u5b57\u6bb5\u201d\u3002", (String)"UnionPushSaveValidator_1", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)(relateMainField = entity.getString("relateobjmainfieldkey")))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5173\u8054\u5bf9\u8c61\u5b57\u6bb5\u201d\u3002", (String)"UnionPushSaveValidator_2", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
        }
    }

    private void checkMatchEntry(ExtendedDataEntity dataEntity, DynamicObject entity) {
        String matchMethod = entity.getString("matchmethod");
        if ("B".equals(matchMethod)) {
            return;
        }
        DynamicObjectCollection matchEntrys = entity.getDynamicObjectCollection("matchentry");
        if (matchEntrys.isEmpty()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4e0e\u6765\u6e90\u5355\u636e\u7684\u5339\u914d\u5173\u7cfb\u201d\u5206\u5f55\u3002", (String)"UnionPushSaveValidator_3", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
        }
    }

    private void checkAssignEntry(ExtendedDataEntity dataEntity, DynamicObject entity) {
        DynamicObjectCollection assignEntrys = entity.getDynamicObjectCollection("assignentry");
        if (assignEntrys.isEmpty()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5bf9\u76ee\u6807\u5355\u636e\u8d4b\u503c\u201d\u5206\u5f55\u3002", (String)"UnionPushSaveValidator_6", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]));
        }
        for (int i = 0; i < assignEntrys.size(); ++i) {
            String msg;
            DynamicObject assignEntry = (DynamicObject)assignEntrys.get(i);
            String tarAssignField = assignEntry.getString("tarbillassignfield");
            if (StringUtils.isBlank((CharSequence)tarAssignField)) {
                String msg2 = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5bf9\u76ee\u6807\u5355\u636e\u8d4b\u503c\u201d\u7b2c%s\u884c:\u201c\u76ee\u6807\u5355\u636e\u5b57\u6bb5\u201d\u3002", (String)"UnionPushSaveValidator_7", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]), i + 1);
                this.addErrorMessage(dataEntity, msg2);
            }
            Object assignMethod = assignEntry.get("assignmethod");
            String relateAssignField = assignEntry.getString("relateobjassignfield");
            String assignFormula = assignEntry.getString("assignformula");
            if ("F".equals(assignMethod)) {
                if (!StringUtils.isBlank((CharSequence)assignFormula)) continue;
                msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5bf9\u76ee\u6807\u5355\u636e\u8d4b\u503c\u201d\u7b2c%s\u884c:\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\u3002", (String)"UnionPushSaveValidator_14", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]), i + 1);
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            if ("D".equals(assignMethod) || !StringUtils.isBlank((CharSequence)relateAssignField)) continue;
            msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5bf9\u76ee\u6807\u5355\u636e\u8d4b\u503c\u201d\u7b2c%s\u884c:\u201c\u5173\u8054\u5bf9\u8c61\u5b57\u6bb5\u201d\u3002", (String)"UnionPushSaveValidator_8", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]), i + 1);
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

