/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.business.helper;

import java.util.List;
import java.util.Map;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.param.ParameterReader;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class AppParameterHelper {
    public static Object getAppParameterByFormId(String formId, Long orgId, String key) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        if (formConfig == null || formConfig.getAppId() == null) {
            return null;
        }
        String orgViewType = AppParameterHelper.getBizAppOrgFuncByFormId(formId);
        return AppParameterHelper.getAppParameterByAppNumber(formConfig.getAppId(), orgViewType, orgId, key);
    }

    public static AppInfo getBizAppByFormId(String formId) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        if (formConfig != null && formConfig.getAppId() != null) {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)formConfig.getAppId());
            return appInfo;
        }
        return null;
    }

    public static String getBizAppOrgFuncByFormId(String formId) {
        AppInfo appInfo = AppParameterHelper.getBizAppByFormId(formId);
        return appInfo == null ? null : appInfo.getOrgFunc();
    }

    @Deprecated
    public static Object getAppParameterByFormId(String formId, String orgViewType, Long orgId, String key) {
        return null;
    }

    @Deprecated
    public static Object getAppParameterByAppId(String appId, String orgViewType, Long orgId, String key) {
        return null;
    }

    public static Object getAppParameterByAppNumber(String appNumber, String orgViewType, Long orgId, String key) {
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)appNumber);
        return SystemParamServiceHelper.getAppParameter((String)appId, (String)orgViewType, (Long)orgId, (String)key);
    }

    public static Object getAppParameter(String appId, String viewType, Long orgId, String key) {
        AppParam appParam = new AppParam(appId, viewType, orgId, Long.valueOf(0L));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)key);
    }

    public static Object getAppParameter(String formId, String key) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)formConfig.getAppId());
        long orgId = ((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId();
        AppParam appParam = new AppParam(appId, Long.valueOf(orgId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)key);
    }

    public static Map<String, Map<String, Object>> getBatchAppParameterByFormId(String formId, List<Long> orgIds) {
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
        if (formConfig == null || formConfig.getAppId() == null) {
            return null;
        }
        String viewType = AppParameterHelper.getBizAppOrgFuncByFormId(formId);
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)formConfig.getAppId());
        return ParameterReader.loadBatchSystemParameterByOrg(null, (String)appId, (String)viewType, orgIds, (long)0L);
    }
}

