/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.msmob.business.helper.AppParameterHelper;
import kd.scmc.msmob.business.helper.scan.ICodeParse;
import kd.scmc.msmob.business.helper.scan.impl.CodeParseImpl;
import kd.scmc.msmob.common.enums.EnableStatusEnum;
import kd.scmc.msmob.common.utils.MetaUtils;
import kd.scmc.msmob.pojo.BarcodeParseResult;
import kd.scmc.msmob.pojo.Property;
import kd.scmc.msmob.pojo.PropertyValue;
import kd.scmc.msmob.pojo.QrCodeResult;
import kd.scmc.msmob.pojo.ServiceAddressPojo;

public class BarcodeParseHelper {
    private static final Log LOG = LogFactory.getLog(BarcodeParseHelper.class);
    private static final String SERVICE_ADDRESS = "serviceaddress";
    private static final String APP_ID_MS_MOB = "1RK5G4E0=Y55";

    public static BarcodeParseResult barcodeParse(String barCode, Long orgId) {
        ServiceAddressPojo serviceAddress = BarcodeParseHelper.getCompleteServiceAddress(orgId);
        if (serviceAddress.isIrregularity()) {
            String errMsg = ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u5730\u5740\u586b\u5199\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BarcodeParseHelper_1", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        if (serviceAddress.isComplete()) {
            return (BarcodeParseResult)DispatchServiceHelper.invokeBizService((String)serviceAddress.getCloudId(), (String)serviceAddress.getAppId(), (String)serviceAddress.getServiceName(), (String)serviceAddress.getMethodName(), (Object[])new Object[]{barCode});
        }
        return BarcodeParseHelper.barcodeParse(barCode);
    }

    public static ServiceAddressPojo getCompleteServiceAddress(Long orgId) {
        String cloudId = (String)BarcodeParseHelper.getServiceParameter(orgId, "cloudid");
        String appId = (String)BarcodeParseHelper.getServiceParameter(orgId, "appid");
        String serviceName = (String)BarcodeParseHelper.getServiceParameter(orgId, "servicename");
        String methodName = (String)BarcodeParseHelper.getServiceParameter(orgId, "methodname");
        return new ServiceAddressPojo(cloudId, appId, serviceName, methodName);
    }

    public static QrCodeResult qrCodeParse(String barCode) {
        QrCodeResult qrCodeResult = new QrCodeResult();
        if (StringUtils.isBlank((CharSequence)barCode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u626b\u63cf\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"BarcodeParseHelper_2", (String)"scmc-msmob-form", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        DynamicObject[] parsingServiceConfigMap = BusinessDataServiceHelper.load((String)"msmob_parseserviceconfig", (String)"condition,cloudid,appid,servicename,methodname", (QFilter[])new QFilter[]{qFilter}, (String)"priority");
        boolean parseSuccess = false;
        for (DynamicObject parsingServiceConfig : parsingServiceConfigMap) {
            String condition = (String)parsingServiceConfig.get("condition");
            if (!StringUtils.isBlank((CharSequence)condition) && !barCode.matches(condition)) continue;
            qrCodeResult = BarcodeParseHelper.getQrCodeResult(parsingServiceConfig, barCode);
            parseSuccess = true;
            break;
        }
        if (parseSuccess) {
            return qrCodeResult;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u5931\u8d25\uff0c\u6ca1\u6709\u7b26\u5408\u7684\u89e3\u6790\u670d\u52a1\u3002", (String)"BarcodeParseHelper_3", (String)"scmc-msmob-form", (Object[])new Object[0]));
    }

    private static ServiceAddressPojo getCompleteServiceAddress(DynamicObject parsingServiceConfig) {
        String cloudId = (String)parsingServiceConfig.get("cloudid");
        String appId = (String)parsingServiceConfig.get("appid");
        String serviceName = (String)parsingServiceConfig.get("servicename");
        String methodName = (String)parsingServiceConfig.get("methodname");
        return new ServiceAddressPojo(cloudId, appId, serviceName, methodName);
    }

    private static QrCodeResult getQrCodeResult(DynamicObject parsingServiceConfig, String barCode) {
        ServiceAddressPojo serviceAddress = BarcodeParseHelper.getCompleteServiceAddress(parsingServiceConfig);
        if (serviceAddress.isComplete()) {
            try {
                QrCodeResult result = (QrCodeResult)DispatchServiceHelper.invokeBizService((String)serviceAddress.getCloudId(), (String)serviceAddress.getAppId(), (String)serviceAddress.getServiceName(), (String)serviceAddress.getMethodName(), (Object[])new Object[]{barCode});
                return result;
            }
            catch (KDException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a%s\u5fae\u670d\u52a1\u5730\u5740\u586b\u5199\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BarcodeParseHelper_4", (String)"scmc-msmob-form", (Object[])new Object[0]), parsingServiceConfig.getString("number")));
    }

    public static QrCodeResult qrCodeParse(String barCode, Long orgId) {
        ServiceAddressPojo serviceAddress = BarcodeParseHelper.getCompleteServiceAddress(orgId);
        if (serviceAddress.isIrregularity()) {
            String errMsg = ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u5730\u5740\u586b\u5199\u4e0d\u5b8c\u6574\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BarcodeParseHelper_1", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        if (serviceAddress.isComplete()) {
            LOG.info("\u5f00\u59cb\u8c03\u7528\u79fb\u52a8\u670d\u52a1\u4e2d\u914d\u7f6e\u7684\u6761\u7801\u670d\u52a1\u63a5\u53e3");
            HashMap resultMap = (HashMap)DispatchServiceHelper.invokeBizService((String)serviceAddress.getCloudId(), (String)serviceAddress.getAppId(), (String)serviceAddress.getServiceName(), (String)serviceAddress.getMethodName(), (Object[])new Object[]{barCode});
            LOG.info("\u8c03\u7528\u79fb\u52a8\u670d\u52a1\u4e2d\u7684\u914d\u7f6e\u7684\u6761\u7801\u670d\u63a5\u53e3\u7ed3\u679c --> " + resultMap);
            QrCodeResult result = BarcodeParseHelper.convertToResult(resultMap);
            return result;
        }
        QrCodeResult result = new QrCodeResult();
        CodeParseImpl codeParseImpl = new CodeParseImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)codeParseImpl, ICodeParse.class, (String)"mpscmm.msmob.extension.scan.parse", null);
        pluginProxy.callReplaceIfPresent(p -> {
            p.codeParse(orgId, barCode, result);
            return null;
        });
        String entityId = result.getEntityId();
        if (StringUtils.isNotEmpty((CharSequence)entityId) && !MetaUtils.isExistsMeta(entityId)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u89e3\u6790\u7ed3\u679c\u6709\u8bef\uff0c\u627e\u4e0d\u5230\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u5143\u6570\u636e\u3002", (String)"BarcodeParseHelper_notExists", (String)"scmc-msmob-form", (Object[])new Object[0]), entityId);
            throw new KDBizException(errMsg);
        }
        return result;
    }

    public static QrCodeResult convertToResult(Map<String, Object> map) {
        QrCodeResult result = new QrCodeResult();
        result.setSuccess(map.get("success") != null ? ((Boolean)map.get("success")).booleanValue() : Boolean.FALSE.booleanValue());
        result.setQrCode(map.get("qrCode") != null ? (String)map.get("qrCode") : null);
        result.setPkValue(map.get("pkValue") != null ? (Long)map.get("pkValue") : null);
        result.setMessage(map.get("message") != null ? (String)map.get("message") : null);
        result.setCodeType(map.get("codeType") != null ? (String)map.get("codeType") : null);
        result.setEntityId(map.get("entityId") != null ? (String)map.get("entityId") : null);
        result.setAttributes(map.get("attributes") != null ? (Map)map.get("attributes") : null);
        return result;
    }

    public static Object getServiceAddress(Long orgId) {
        return AppParameterHelper.getAppParameter(APP_ID_MS_MOB, "15", orgId, SERVICE_ADDRESS);
    }

    public static Object getServiceParameter(Long orgId, String parameterName) {
        return AppParameterHelper.getAppParameter(APP_ID_MS_MOB, "15", orgId, parameterName);
    }

    public static BarcodeParseResult barcodeParse(String code) {
        BarcodeParseResult result = new BarcodeParseResult();
        ArrayList<Property> data = new ArrayList<Property>(6);
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            String[] split;
            for (String number : split = code.split("\\|")) {
                long id;
                PropertyValue value;
                Property prop;
                String substring = number.substring(2);
                if (number.startsWith("mc")) {
                    prop = new Property();
                    prop.setPropertyType("material");
                    DynamicObject materialInventory = BusinessDataServiceHelper.loadSingle((String)"bd_materialinventoryinfo", (String)"id,name,number,masterid.name,masterid.number", (QFilter[])new QFilter[]{new QFilter("masterid.number", "=", (Object)substring)});
                    value = new PropertyValue();
                    if (materialInventory != null) {
                        id = materialInventory.getLong("id");
                        DynamicObject masterId = materialInventory.getDynamicObject("masterid");
                        value.setId(id);
                        value.setName(masterId.getString("name"));
                        value.setNumber(masterId.getString("number"));
                    }
                    prop.setPropertyValue(value);
                    data.add(prop);
                }
                if (number.startsWith("lc")) {
                    prop = new Property();
                    prop.setPropertyType("location");
                    DynamicObject location = BusinessDataServiceHelper.loadSingle((String)"bd_location", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)substring)});
                    value = new PropertyValue();
                    if (location != null) {
                        id = location.getLong("id");
                        value.setId(id);
                        value.setName(location.getString("name"));
                        value.setNumber(location.getString("number"));
                    }
                    prop.setPropertyValue(value);
                    data.add(prop);
                }
                if (number.startsWith("wc")) {
                    prop = new Property();
                    prop.setPropertyType("warehouse");
                    DynamicObject warehouse = BusinessDataServiceHelper.loadSingle((String)"bd_warehouse", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)substring)});
                    value = new PropertyValue();
                    if (warehouse != null) {
                        id = warehouse.getLong("id");
                        value.setId(id);
                        value.setName(warehouse.getString("name"));
                        value.setNumber(warehouse.getString("number"));
                    }
                    prop.setPropertyValue(value);
                    data.add(prop);
                }
                if (!number.startsWith("nu")) continue;
                prop = new Property();
                prop.setPropertyType("qty");
                PropertyValue value2 = new PropertyValue();
                value2.setName("qty");
                value2.setData(substring);
                prop.setPropertyValue(value2);
                data.add(prop);
            }
        }
        result.setData(data);
        return result;
    }
}

