/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.business.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.msmob.common.design.MobileFormFactory;
import kd.scmc.msmob.common.utils.MetaUtils;
import kd.scmc.msmob.pojo.PushParams;
import kd.sdk.mpscmm.msmob.expoint.IMobBotpResultHandlerPlugin;

public class BotpHelper {
    public static final String PC_ENTITY_NUMBER = "pcEntityNumber";
    private static final Log LOG = LogFactory.getLog(BotpHelper.class);

    public static ConvertOperationResult singlePushBill(PushParams pushParams) {
        String srcEntityNumber = pushParams.getSrcEntityKey();
        String srcMainEntryKey = pushParams.getSrcMainEntryKey();
        String targetEntityNumber = pushParams.getTargetEntityKey();
        QFilter srcEntityFilter = pushParams.getSrcEntityFilter();
        return BotpHelper.singlePushBill(targetEntityNumber, srcEntityNumber, srcMainEntryKey, srcEntityFilter);
    }

    public static ConvertOperationResult singlePushBill(String targetEntityKey, String srcEntityKey, String srcMainEntryKey, QFilter srcFilter) {
        LOG.info("\u201cBotpHelper.singlePushBill\u201d\u65b9\u6cd5\u7684\u5165\u53c2\u201ctargetEntityKey\u201d\uff1a\u201c{}\u201d\uff0c\u201csrcEntityKey\u201d\uff1a\u201c{}\u201d\uff0c\u201csrcMainEntryKey\u201d\uff1a\u201c{}\u201d\uff0c\u201csrcFilter\u201d\uff1a\u201c{}\u201d", new Object[]{targetEntityKey, srcEntityKey, srcMainEntryKey, srcFilter});
        BotpHelper.checkPushParamters(targetEntityKey, srcEntityKey, srcMainEntryKey, srcFilter);
        String filterStr = srcFilter.toString();
        if (!filterStr.contains("billno") && !filterStr.contains("id")) {
            LOG.warn("BotpHelper.singlePushBill\u65b9\u6cd5\u7684\u5165\u53c2\u201csrcFilter\u201d\u4e2d\u6ca1\u6709\u5305\u542b\u201c\u5355\u636eID\u201d\u6216\u8005\u201c\u5355\u636e\u7f16\u53f7\u201d\u7b5b\u9009\u6761\u4ef6\u3002");
            String errMsg = String.format(ResManager.loadKDString((String)"BotpHelper.singlePushBill\u65b9\u6cd5\u7684\u5165\u53c2\u201csrcFilter\u201d\u4e2d\u5fc5\u987b\u5305\u542b\u201c\u5355\u636eID\u201d\u6216\u8005\u201c\u5355\u636e\u7f16\u53f7\u201d\u7b5b\u9009\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BotpHelper_FilterErr", (String)"scmc-msmob-form", (Object[])new Object[0]), srcEntityKey);
            throw new KDBizException(errMsg);
        }
        String srcMainEntryIdKey = srcMainEntryKey + "." + "id";
        DynamicObjectCollection srcBills = QueryServiceHelper.query((String)srcEntityKey, (String)("id," + srcMainEntryIdKey), (QFilter[])srcFilter.toArray());
        if (srcBills == null || srcBills.size() == 0) {
            LOG.warn("\u7b5b\u9009\u6761\u4ef6\u4e3a\u201c{}\u201d\u7684\u201c{}\u201d\u5355\u636e\u4e0d\u6ee1\u8db3\u8f6c\u6362\u89c4\u5219\u6761\u4ef6\u6216\u5df2\u4ecePC\u7aef\u5b9e\u4f53\u79fb\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u636e\u3002", (Object)srcFilter.toString(), (Object)srcEntityKey);
            String errMsg = String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u636e\u201c%s\u201d\u4e0d\u6ee1\u8db3\u8f6c\u6362\u89c4\u5219\u6761\u4ef6\u6216\u5df2\u4ecePC\u7aef\u5b9e\u4f53\u79fb\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u636e\u3002", (String)"BotpHelper_0", (String)"scmc-msmob-form", (Object[])new Object[0]), srcEntityKey);
            throw new KDBizException(errMsg);
        }
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(10);
        for (DynamicObject srcBill : srcBills) {
            ListSelectedRow row = new ListSelectedRow();
            long billId = srcBill.getLong("id");
            long entryId = srcBill.getLong(srcMainEntryIdKey);
            row.setPrimaryKeyValue((Object)billId);
            row.setEntryEntityKey(srcMainEntryKey);
            row.setEntryPrimaryKeyValue((Object)entryId);
            selectedRows.add(row);
        }
        return BotpHelper.push(srcEntityKey, targetEntityKey, selectedRows);
    }

    public static ConvertOperationResult push(String srcEntityKey, String targetEntityKey, List<ListSelectedRow> rows) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntityKey);
        pushArgs.setTargetEntityNumber(targetEntityKey);
        pushArgs.setSelectedRows(rows);
        pushArgs.setBuildConvReport(true);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (pushResult != null && !pushResult.isSuccess()) {
            String pushErrMsg = pushResult.getMessage();
            LOG.warn("\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u89c4\u5219\u540e\u91cd\u8bd5\u3002", (Object)pushErrMsg);
            PluginProxy pluginProxy = PluginProxy.create((Object)new IMobBotpResultHandlerPlugin(){

                public void onBotpFailed(ConvertOperationResult convertOperationResult) {
                }
            }, IMobBotpResultHandlerPlugin.class, (String)IMobBotpResultHandlerPlugin.class.getName(), null);
            pluginProxy.callReplaceIfPresent(p -> {
                p.onBotpFailed(pushResult);
                return null;
            });
            String errMsg = String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a%s\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u89c4\u5219\u540e\u91cd\u8bd5\u3002", (String)"BotpHelper_1", (String)"scmc-msmob-form", (Object[])new Object[0]), pushErrMsg);
            throw new KDBizException(errMsg);
        }
        return pushResult;
    }

    private static void checkPushParamters(String targetEntityKey, String srcEntityKey, String srcMainEntryKey, QFilter srcFilter) {
        if (StringUtils.isEmpty((String)targetEntityKey)) {
            String errMsg = ResManager.loadKDString((String)"\u201cBotpHelper.singlePushBill\u201d\u65b9\u6cd5\u7684\u5165\u53c2\u76ee\u6807\u5355\u6807\u8bc6\u201ctargetEntityKey\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BotpHelper_4", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        if (StringUtils.isEmpty((String)srcEntityKey)) {
            String errMsg = ResManager.loadKDString((String)"\u201cBotpHelper.singlePushBill\u201d\u65b9\u6cd5\u7684\u5165\u53c2\u6e90\u5355\u6807\u8bc6\u201csrcEntityKey\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BotpHelper_5", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        if (StringUtils.isEmpty((String)srcMainEntryKey)) {
            String errMsg = ResManager.loadKDString((String)"\u201cBotpHelper.singlePushBill\u201d\u65b9\u6cd5\u7684\u5165\u53c2\u6e90\u5355\u4e3b\u5355\u636e\u4f53\u6807\u8bc6\u201csrcMainEntryKey\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BotpHelper_6", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        if (srcFilter == null) {
            String errMsg = ResManager.loadKDString((String)"\u201cBotpHelper.singlePushBill\u201d\u65b9\u6cd5\u7684\u5165\u53c2\u6e90\u5355\u8fc7\u6ee4\u5668\u201csrcFilter\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BotpHelper_7", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
    }

    public static List<DynamicObject> getTargetBills(ConvertOperationResult pushResult) {
        if (pushResult == null) {
            LOG.warn("\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u83b7\u53d6\u4e0b\u63a8\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u89c4\u5219\u540e\u91cd\u8bd5\u3002");
            String errMsg = ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u83b7\u53d6\u4e0b\u63a8\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u89c4\u5219\u540e\u91cd\u8bd5\u3002", (String)"BotpHelper_2", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        if (!pushResult.isSuccess()) {
            String pushErrMsg = pushResult.getMessage();
            LOG.warn("{}", (Object)pushErrMsg);
            String errMsg = String.format(ResManager.loadKDString((String)"%s", (String)"BotpHelper_14", (String)"scmc-msmob-form", (Object[])new Object[0]), pushErrMsg);
            throw new KDBizException(errMsg);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)pushResult.getTargetEntityNumber());
        List targetBills = pushResult.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dataEntityType) {
                BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)dataEntityType);
            }
        }, targetMainType);
        if (targetBills == null || targetBills.isEmpty()) {
            LOG.warn("\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u83b7\u53d6\u76ee\u6807\u5355\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u89c4\u5219\u540e\u91cd\u8bd5\u3002");
            String errMsg = ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u83b7\u53d6\u76ee\u6807\u5355\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u89c4\u5219\u540e\u91cd\u8bd5\u3002", (String)"BotpHelper_3", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        return targetBills;
    }

    public static DynamicObject getPushBill(String convertResult, boolean isSetEntryId) {
        if (StringUtils.isEmpty((String)convertResult)) {
            String errMsg = ResManager.loadKDString((String)"\u201cBotpHelper.getPushBill\u201d\u65b9\u6cd5\u7684\u5165\u53c2\u201cconvertResult\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BotpHelper_9", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        ConvertOperationResult convertOpResult = (ConvertOperationResult)SerializationUtils.fromJsonString((String)convertResult, ConvertOperationResult.class);
        List<DynamicObject> targetBills = BotpHelper.getTargetBills(convertOpResult);
        if (targetBills == null || targetBills.size() == 0) {
            String errMsg = ResManager.loadKDString((String)"\u901a\u8fc7\u8f6c\u6362\u7ed3\u679c\u83b7\u53d6\u5230\u7a7a\u7684\u76ee\u6807\u5355\uff0c\u8bf7\u6838\u5bf9\u201cBotpHelper.getPushBill\u201d\u65b9\u6cd5\u7684\u5165\u53c2\u201cconvertResult\u201d\u3002", (String)"BotpHelper_8", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        DynamicObject bill = targetBills.get(0);
        if (isSetEntryId) {
            String formKey = bill.getDataEntityType().getName();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formKey);
            Map allEntities = dataEntityType.getAllEntities();
            if (allEntities == null || allEntities.isEmpty()) {
                return bill;
            }
            for (Map.Entry entityTypeInfo : allEntities.entrySet()) {
                int entrySize;
                DynamicObjectCollection billEntry;
                EntityType entityType = (EntityType)entityTypeInfo.getValue();
                if (entityType instanceof MainEntityType || entityType instanceof LinkEntryType) continue;
                String entryKey = (String)entityTypeInfo.getKey();
                if (!bill.getDataEntityType().getProperties().containsKey((Object)entryKey) || (billEntry = bill.getDynamicObjectCollection(entryKey)) == null || (entrySize = billEntry.size()) == 0) continue;
                long[] entryIds = ID.genLongIds((int)entrySize);
                for (int i = 0; i < entrySize; ++i) {
                    long entryId = entryIds[i];
                    DynamicObject entryRow = (DynamicObject)billEntry.get(i);
                    entryRow.set("id", (Object)entryId);
                }
            }
        }
        return bill;
    }

    public static void trackDown(DynamicObject dynamicObject, IFormView view) {
        Map map = BFTrackerServiceHelper.loadBillLinkDownNodes((String)dynamicObject.getDataEntityType().getName(), (Long[])new Long[]{(Long)dynamicObject.getPkValue()}, (boolean)true);
        if (map == null || map.isEmpty() || map.values().isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u5728\u9650\u5b9a\u7684\u4e0b\u67e5\u5355\u636e\u8303\u56f4\u5185\uff0c\u6ca1\u6709\u627e\u5230\u5173\u8054\u6570\u636e\u3002", (String)"BotpHelper_trackDown_none", (String)"scmc-msmob-form", (Object[])new Object[0]);
            view.showTipNotification(msg);
            return;
        }
        ArrayList<BFRowLinkDownNode> nodes = new ArrayList<BFRowLinkDownNode>(map.values());
        Map<Long, HashSet<Long>> mainTableIdMap = BotpHelper.findLookDownMainTableIds(nodes);
        if (mainTableIdMap.size() == 1) {
            for (Map.Entry<Long, HashSet<Long>> entry : mainTableIdMap.entrySet()) {
                Long mainTableId = entry.getKey();
                HashSet<Long> billIds = entry.getValue();
                if (billIds.size() != 1) continue;
                TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)mainTableId);
                if (tableDefine == null) {
                    return;
                }
                BotpHelper.showBillForm(view, tableDefine, billIds.iterator().next());
                return;
            }
        }
        String json = SerializationUtils.serializeToBase64(nodes);
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId("msmob_botp_track");
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCustomParam("TRACK_DOWN_RESULT_PARAM", (Object)json);
        formShowParameter.setCustomParam(PC_ENTITY_NUMBER, (Object)dynamicObject.getDynamicObjectType().getName());
        formShowParameter.setCustomParam("billId", dynamicObject.getPkValue());
        view.showForm((FormShowParameter)formShowParameter);
    }

    private static void addTableBillId(Map<Long, HashSet<Long>> allTableBillIds, BFRowId rowId) {
        Long mainTableId = rowId.getMainTableId();
        Long billId = rowId.getBillId();
        HashSet billIds = allTableBillIds.computeIfAbsent(mainTableId, k -> new HashSet());
        billIds.add(billId);
    }

    private static Map<Long, HashSet<Long>> findLookDownMainTableIds(List<BFRowLinkDownNode> linkDownNodes) {
        ArrayList targetNodes = new ArrayList();
        for (BFRowLinkDownNode node : linkDownNodes) {
            targetNodes.addAll(node.findAllChildNodes());
        }
        LinkedHashMap<Long, HashSet<Long>> targetTableIds = new LinkedHashMap<Long, HashSet<Long>>();
        for (BFRowLinkDownNode targetNode : targetNodes) {
            BFRowId rowId = targetNode.getRowId();
            BotpHelper.addTableBillId(targetTableIds, rowId);
        }
        return targetTableIds;
    }

    private static void showBillForm(IFormView view, TableDefine tableDefine, Long billId) {
        MobileFormShowParameter showParameter;
        String entityNumber = tableDefine.getEntityNumber();
        MobileFormFactory mobileFormFactory = new MobileFormFactory();
        QFilter filter = new QFilter("id", "=", (Object)billId);
        DynamicObject[] entity = BusinessDataServiceHelper.loadWithPermission((String)entityNumber, (String)"id,billno,billstatus", (QFilter[])filter.toArray(), (String)"", (int)10, (String)"mobim");
        if (entity != null && entity.length == 1) {
            String billStatus = entity[0].getString("billstatus");
            String mobileFormKey = mobileFormFactory.getMobileFormKey(entityNumber, billStatus);
            String billNo = entity[0].getString("billno");
            Object appHomeOrgId = view.getFormShowParameter().getCustomParam("orgid");
            showParameter = new MobileFormShowParameter();
            showParameter.setCustomParam("billno", (Object)billNo);
            showParameter.setCustomParam("billid", (Object)billId);
            showParameter.setCustomParam("orgid", appHomeOrgId);
            showParameter.setCustomParam("mainOrg", appHomeOrgId);
            if (!MetaUtils.isExistsMeta(mobileFormKey)) {
                showParameter.setFormId("msmob_botp_trackdown_tips");
            } else {
                showParameter.setFormId(mobileFormKey);
            }
        } else {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u5355\u636e\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u3002", (String)"BotpHelper_10", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm((FormShowParameter)showParameter);
    }
}

