/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.business.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.mcontrol.MBlockMenuAp;
import kd.bos.metadata.form.mcontrol.MBlockMenuItemAp;

public class CustomHomePageHelper {
    public static ControlAp<?> getChildControlAp(ContainerAp<?> containerAp, String controlKey) {
        List items = containerAp.getItems();
        for (ControlAp item : items) {
            ControlAp<?> controlAp;
            if (item.getKey().equals(controlKey)) {
                return item;
            }
            if (!(item instanceof ContainerAp) || (controlAp = CustomHomePageHelper.getChildControlAp((ContainerAp)item, controlKey)) == null) continue;
            return controlAp;
        }
        return null;
    }

    public static List<MBlockMenuItemAp> getMorePageMenuItemAps(String formKey) {
        FormMetadata formMetadata = CustomHomePageHelper.getFormMetaData(formKey);
        if (formMetadata == null) {
            return new ArrayList<MBlockMenuItemAp>(0);
        }
        List metadataItems = formMetadata.getItems();
        List<MBlockMenuItemAp> allMenuItems = CustomHomePageHelper.convertToMenuItemAps(metadataItems);
        return CustomHomePageHelper.buildBlockMenuItemAps(allMenuItems);
    }

    public static String getControlName(String id, FormMetadata formMetadata) {
        if (formMetadata == null) {
            return "";
        }
        ControlAp controlAp = formMetadata.getItems().stream().filter(item -> item.getKey().equals(id)).findFirst().orElse(null);
        return controlAp != null ? controlAp.getName().getLocaleValue() : "";
    }

    public static List<MBlockMenuItemAp> convertToMenuItemAps(List<ControlAp<?>> metadataItems) {
        ArrayList<MBlockMenuItemAp> menuItemsAp = new ArrayList<MBlockMenuItemAp>(8);
        metadataItems.forEach(item -> {
            if (item instanceof MBlockMenuItemAp) {
                menuItemsAp.add((MBlockMenuItemAp)item);
            }
        });
        return menuItemsAp;
    }

    public static List<MBlockMenuItemAp> getHomePageMenuItemsAp(String homePageMenuKey, String homePageKey) {
        MBlockMenuAp controlAp = CustomHomePageHelper.getHomePageMenuAp(homePageMenuKey, homePageKey);
        if (controlAp == null) {
            return new ArrayList<MBlockMenuItemAp>();
        }
        List<MBlockMenuItemAp> mBlockMenuItemAps = CustomHomePageHelper.convertToMenuItemAps(controlAp.getItems());
        return CustomHomePageHelper.buildBlockMenuItemAps(mBlockMenuItemAps);
    }

    public static MBlockMenuAp getHomePageMenuAp(String menuApKey, String homePageKey) {
        FormMetadata mainMeta = CustomHomePageHelper.getFormMetaData(homePageKey);
        if (mainMeta == null) {
            return null;
        }
        return mainMeta.getItems().stream().filter(a -> menuApKey.equals(a.getKey())).findAny().orElse(null);
    }

    private static List<MBlockMenuItemAp> buildBlockMenuItemAps(List<MBlockMenuItemAp> mBlockMenuItemAps) {
        return mBlockMenuItemAps.stream().map(item -> {
            MBlockMenuItemAp mBlockMenuItemAp = new MBlockMenuItemAp();
            mBlockMenuItemAp.setImageKey(item.getImageKey());
            mBlockMenuItemAp.setKey(item.getKey());
            mBlockMenuItemAp.setName(item.getName());
            mBlockMenuItemAp.setExt(item.isExt());
            mBlockMenuItemAp.setHidden(item.isHidden());
            mBlockMenuItemAp.setVisible(item.getVisible());
            mBlockMenuItemAp.setInvisible(item.isInvisible());
            return mBlockMenuItemAp;
        }).collect(Collectors.toList());
    }

    public static FormMetadata getFormMetaData(String key) {
        String idByNumber = MetadataDao.getIdByNumber((String)key, (MetaCategory)MetaCategory.Form);
        return idByNumber == null ? null : (FormMetadata)MetadataDao.readRuntimeMeta((String)idByNumber, (MetaCategory)MetaCategory.Form);
    }

    public static Set<String> getOriginalMenuItemsWithPermission(Map<String, Boolean> checkResult, String homePageMenuKey, String homePageKey, String morePageKey) {
        List<MBlockMenuItemAp> allOriginalMenuItemAps = CustomHomePageHelper.getAllOriginalMenuItemAps(homePageMenuKey, homePageKey, morePageKey);
        if (allOriginalMenuItemAps == null) {
            return new HashSet<String>();
        }
        Set<String> originalKeys = allOriginalMenuItemAps.stream().map(AbstractElement::getKey).collect(Collectors.toSet());
        Set withOutPermissionKeys = checkResult.entrySet().stream().filter(entry -> ((Boolean)entry.getValue()).equals(Boolean.FALSE)).map(Map.Entry::getKey).collect(Collectors.toSet());
        originalKeys.removeIf(withOutPermissionKeys::contains);
        return originalKeys;
    }

    public static List<MBlockMenuItemAp> getAllMenuItems(String homePageMenuKey, String homePageKey, String morePageKey) {
        List<MBlockMenuItemAp> homePageMenuItemsAp = CustomHomePageHelper.getHomePageMenuItemsAp(homePageMenuKey, homePageKey);
        if (homePageMenuItemsAp == null) {
            return new ArrayList<MBlockMenuItemAp>();
        }
        List<MBlockMenuItemAp> morePageMenuItemAps = CustomHomePageHelper.getMorePageMenuItemAps(morePageKey);
        homePageMenuItemsAp.addAll(morePageMenuItemAps);
        return homePageMenuItemsAp.stream().filter(CustomHomePageHelper.distinctByKey(AbstractElement::getKey)).filter(menuItemAp -> !menuItemAp.isInvisible()).collect(Collectors.toList());
    }

    public static List<String> getAllMenuItemKeys(String homePageMenuKey, String homePageKey, String morePageKey) {
        List<MBlockMenuItemAp> allMenuItems = CustomHomePageHelper.getAllMenuItems(homePageMenuKey, homePageKey, morePageKey);
        if (allMenuItems == null) {
            return new ArrayList<String>();
        }
        return allMenuItems.stream().map(AbstractElement::getKey).collect(Collectors.toList());
    }

    public static Set<String> getExtMenuItems(String homePageMenuKey, String homePageKey, String morePageKey) {
        List<MBlockMenuItemAp> allMenuItems = CustomHomePageHelper.getAllMenuItems(homePageMenuKey, homePageKey, morePageKey);
        if (allMenuItems == null) {
            return null;
        }
        return allMenuItems.stream().filter(AbstractElement::isExt).map(AbstractElement::getKey).collect(Collectors.toSet());
    }

    public static List<MBlockMenuItemAp> getAllOriginalMenuItemAps(String homePageMenuKey, String homePageKey, String morePageKey) {
        List<MBlockMenuItemAp> allMenuItems = CustomHomePageHelper.getAllMenuItems(homePageMenuKey, homePageKey, morePageKey);
        if (allMenuItems == null) {
            return new ArrayList<MBlockMenuItemAp>();
        }
        return allMenuItems.stream().filter(menuItemAp -> !menuItemAp.isExt()).collect(Collectors.toList());
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap(4);
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }
}

