/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.msmob.business.helper.MetaHelper;
import kd.scmc.msmob.common.design.strategy.colsselect.IColsSelectStrategy;
import kd.scmc.msmob.common.design.strategy.colsselect.PcColumnSelectStrategy;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.EntryMappingRelationship;
import kd.scmc.msmob.pojo.PropertyNode;

public class DataSourceConfigHelper {
    public static Map<String, String> getMobFormF7Range() {
        HashMap<String, String> numberToName = new HashMap<String, String>(16);
        DynamicObjectCollection baseForms = DataSourceConfigHelper.getBaseForms();
        QFilter inheritPathFilter = null;
        for (DynamicObject baseForm : baseForms) {
            QFilter filter = new QFilter("inheritpath", "like", (Object)("%" + baseForm.getString("id") + "%"));
            if (inheritPathFilter == null) {
                inheritPathFilter = filter;
                continue;
            }
            inheritPathFilter.or(filter);
        }
        if (inheritPathFilter != null) {
            DynamicObjectCollection formMetas = QueryServiceHelper.query((String)"bos_formmeta", (String)"number,name", (QFilter[])inheritPathFilter.toArray());
            for (DynamicObject formMeta : formMetas) {
                String name = formMeta.getString("name");
                String number = formMeta.getString("number");
                numberToName.put(number, name);
            }
        }
        return numberToName;
    }

    private static DynamicObjectCollection getBaseForms() {
        ArrayList<String> baseFormNumbers = new ArrayList<String>(10);
        baseFormNumbers.add("mob_base_formtpl");
        baseFormNumbers.add("mob_base_listtpl");
        QFilter qFilter = new QFilter("number", "in", baseFormNumbers);
        return QueryServiceHelper.query((String)"bos_formmeta", (String)"id", (QFilter[])qFilter.toArray());
    }

    public static QFilter getPcEntityF7Filter() {
        ArrayList<String> modelTypes = new ArrayList<String>(10);
        modelTypes.add("BillFormModel");
        modelTypes.add("BaseFormModel");
        modelTypes.add("BalanceModel");
        return new QFilter("modeltype", "in", modelTypes);
    }

    public static boolean checkTypeExcepted(String mobFieldType, String pcFieldType) {
        if (kd.bos.util.StringUtils.isEmpty((String)mobFieldType) && kd.bos.util.StringUtils.isEmpty((String)pcFieldType)) {
            return true;
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)mobFieldType) && kd.bos.util.StringUtils.isEmpty((String)pcFieldType)) {
            return false;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)mobFieldType) && kd.bos.util.StringUtils.isNotEmpty((String)pcFieldType)) {
            return false;
        }
        if (mobFieldType.equals(pcFieldType)) {
            return true;
        }
        if ("TextProp".equals(mobFieldType) && "MuliLangTextProp".equals(pcFieldType)) {
            return true;
        }
        return "OrgProp".equals(mobFieldType) && "MainOrgProp".equals(pcFieldType);
    }

    public static boolean checkTypeExcepted(IMetadata mobFieldType, IMetadata pcFieldType) {
        if (mobFieldType instanceof BasedataProp && pcFieldType instanceof BasedataProp) {
            String baseEntityId = ((BasedataProp)mobFieldType).getBaseEntityId();
            String entityId = ((BasedataProp)pcFieldType).getBaseEntityId();
            if (kd.bos.util.StringUtils.isNotEmpty((String)baseEntityId) && baseEntityId.equals(entityId)) {
                return true;
            }
        }
        String mobFieldClass = mobFieldType == null ? "" : mobFieldType.getClass().getSimpleName();
        String pcFieldClass = pcFieldType == null ? "" : pcFieldType.getClass().getSimpleName();
        return DataSourceConfigHelper.checkTypeExcepted(mobFieldClass, pcFieldClass);
    }

    public static Map<String, PropertyNode> getPcPropNodeMap(String pcEntityObjKey) {
        MetaHelper metaHelper = new MetaHelper((IColsSelectStrategy)new PcColumnSelectStrategy(), pcEntityObjKey);
        PropertyNode pcPropNodeTree = metaHelper.buildTree();
        return metaHelper.depthFirst(pcPropNodeTree);
    }

    public static Map<String, String> getEntityTypeMap(IDataEntityProperty prop) {
        if (prop == null) {
            String errMsg = ResManager.loadKDString((String)"DataSourceConfigHelper.getEntityTypeKey\u65b9\u6cd5\u7684\u5165\u53c2\u201cprop\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataSourceConfigHelper_2", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        HashMap<String, String> entityTypeMap = new HashMap<String, String>(16);
        IDataEntityType parentProp = prop.getParent();
        while (parentProp != null) {
            if (parentProp instanceof EntryType) {
                String entityKey = parentProp.getName();
                LocaleString entityNameLocalStr = parentProp.getDisplayName();
                String entityName = entityNameLocalStr == null ? "" : entityNameLocalStr.getLocaleValue();
                entityTypeMap.put(entityKey, entityName);
                return entityTypeMap;
            }
            if (parentProp instanceof MainEntityType) {
                entityTypeMap.put("-", "-");
                return entityTypeMap;
            }
            parentProp = prop.getParent();
        }
        entityTypeMap.put("-", "-");
        return entityTypeMap;
    }

    public static String getPcEntryKey(DataSourceConfig dataSourceConfig, String mobEntryKey) {
        List<EntryMappingRelationship> entryMappingRelationships = dataSourceConfig.getEntryMappingRelationships();
        if (StringUtils.isEmpty((CharSequence)mobEntryKey) || entryMappingRelationships == null || entryMappingRelationships.isEmpty()) {
            return "";
        }
        for (EntryMappingRelationship entryMappingRelationship : entryMappingRelationships) {
            String mEntryKey = entryMappingRelationship.getMobEntryKey();
            if (!mobEntryKey.equals(mEntryKey)) continue;
            return entryMappingRelationship.getPcEntryKey();
        }
        return "";
    }

    public static EntryMappingRelationship getEntryMappingRelationship(DataSourceConfig dataSourceConfig, String entryKey) {
        List<EntryMappingRelationship> entryMappingRelationships = dataSourceConfig.getEntryMappingRelationships();
        if (kd.bos.util.StringUtils.isEmpty((String)entryKey) || entryMappingRelationships == null || entryMappingRelationships.isEmpty()) {
            return new EntryMappingRelationship();
        }
        for (EntryMappingRelationship entryMappingRelationship : entryMappingRelationships) {
            String mobEntryKey = entryMappingRelationship.getMobEntryKey();
            String pcEntryKey = entryMappingRelationship.getPcEntryKey();
            if (!mobEntryKey.equals(entryKey) && !pcEntryKey.equals(entryKey)) continue;
            return entryMappingRelationship;
        }
        return new EntryMappingRelationship();
    }
}

