/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.business.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.IDataEntityBinder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.msmob.business.helper.change.DataSourceHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.PropertyNode;

public class EntityCacheHelper {
    private static final ThreadLocal<DynamicObject> PC_ENTITY_THREAD_HOLDER = new ThreadLocal();
    private static final ThreadLocal<Boolean> PC_ENTITY_SAVE_TRIGGERED = ThreadLocal.withInitial(() -> false);

    public static void clearThreadHolder() {
        PC_ENTITY_THREAD_HOLDER.remove();
        PC_ENTITY_SAVE_TRIGGERED.remove();
    }

    public static DynamicObject getCurrentEntity() {
        return PC_ENTITY_THREAD_HOLDER.get();
    }

    public static <P extends AbstractFormPlugin> void onPluginDestroyed(P pluginPage) {
        IFormView pcEntityStorageView = ((IMobilePage)pluginPage).getPcEntityStorageView();
        EntityCacheHelper.savePcEntityToPageCacheOfCurrentThread(pcEntityStorageView);
        EntityCacheHelper.clearThreadHolder();
    }

    public static boolean isNew(Long billId) {
        return billId.equals(0L);
    }

    public static DynamicObject createPcEntityObject(String pcEntityKey) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)pcEntityKey);
        DynamicObject newPcEntity = new DynamicObject((DynamicObjectType)dataEntityType);
        long id = DB.genLongId((String)pcEntityKey);
        newPcEntity.set("id", (Object)id);
        return newPcEntity;
    }

    public static DynamicObject getPcEntityObject(Long billId, String pcEntityKey) {
        if (!billId.equals(0L)) {
            DynamicObject singleData = BusinessDataServiceHelper.loadSingle((Object)billId, (String)pcEntityKey);
            return singleData;
        }
        return null;
    }

    public static Map<String, DynamicObject> newEntryRow(IFormView view, String mobEntryKey, String pcEntityKey) {
        IPageCache pageCache = view.getPageCache();
        IDataModel model = view.getModel();
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(2);
        long entryId = DB.genLongId((String)pcEntityKey);
        DynamicObject pcEntity = EntityCacheHelper.getPcEntityFromCache(view, pcEntityKey);
        if (pcEntity != null) {
            String pcEntryKey = pageCache.get(mobEntryKey);
            DynamicObjectCollection pcEntryCollection = pcEntity.getDynamicObjectCollection(pcEntryKey);
            int currEntryRowCount = model.getEntryCurrentRowIndex(mobEntryKey);
            int nextEntryRowSeq = currEntryRowCount + 1;
            DynamicObject newPcEntryRow = pcEntryCollection.addNew();
            newPcEntryRow.set("id", (Object)entryId);
            newPcEntryRow.set("seq", (Object)nextEntryRowSeq);
            model.beginInit();
            model.setValue("mobentryid", (Object)entryId, nextEntryRowSeq - 1);
            model.endInit();
            map.put("pcEntity", pcEntity);
            map.put("newPcEntryRow", newPcEntryRow);
        }
        return map;
    }

    @Deprecated
    public static String savePcEntityToPageCache(IFormView pageView, DynamicObject pcEntity) {
        PC_ENTITY_THREAD_HOLDER.set(pcEntity);
        PC_ENTITY_SAVE_TRIGGERED.set(true);
        return null;
    }

    private static void savePcEntityToPageCacheOfCurrentThread(IFormView pageView) {
        Boolean triggered = PC_ENTITY_SAVE_TRIGGERED.get();
        if (!triggered.booleanValue()) {
            return;
        }
        DynamicObject pcEntity = PC_ENTITY_THREAD_HOLDER.get();
        String cacheString = pcEntity == null ? null : EntityCacheHelper.serializeFromEntityToString(pcEntity);
        pageView.getPageCache().putBigObject("pcEntityCache", cacheString);
    }

    public static String serializeFromEntityToString(DynamicObject dynamicObject) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(false);
        option.setIncludeCollectionProperty(true);
        option.setIncludeDataEntityState(true);
        option.setIncludeType(true);
        option.setDataEntityBinder(new IDataEntityBinder(){

            public boolean isSerializProperty(IDataEntityProperty prop, DataEntitySerializerOption option) {
                if (prop instanceof DynamicLocaleProperty) {
                    return true;
                }
                return prop instanceof MulBasedataProp ? true : super.isSerializProperty(prop, option);
            }
        });
        String dataStr = DataEntitySerializer.serializerToString((Object)dynamicObject, (DataEntitySerializerOption)option);
        return dataStr;
    }

    public static DynamicObject deserializeFromStringToEntity(String string, IDataEntityType dataEntityType) {
        DynamicObject dyn = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)string, (IDataEntityType)dataEntityType);
        BusinessDataReader.loadRefence((Object[])new DynamicObject[]{dyn}, (IDataEntityType)dataEntityType);
        return dyn;
    }

    public static void updateMobNewEntrySetValue(IFormView view, String mobEntryKey, Map<String, PropertyNode> fieldMapping, Map<String, List<String>> mobEntryKeyToFiledKeys, DynamicObject newPcEntryRow, int currEntryRowIndex) {
        IDataModel model = view.getModel();
        model.beginInit();
        List<String> mobEntryKeys = mobEntryKeyToFiledKeys.get(mobEntryKey);
        for (Map.Entry<String, PropertyNode> stringPropertyNodeEntry : fieldMapping.entrySet()) {
            String mobFieldKey = stringPropertyNodeEntry.getKey();
            if (!mobEntryKeys.contains(mobFieldKey)) continue;
            PropertyNode propertyNode = stringPropertyNodeEntry.getValue();
            String pcFieldKey = StringUtils.substringAfter((String)propertyNode.getFieldKey(), (String)(propertyNode.getParentNode().getFieldKey() + "."));
            model.setValue(mobFieldKey, newPcEntryRow.get(pcFieldKey), currEntryRowIndex);
            view.updateView(mobFieldKey, currEntryRowIndex);
        }
        model.endInit();
    }

    public static DynamicObject getPcEntityFromCache(IFormView view, String pcEntityKey) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)pcEntityKey);
        return EntityCacheHelper.getPcEntityFromCache(view, dataEntityType);
    }

    public static DynamicObject getPcEntityFromCache(IMobilePage page) {
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig(page);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)dataSourceConfig.getPcEntityKey());
        return EntityCacheHelper.getPcEntityFromCache(page.getPcEntityStorageView(), dataEntityType);
    }

    private static DynamicObject getPcEntityFromCache(IFormView view, MainEntityType dataEntityType) {
        IPageCache mainPageCache = view.getPageCache();
        return EntityCacheHelper.getPcEntityFromCache(mainPageCache, dataEntityType);
    }

    private static DynamicObject getPcEntityFromCache(IPageCache cache, MainEntityType dataEntityType) {
        DynamicObject dynamicObject = PC_ENTITY_THREAD_HOLDER.get();
        if (dynamicObject != null) {
            return dynamicObject;
        }
        String pcEntityCacheStr = cache.getBigObject("pcEntityCache");
        if (StringUtils.isEmpty((CharSequence)pcEntityCacheStr)) {
            return null;
        }
        dynamicObject = EntityCacheHelper.deserializeFromStringToEntity(pcEntityCacheStr, (IDataEntityType)dataEntityType);
        PC_ENTITY_THREAD_HOLDER.set(dynamicObject);
        return dynamicObject;
    }

    public static int getVisitingEntryIndex(IFormView view) {
        return Integer.parseInt(view.getPageCache().get("row"));
    }
}

