/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.msmob.common.consts.InvSchemeConst;
import kd.scmc.msmob.common.utils.MobileControlUtils;
import org.apache.commons.lang3.StringUtils;

public class InverseBillHelper {
    private static final Log log = LogFactory.getLog(InverseBillHelper.class);
    private static final String COLOR_ORANGE = "#ff991c";
    private static final String COLOR_RED = "#ff0000";
    private static final String COLOR_GREY = "#212121";

    public static void handleInverseColumn(IFormView view, DynamicObject invScheme, Set<String> headColumns, Set<String> entryColumns, Set<String> negativeNumColumn) {
        boolean isNegativeBill = InverseBillHelper.isInverseBill(invScheme);
        InverseBillHelper.handleInverseColumn(view, headColumns, entryColumns, negativeNumColumn, isNegativeBill);
    }

    public static void handleInverseColumn(IFormView view, Set<String> headColumns, Set<String> entryColumns, Set<String> negativeNumColumn, boolean isNegativeBill) {
        IDataModel model = view.getModel();
        InverseBillHelper.setInverseColumnColor(view, entryColumns.toArray(new String[0]), isNegativeBill);
        InverseBillHelper.setInverseHeadColumnColor(view, headColumns.toArray(new String[0]), isNegativeBill);
        if (isNegativeBill) {
            InverseBillHelper.setInverseValues(model, negativeNumColumn.toArray(new String[0]));
        }
    }

    public static void handleMentryInverseColumn(IFormView view, Set<String> entryColumns, Set<String> negativeNumColumn, boolean isNegativeBill, int startIndex, int endIndex) {
        IDataModel model = view.getModel();
        InverseBillHelper.setMentryColumsColor(view, entryColumns.toArray(new String[0]), isNegativeBill, startIndex, endIndex);
        if (isNegativeBill) {
            InverseBillHelper.setInverseValues(model, negativeNumColumn.toArray(new String[0]));
        }
    }

    public static void setInverseColumnColor(IFormView view, String[] redColumns, boolean isInverseBill) {
        InverseBillHelper.setEntryColumsColor(view, redColumns, isInverseBill);
    }

    public static void setInverseHeadColumnColor(IFormView view, String[] redColumns, boolean isInverseBill) {
        InverseBillHelper.setHeadColumsColor(view, redColumns, isInverseBill);
    }

    public static void setHeadColumsColor(IFormView view, String[] redColumns, boolean isInverseBill) {
        for (String column : redColumns) {
            Control control = view.getControl(column);
            String key = control.getKey();
            HashMap<String, String> dataMap = new HashMap<String, String>(32);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(key);
            list.add(dataMap);
            String color = COLOR_GREY;
            if (isInverseBill) {
                color = COLOR_RED;
            }
            dataMap.put("fc", color);
            IClientViewProxy proxy = (IClientViewProxy)control.getView().getService(IClientViewProxy.class);
            proxy.addAction("updateControlMetadata", list);
        }
    }

    public static void setInverseValues(IDataModel model, String[] needInverseColumns) {
        DynamicObjectCollection entry = model.getEntryEntity("entryentity");
        int size = entry.size();
        for (int i = 0; i < size; ++i) {
            for (String column : needInverseColumns) {
                BigDecimal value = ((DynamicObject)entry.get(i)).getBigDecimal(column);
                if (value == null) {
                    value = BigDecimal.ZERO;
                }
                InverseBillHelper.setValue(model, column, value.abs(), i);
            }
        }
    }

    public static void setValue(IDataModel model, String key, Object value, int i) {
        if (value == null) {
            model.setValue(key, null, i);
        } else {
            model.setValue(key, value instanceof DynamicObject ? ((DynamicObject)value).getPkValue() : value, i);
        }
    }

    public static boolean isInverseBill(DynamicObject invScheme) {
        if (invScheme == null) {
            return false;
        }
        boolean isInverseBill = false;
        DynamicObject transceiverType = (invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)invScheme.getPkValue(), (String)"im_invscheme", (String)InvSchemeConst.getAllSelector())).getDynamicObject("transceivertype");
        if (transceiverType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5e93\u5b58\u4e8b\u52a1\u672a\u914d\u7f6e\u6536\u53d1\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"InverseBillHelper_0", (String)"scmc-msmob-form", (Object[])new Object[0]));
        }
        String bizDirection = transceiverType.getString("bizdirection");
        if (StringUtils.isEmpty((CharSequence)bizDirection)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5f53\u524d\u5e93\u5b58\u4e8b\u52a1\u7684\u201c\u6536\u53d1\u7c7b\u578b\u201d\u7684\u4e1a\u52a1\u65b9\u5411\u3002", (String)"InverseBillHelper_1", (String)"scmc-msmob-form", (Object[])new Object[0]));
        }
        if ("1".equals(bizDirection)) {
            isInverseBill = true;
        }
        return isInverseBill;
    }

    public static void setEntryColumsColor(IFormView view, String[] redColumns, boolean isInverseBill) {
        DynamicObjectCollection entity = view.getModel().getEntryEntity("entryentity");
        if (entity == null || entity.isEmpty()) {
            return;
        }
        InverseBillHelper.setMentryColumsColor(view, redColumns, isInverseBill, 0, entity.size());
    }

    public static void setMentryColumsColor(IFormView view, String[] redColumns, boolean isInverseBill, int startIndex, int endIndex) {
        CardEntry grid = (CardEntry)view.getControl("entryentity");
        DynamicObjectCollection entity = view.getModel().getEntryEntity("entryentity");
        if (entity == null || entity.isEmpty()) {
            return;
        }
        HashMap<String, Object> proData = new HashMap<String, Object>(2);
        String color = COLOR_ORANGE;
        if (isInverseBill) {
            color = COLOR_RED;
        }
        proData.put("fc", color);
        for (int i = startIndex; i <= endIndex; ++i) {
            MobileControlUtils.setCardEntryRowProperties(grid, i, proData, redColumns);
        }
    }
}

