/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.msmob.common.design.strategy.colsselect.IColsSelectStrategy;
import kd.scmc.msmob.common.design.strategy.colsselect.PcColumnSelectStrategy;
import kd.scmc.msmob.pojo.PropertyNode;

public class MetaHelper {
    private IColsSelectStrategy strategy;
    private MainEntityType mainEntityType;
    private Boolean onlyDisplayEntryId;

    public MetaHelper(IColsSelectStrategy strategy, MainEntityType mainEntityType) {
        if (mainEntityType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"MetaHelper:\u4f20\u5165\u7684\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MetaHelper_0", (String)"scmc-msmob-form", (Object[])new Object[0]));
        }
        this.mainEntityType = mainEntityType;
        this.strategy = strategy == null ? new PcColumnSelectStrategy() : strategy;
        this.onlyDisplayEntryId = Boolean.FALSE;
    }

    public MetaHelper(IColsSelectStrategy strategy, String metaNo) {
        this(strategy, MetadataServiceHelper.getDataEntityType((String)metaNo));
    }

    public MetaHelper(String metaNo) {
        this(null, metaNo);
    }

    public MetaHelper(MainEntityType meta) {
        this(null, meta);
    }

    private String getRootId() {
        return "0";
    }

    public String buildTree2JSON() {
        return SerializationUtils.toJsonString((Object)this.buildTree().getTreeNode());
    }

    public Map<String, PropertyNode> depthFirst(PropertyNode propNodeTree) {
        HashMap<String, PropertyNode> propNodeMap = new HashMap<String, PropertyNode>(16);
        if (propNodeTree == null) {
            return propNodeMap;
        }
        Stack<PropertyNode> stack = new Stack<PropertyNode>();
        stack.push(propNodeTree);
        while (!stack.isEmpty()) {
            PropertyNode propNode = (PropertyNode)stack.pop();
            propNode.setTreeNode(null);
            propNodeMap.put(propNode.getFieldKey(), propNode);
            List<PropertyNode> childrenNodes = propNode.getChildren();
            if (childrenNodes == null) continue;
            for (PropertyNode entityNode : childrenNodes) {
                stack.push(entityNode);
            }
        }
        return propNodeMap;
    }

    public PropertyNode buildTree() {
        Map allFields = this.mainEntityType.getAllFields();
        HashMap<String, PropertyNode> propNodeMap = new HashMap<String, PropertyNode>();
        HashMap<String, TreeNode> treeNodeMap = new HashMap<String, TreeNode>();
        String rootId = this.getRootId();
        PropertyNode propRoot = new PropertyNode();
        TreeNode root = new TreeNode(null, rootId, this.mainEntityType.getDisplayName().getLocaleValue());
        treeNodeMap.put(rootId, root);
        root.setIsOpened(true);
        propRoot.setType((IMetadata)this.mainEntityType);
        propRoot.setTreeNode(root);
        propRoot.setFieldKey(rootId);
        propNodeMap.put(rootId, propRoot);
        for (IDataEntityProperty pro : allFields.values()) {
            IDataEntityType parent = pro.getParent();
            if (parent == null) continue;
            Boolean isOnlyDisplayEntryId = this.getOnlyDisplayEntryId();
            if (isOnlyDisplayEntryId.booleanValue()) {
                if (!(parent instanceof EntryType)) continue;
                this.buildEntryIdNodeTree(propNodeMap, treeNodeMap, propRoot, root, parent, pro);
                continue;
            }
            this.buildAllPropNodeTree(propNodeMap, treeNodeMap, propRoot, root, parent, pro);
        }
        return propRoot;
    }

    private void buildAllPropNodeTree(Map<String, PropertyNode> propNodeMap, Map<String, TreeNode> treeNodeMap, PropertyNode propRoot, TreeNode root, IDataEntityType parent, IDataEntityProperty pro) {
        if (parent instanceof MainEntityType) {
            this.strategy.buildHeadPropNode(propRoot, pro);
        } else if (parent instanceof EntryType && parent.getParent() instanceof MainEntityType) {
            if (!this.strategy.filterEntryPro((EntryType)parent)) {
                return;
            }
            this.buildEntryPropNode(propNodeMap, treeNodeMap, propRoot, root, parent, pro);
        } else if (parent instanceof EntryType && parent.getParent() instanceof EntryType) {
            if (!this.strategy.filterEntryPro((EntryType)parent)) {
                return;
            }
            this.buildSubEntryPropNode(propNodeMap, treeNodeMap, propRoot, parent, pro);
        }
    }

    private void buildEntryIdNodeTree(Map<String, PropertyNode> propNodeMap, Map<String, TreeNode> treeNodeMap, PropertyNode propRoot, TreeNode root, IDataEntityType parent, IDataEntityProperty pro) {
        if (this.strategy.isMobForm()) {
            String proName = pro.getName();
            if (pro instanceof BigIntProp && proName.endsWith("entryid")) {
                this.buildEntryPropNode(propNodeMap, treeNodeMap, propRoot, root, parent, pro);
            }
        } else {
            ISimpleProperty primaryKey = parent.getPrimaryKey();
            if (parent instanceof SubEntryType) {
                if (!this.strategy.filterEntryPro((EntryType)parent)) {
                    return;
                }
                this.buildSubEntryPropNode(propNodeMap, treeNodeMap, propRoot, parent, (IDataEntityProperty)primaryKey);
            } else {
                if (!this.strategy.filterEntryPro((EntryType)parent)) {
                    return;
                }
                this.buildEntryPropNode(propNodeMap, treeNodeMap, propRoot, root, parent, (IDataEntityProperty)primaryKey);
            }
        }
    }

    private void buildSubEntryPropNode(Map<String, PropertyNode> propNodeMap, Map<String, TreeNode> treeNodeMap, PropertyNode propRoot, IDataEntityType parent, IDataEntityProperty pro) {
        EntryType grandParent = (EntryType)parent.getParent();
        PropertyNode subEntryNode = this.getEntryNode(propNodeMap, treeNodeMap, parent);
        PropertyNode entryNode = this.getEntryNode(propNodeMap, treeNodeMap, (IDataEntityType)grandParent);
        subEntryNode.setParentNode(entryNode);
        entryNode.setParentNode(propRoot);
        this.strategy.buildSubEntryPropNode(entryNode, subEntryNode, pro);
        TreeNode entryTreeNode = entryNode.getTreeNode();
        TreeNode subEntryTreeNode = subEntryNode.getTreeNode();
        String subEntryNodeId = subEntryTreeNode.getId();
        if (!treeNodeMap.containsKey(subEntryNodeId)) {
            treeNodeMap.put(subEntryNodeId, subEntryTreeNode);
            entryTreeNode.addChild(subEntryTreeNode);
        }
        if (!propNodeMap.containsKey(subEntryNodeId)) {
            propNodeMap.put(subEntryNodeId, subEntryNode);
            this.addPropChildNode(entryNode, subEntryNode);
        }
    }

    private void buildEntryPropNode(Map<String, PropertyNode> propNodeMap, Map<String, TreeNode> treeNodeMap, PropertyNode propRoot, TreeNode root, IDataEntityType parent, IDataEntityProperty pro) {
        PropertyNode entryNode = this.getEntryNode(propNodeMap, treeNodeMap, parent);
        entryNode.setParentNode(propRoot);
        this.strategy.buildEntryPropNode(entryNode, pro);
        TreeNode entryTreeNode = entryNode.getTreeNode();
        String entryNodeId = entryTreeNode.getId();
        if (!treeNodeMap.containsKey(entryNodeId)) {
            treeNodeMap.put(entryNodeId, entryTreeNode);
            root.addChild(entryTreeNode);
        }
        if (!propNodeMap.containsKey(entryNodeId)) {
            propNodeMap.put(entryNodeId, entryNode);
            this.addPropChildNode(propRoot, entryNode);
        }
    }

    private PropertyNode getEntryNode(Map<String, PropertyNode> propNodeMap, Map<String, TreeNode> nodeMap, IDataEntityType entryPro) {
        String treeNodeId;
        PropertyNode entryNode;
        String entryName = entryPro.getName();
        TreeNode entryTreeNode = nodeMap.get(entryName);
        if (entryTreeNode == null) {
            entryTreeNode = this.strategy.getTreeNode(this.getRootId(), entryName, entryPro.getDisplayName().toString());
            entryTreeNode.setIsOpened(true);
        }
        if ((entryNode = propNodeMap.get(treeNodeId = entryTreeNode.getId())) == null) {
            entryNode = new PropertyNode();
            entryNode.setTreeNode(entryTreeNode);
            entryNode.setType((IMetadata)entryPro);
            entryNode.setFieldKey(treeNodeId);
        }
        return entryNode;
    }

    private void addPropChildNode(PropertyNode propNode, PropertyNode propChildNode) {
        List<PropertyNode> propChildren = propNode.getChildren();
        if (propChildren == null) {
            propNode.addChild(propChildNode);
            return;
        }
        ArrayList<String> propChildrenIds = new ArrayList<String>(10);
        for (PropertyNode childNode : propChildren) {
            propChildrenIds.add(childNode.getFieldKey());
        }
        if (!propChildrenIds.contains(propChildNode.getFieldKey())) {
            propNode.addChild(propChildNode);
        }
    }

    public Boolean getOnlyDisplayEntryId() {
        return this.onlyDisplayEntryId;
    }

    public void setOnlyDisplayEntryId(Boolean onlyDisplayEntryId) {
        this.onlyDisplayEntryId = onlyDisplayEntryId;
    }
}

