/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.msmob.business.helper.BotpHelper;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.PropertyNode;

public class Mob2PcEntityTranslatorHelper {
    private static final Log log = LogFactory.getLog(Mob2PcEntityTranslatorHelper.class);

    public static DynamicObject getPcEntity(DynamicObject dataEntity, DataSourceConfig dataSourceConfig, OperateOption operateOption) {
        DynamicObject pcDynamicObject = Mob2PcEntityTranslatorHelper.getDynamicObject(dataEntity.getString("billId"), dataSourceConfig.getPcEntityKey(), operateOption);
        Map<String, PropertyNode> fieldMapping = dataSourceConfig.getFieldMapping();
        HashMap<String, List<String>> entryFiledMap = new HashMap<String, List<String>>(16);
        DynamicObjectCollection pcSaveDynamicObjectCollection = new DynamicObjectCollection();
        for (Map.Entry<String, PropertyNode> entry : fieldMapping.entrySet()) {
            PropertyNode pcField = entry.getValue();
            Mob2PcEntityTranslatorHelper.setMainValue(entry, pcField, pcDynamicObject, dataEntity, entryFiledMap);
        }
        Mob2PcEntityTranslatorHelper.setPushBillEntryId(dataEntity, operateOption, pcDynamicObject);
        for (Map.Entry<String, PropertyNode> entry : entryFiledMap.entrySet()) {
            DynamicObjectCollection pcEntryCollection = pcDynamicObject.getDynamicObjectCollection(entry.getKey());
            DynamicObjectCollection mobEntryCollection = dataEntity.getDynamicObjectCollection("entryentity");
            if (pcEntryCollection == null || pcEntryCollection.isEmpty()) continue;
            for (int i = 0; i < pcEntryCollection.size(); ++i) {
                DynamicObject pcItem = (DynamicObject)pcEntryCollection.get(i);
                Object pcPkValue = pcItem.getPkValue();
                for (int k = 0; k < mobEntryCollection.size(); ++k) {
                    DynamicObject mobItem = (DynamicObject)mobEntryCollection.get(k);
                    Long mobPkValue = mobItem.getLong("mobentryid");
                    if (!pcPkValue.equals(mobPkValue)) continue;
                    List entryFieldList = (List)((Object)entry.getValue());
                    for (String entryField : entryFieldList) {
                        PropertyNode propertyNode = fieldMapping.get(entryField);
                        String fieldKey = propertyNode.getFieldKey();
                        Object value = mobItem.get(entryField);
                        pcItem.set(StringUtils.substringAfter((String)fieldKey, (String)(entry.getKey() + ".")), value);
                    }
                    pcSaveDynamicObjectCollection.add((Object)pcItem);
                }
            }
            pcDynamicObject.set(entry.getKey(), (Object)pcSaveDynamicObjectCollection);
        }
        return pcDynamicObject;
    }

    public static void setPushBillEntryId(DynamicObject mobDataEntity, OperateOption operateOption, DynamicObject pcBill) {
        String pcEntryKey;
        Map opVariables = operateOption.getVariables();
        String convertResult = (String)opVariables.get("convertResult");
        String isPushSaved = (String)opVariables.get("isPushSaved");
        if (StringUtils.isNotEmpty((CharSequence)convertResult) && StringUtils.isNotEmpty((CharSequence)isPushSaved) && "false".equals(isPushSaved) && StringUtils.isNotEmpty((CharSequence)(pcEntryKey = operateOption.getVariableValue("entryentity")))) {
            DynamicObjectCollection mobEntryCollection = mobDataEntity.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection pcEntryCollection = pcBill.getDynamicObjectCollection(pcEntryKey);
            for (int i = 0; i < mobEntryCollection.size(); ++i) {
                DynamicObject pcEntryRow = (DynamicObject)pcEntryCollection.get(i);
                DynamicObject mobEntryRow = (DynamicObject)mobEntryCollection.get(i);
                long mobEntryId = mobEntryRow.getLong("mobentryid");
                pcEntryRow.set("id", (Object)mobEntryId);
            }
        }
    }

    public static void setMainValue(Map.Entry<String, PropertyNode> fieldMappingItem, PropertyNode pcField, DynamicObject dataEntity, DynamicObject billData, Map<String, List<String>> entryFiledMap) {
        PropertyNode parentNode = pcField.getParentNode();
        if (parentNode.getType() instanceof MainEntityType) {
            String pcFieldKey = fieldMappingItem.getValue().getFieldKey();
            Object pcValueOj = dataEntity.get(pcFieldKey);
            Object mobValueOj = billData.get(fieldMappingItem.getKey());
            if (mobValueOj instanceof DynamicObject) {
                DynamicObject mobValue = (DynamicObject)mobValueOj;
                DynamicObject pcValue = (DynamicObject)pcValueOj;
                if (pcValue == null || !pcValue.getPkValue().equals(mobValue.getPkValue())) {
                    MainEntityType pcMainEntityType = (MainEntityType)dataEntity.getDynamicObjectType();
                    BasedataProp basedataProp = (BasedataProp)pcMainEntityType.findProperty(pcFieldKey);
                    DynamicObject pcNewValue = BusinessDataServiceHelper.loadSingleFromCache((Object)mobValue.getPkValue(), (DynamicObjectType)((DynamicObjectType)basedataProp.getComplexType((Object)dataEntity)));
                    basedataProp.setValue((Object)dataEntity, (Object)pcNewValue);
                }
            } else {
                dataEntity.set(pcFieldKey, mobValueOj);
            }
            return;
        }
        if (parentNode.getType() instanceof EntityType) {
            List<String> newKey = entryFiledMap.get(parentNode.getFieldKey());
            if (newKey == null) {
                ArrayList<String> keys = new ArrayList<String>();
                keys.add(fieldMappingItem.getKey());
                entryFiledMap.put(parentNode.getFieldKey(), keys);
            } else {
                newKey.add(fieldMappingItem.getKey());
                entryFiledMap.put(parentNode.getFieldKey(), newKey);
            }
            return;
        }
        Mob2PcEntityTranslatorHelper.setMainValue(fieldMappingItem, pcField.getParentNode(), dataEntity, billData, entryFiledMap);
    }

    public static DynamicObject getDynamicObject(String pcId, String pcEntityKey, OperateOption operateOption) {
        log.info("\u8c03\u7528Mob2PcEntityTranslatorHelper\u65b9\u6cd5\u201cgetDynamicObject\u201d\u4f20\u5165\u53c2\u6570\uff0cpcId\u201c{}\u201d\uff0cpcEntityKey\u201c{}\u201d\uff0coperateOption\u201c{}\u201d", new Object[]{pcId, pcEntityKey, operateOption});
        if (StringUtils.isEmpty((CharSequence)pcId) || StringUtils.isEmpty((CharSequence)pcEntityKey) || operateOption == null) {
            String errMsg = ResManager.loadKDString((String)"\u8c03\u7528Mob2PcEntityTranslatorHelper\u7684getDynamicObject\u65b9\u6cd5\u7684\u5165\u53c2\u201cpcId\u201d\u6216\u201cpcEntityKey\u201d\u6216\u201coperateOption\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"Mob2PcEntityTranslatorHelper_0", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        Map opVariables = operateOption.getVariables();
        String convertResult = (String)opVariables.get("convertResult");
        if (StringUtils.isEmpty((CharSequence)convertResult)) {
            if (!QueryServiceHelper.exists((String)pcEntityKey, (Object)pcId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"Mob2PcEntityTranslatorHelper_1", (String)"scmc-msmob-form", (Object[])new Object[0]));
            }
            return BusinessDataServiceHelper.loadSingle((Object)pcId, (String)pcEntityKey);
        }
        String isPushSaved = (String)opVariables.get("isPushSaved");
        if (StringUtils.isNotEmpty((CharSequence)isPushSaved) && "true".equals(isPushSaved)) {
            if (!QueryServiceHelper.exists((String)pcEntityKey, (Object)pcId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"Mob2PcEntityTranslatorHelper_1", (String)"scmc-msmob-form", (Object[])new Object[0]));
            }
            return BusinessDataServiceHelper.loadSingle((Object)pcId, (String)pcEntityKey);
        }
        return BotpHelper.getPushBill(convertResult, false);
    }
}

