/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.business.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.msmob.common.enums.BillStatusEnum;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBillInfoTplPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBillListTplPlugin;

public class PermissionHelper {
    private static final String BOS_ORG = "bos_org";
    private static final String MODIFY = "modify";
    private static final String MUTEX = "mutex";
    private static final String IDENT_EQ_KEY = "1";
    private static final Integer IDENT_EQ_VAL = 1;
    private static Log log = LogFactory.getLog(PermissionHelper.class);

    public static boolean checkPermission(Long userId, Long orgId, String appId, String entityNum, String permItemId) {
        log.info("\u8c03\u7528PermissionServiceHelper\u65b9\u6cd5\u201ccheckPermission\u201d\u4f20\u5165\u53c2\u6570userId\u201c{}\u201d\uff0corgId\u201c{}\u201d\uff0cappId\u201c{}\u201d\uff0centityNum\u201c{}\u201d\uff0cpermItemId\u201c{}\u201d", new Object[]{userId, orgId, appId, entityNum, permItemId});
        int hasPermResult = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)"15", (String)appId, (String)entityNum, (String)permItemId);
        log.info("\u8c03\u7528PermissionServiceHelper\u65b9\u6cd5\u201ccheckPermission\u201dhasPermResult\u201c{}\u201d", (Object)hasPermResult);
        return hasPermResult == 1;
    }

    public static boolean checkPermission(Long orgId, String appId, String entityKey, String permItemId) {
        log.info("\u8c03\u7528PermissionServiceHelper\u65b9\u6cd5\u201ccheckPermission\u201d\u4f20\u5165\u53c2\u6570\uff0corgId\u201c{}\u201d\uff0cappId\u201c{}\u201d\uff0centityKey\u201c{}\u201d\uff0cpermItemId\u201c{}\u201d", new Object[]{orgId, appId, entityKey, permItemId});
        int hasPermResult = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (Long)orgId, (String)"15", (String)appId, (String)entityKey, (String)permItemId);
        log.info("\u8c03\u7528PermissionServiceHelper\u65b9\u6cd5\u201ccheckPermission\u201dhasPermResult\u201c{}\u201d", (Object)hasPermResult);
        return hasPermResult == 1;
    }

    private static QFilter getIdentEqFilter() {
        return new QFilter(IDENT_EQ_KEY, "=", (Object)IDENT_EQ_VAL);
    }

    public static List<Long> getUserAllHasPermOrgs() {
        DynamicObjectCollection orgDys;
        ArrayList<Long> hasPermOrgs = new ArrayList<Long>(10);
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)UserServiceHelper.getCurrentUserId());
        QFilter qFilter = PermissionHelper.getIdentEqFilter();
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            qFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
        }
        if ((orgDys = QueryServiceHelper.query((String)BOS_ORG, (String)"id", (QFilter[])qFilter.toArray())) == null || orgDys.size() == 0) {
            return hasPermOrgs;
        }
        for (DynamicObject org : orgDys) {
            hasPermOrgs.add(org.getLong("id"));
        }
        return hasPermOrgs;
    }

    public static boolean userHasSpecificPerm(long userId, String appId, String entityNum, String permItemId) {
        return PermissionServiceHelper.hasSpecificPerm((long)userId, (String)appId, (String)entityNum, (String)permItemId);
    }

    private static boolean isAddModificationMutex(String billStatus, boolean isEditable) {
        boolean result = false;
        if (BillStatusEnum.SAVE.getValue().equals(billStatus) && isEditable) {
            result = true;
        }
        return result;
    }

    public static void setViewByPermissions(MobBillInfoTplPlugin plugin, Object billId) {
        boolean hasModifyPerm;
        FormShowParameter showParameter = plugin.getView().getFormShowParameter();
        String pcEntityKey = plugin.getPcEntityKey();
        Object mainOrgId = showParameter.getCustomParam("mainOrg");
        Boolean isStrict = Boolean.TRUE;
        StringBuilder errMsg = new StringBuilder();
        boolean isAddModifyMutex = plugin.isAddModificationMutex();
        boolean checkModifyPerm = PermissionHelper.getCheckModifyPerm(plugin);
        if (checkModifyPerm && plugin.isEditable() && mainOrgId != null && !(hasModifyPerm = PermissionHelper.checkPermission(Long.valueOf(mainOrgId.toString()), plugin.getPcAppId(), plugin.getPcEntityKey(), "4715a0df000000ac"))) {
            String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4fee\u6539\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"PermissionHelper_2", (String)"scmc-msmob-form", (Object[])new Object[0]);
            plugin.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(MODIFY));
            return;
        }
        boolean networkExclusive = true;
        if (isAddModifyMutex && !(networkExclusive = MutexHelper.require((IFormView)plugin.getView(), (String)pcEntityKey, (Object)billId, (String)MODIFY, (boolean)isStrict, (StringBuilder)errMsg))) {
            plugin.getView().showConfirm(errMsg.toString(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(MUTEX));
        }
        if (plugin.isFromList() || networkExclusive) {
            plugin.getPageCache().put("myLock", "true");
        }
    }

    public static boolean checkModify(MobBillListTplPlugin plugin, String billStatus, Long orgId) {
        boolean hasModifyPerm;
        if (plugin.isCheckModifyPerm(billStatus) && !(hasModifyPerm = PermissionHelper.checkPermission(orgId, plugin.getPcAppId(), plugin.getPcEntityKey(), "4715a0df000000ac"))) {
            String msg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4fee\u6539\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002\u662f\u5426\u8fdb\u5165\u67e5\u770b\u9875\u9762\uff1f", (String)"PermissionHelper_1", (String)"scmc-msmob-form", (Object[])new Object[0]);
            plugin.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(MODIFY));
            return false;
        }
        return true;
    }

    public static boolean checkMutexAndModify(MobBillListTplPlugin plugin, String billStatus, Long billId, Long orgId) {
        if (!PermissionHelper.checkModify(plugin, billStatus, orgId)) {
            return false;
        }
        if (plugin.isAddModificationMutex(billStatus)) {
            StringBuilder errMsg = new StringBuilder();
            boolean networkExclusive = MutexHelper.require((String)plugin.getPcEntityKey(), (Object)billId, (String)MODIFY, (boolean)Boolean.TRUE, (StringBuilder)errMsg);
            if (!networkExclusive) {
                plugin.getView().showConfirm(String.valueOf(errMsg), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(MUTEX));
                return false;
            }
        }
        return true;
    }

    private static boolean getCheckModifyPerm(MobBillInfoTplPlugin plugin) {
        if (plugin.getView().getFormShowParameter().getCustomParam("checkModifyPerm") != null) {
            Object checkModifyPerm = plugin.getView().getFormShowParameter().getCustomParam("checkModifyPerm");
            boolean modifyPerm = plugin.isCheckModifyPerm();
            if (checkModifyPerm instanceof Boolean) {
                return Boolean.TRUE.equals(checkModifyPerm) && modifyPerm;
            }
        }
        return plugin.isCheckModifyPerm();
    }
}

