/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.business.helper;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.msmob.common.enums.SchemeEnum;

public class SchemeOpHelper {
    public static final String DATA_SORT = "recentusetime desc,id asc";

    public static OperationResult deleteScheme(Long id) {
        List<Long> ids = Collections.singletonList(id);
        return SchemeOpHelper.batchDeleteScheme(ids);
    }

    private static OperationResult batchDeleteScheme(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(false);
            String errMsg = ResManager.loadKDString((String)"\u5355\u636eid\u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"SchemeOpHelper_0", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        return OperationServiceHelper.executeOperate((String)"delete", (String)"msmob_scheme", (Object[])ids.toArray(), null);
    }

    public static DynamicObject getSingleScheme(Long schemeId) {
        return BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"msmob_scheme", (String)SchemeOpHelper.getAllFields());
    }

    public static DynamicObject getSingleScheme(String schemeType, String schemeName) {
        QFilter qFilter = new QFilter("creator", "=", (Object)UserServiceHelper.getCurrentUserId());
        qFilter.and("schemetype", "=", (Object)schemeType);
        qFilter.and("schemename", "=", (Object)schemeName);
        return BusinessDataServiceHelper.loadSingle((String)"msmob_scheme", (String)SchemeOpHelper.getAllFields(), (QFilter[])qFilter.toArray());
    }

    public static DynamicObject[] getAllScheme(String schemeType) {
        QFilter qFilter = new QFilter("creator", "=", (Object)UserServiceHelper.getCurrentUserId());
        qFilter.and("schemetype", "=", (Object)schemeType);
        return BusinessDataServiceHelper.load((String)"msmob_scheme", (String)SchemeOpHelper.getAllFields(), (QFilter[])qFilter.toArray(), (String)DATA_SORT);
    }

    public static void addRecentScheme(String schemeType, String content, String description) {
        DynamicObject scheme = SchemeOpHelper.getSchemeDyObj(schemeType, SchemeEnum.RECENT_SCHEME_NAME.getName(), new Date(), Boolean.TRUE, content, description);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
    }

    public static void saveRecentScheme(String schemeType, String content, String description) {
        if (SchemeOpHelper.isExistsRecentScheme(schemeType)) {
            DynamicObject recentScheme = SchemeOpHelper.getRecentScheme(schemeType);
            recentScheme.set("recentusetime", (Object)new Date());
            recentScheme.set("content_tag", (Object)content);
            recentScheme.set("description", (Object)description);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recentScheme});
        } else {
            SchemeOpHelper.addRecentScheme(schemeType, content, description);
        }
    }

    public static void updateSchemeTime(Long schemeId) {
        QFilter qFilter = new QFilter("id", "=", (Object)schemeId);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((String)"msmob_scheme", (String)SchemeOpHelper.getAllFields(), (QFilter[])qFilter.toArray());
        if (scheme != null) {
            scheme.set("recentusetime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
        }
    }

    public static boolean isExistsRecentScheme(String schemeType) {
        QFilter recentQfilter = new QFilter("creator", "=", (Object)UserServiceHelper.getCurrentUserId());
        recentQfilter.and("schemetype", "=", (Object)schemeType);
        recentQfilter.and("schemename", "=", (Object)SchemeEnum.RECENT_SCHEME_NAME.getName());
        return QueryServiceHelper.exists((String)"msmob_scheme", (QFilter[])recentQfilter.toArray());
    }

    public static DynamicObject getRecentScheme(String schemeType) {
        QFilter recentQfilter = new QFilter("creator", "=", (Object)UserServiceHelper.getCurrentUserId());
        recentQfilter.and("schemetype", "=", (Object)schemeType);
        recentQfilter.and("schemename", "=", (Object)SchemeEnum.RECENT_SCHEME_NAME.getName());
        return BusinessDataServiceHelper.loadSingle((String)"msmob_scheme", (String)SchemeOpHelper.getAllFields(), (QFilter[])recentQfilter.toArray());
    }

    public static Long saveScheme(String schemeType, String schemeName, String content, String description) {
        DynamicObject scheme;
        QFilter qFilter = new QFilter("creator", "=", (Object)UserServiceHelper.getCurrentUserId());
        qFilter.and("schemetype", "=", (Object)schemeType);
        qFilter.and("schemename", "=", (Object)schemeName);
        DynamicObject[] schemes = BusinessDataServiceHelper.load((String)"msmob_scheme", (String)SchemeOpHelper.getAllFields(), (QFilter[])qFilter.toArray());
        if (schemes != null && schemes.length > 0) {
            scheme = schemes[0];
            scheme.set("content_tag", (Object)content);
            scheme.set("description", (Object)description);
        } else {
            scheme = SchemeOpHelper.getSchemeDyObj(schemeType, schemeName, new Date(), Boolean.FALSE, content, description);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
        return scheme.getLong("id");
    }

    public static String getAllFields() {
        return "id,schemename,creator,modifytime,default,description,status,modifier,enable,createtime,masterid,schemetype,recentusetime,content,description,content_tag";
    }

    public static DynamicObject getSchemeDyObj(String schemeType, String schemeName, Date recentDate, Boolean isSelect, String content, String description) {
        MainEntityType sieveScheEntityType = EntityMetadataCache.getDataEntityType((String)"msmob_scheme");
        DynamicObject sieveSchemeObj = (DynamicObject)sieveScheEntityType.createInstance();
        RequestContext requestContext = RequestContext.get();
        Long currUserId = requestContext.getCurrUserId();
        sieveSchemeObj.set("schemetype", (Object)schemeType);
        sieveSchemeObj.set("schemename", (Object)schemeName);
        sieveSchemeObj.set("creator", (Object)currUserId);
        sieveSchemeObj.set("recentusetime", (Object)recentDate);
        sieveSchemeObj.set("default", (Object)isSelect);
        sieveSchemeObj.set("content_tag", (Object)content);
        sieveSchemeObj.set("status", (Object)"A");
        sieveSchemeObj.set("description", (Object)description);
        return sieveSchemeObj;
    }
}

