/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.msmob.business.helper.AppParameterHelper;

public class WareHouseIsolateHelper {
    public static void buildIsolateList(List<Long> orgIds, List<Long> isolateOrgList, List<Long> notIsolateOrgList) {
        DynamicObjectCollection sysParams;
        ParamPublishObject param = ParameterReader.getParameterObject(null, (String)"=9Q86DR2P+Q");
        if (param != null && (sysParams = ParameterHelper.queryAllOrgParams(orgIds, (String)"05", (String)param.getId())) != null) {
            for (DynamicObject sysParam : sysParams) {
                String wareHouseIsolate;
                JSONObject sysParamJson;
                if (sysParam.get("fdata") == null || (sysParamJson = JSONObject.parseObject((String)sysParam.get("fdata").toString())) == null || sysParamJson.isEmpty() || !Boolean.parseBoolean(wareHouseIsolate = sysParamJson.getString("fwarehouseisolate"))) continue;
                isolateOrgList.add(sysParam.getLong("forgid"));
            }
        }
        for (Long orgId : orgIds) {
            if (isolateOrgList.contains(orgId)) continue;
            notIsolateOrgList.add(orgId);
        }
    }

    public static Boolean setWareHouseIsolateF7Filter(String formId, DynamicObject org, ListShowParameter showParameter) {
        QFilter warehouseF7Filter = WareHouseIsolateHelper.getCustomWarehouseF7Filter(formId, org);
        if (warehouseF7Filter == null) {
            return false;
        }
        showParameter.getListFilterParameter().setFilter(warehouseF7Filter);
        return true;
    }

    public static QFilter getCustomWarehouseF7Filter(String formId, DynamicObject org) {
        if (org == null) {
            return null;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        Object wareHouseIsolate = AppParameterHelper.getAppParameterByFormId(formId, (Long)org.getPkValue(), "fwarehouseisolate");
        if (wareHouseIsolate instanceof Boolean && !((Boolean)wareHouseIsolate).booleanValue()) {
            return null;
        }
        List<DynamicObject> wareHouses = "im_invcountscheme".equals(formId) || "im_invcountbill".equals(formId) ? WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId(userId, Collections.singletonList(org.getLong("id")), formId) : WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId(userId, Collections.singletonList(org.getLong("id")));
        if (CollectionUtils.isEmpty(wareHouses)) {
            return null;
        }
        ArrayList<Long> wareHouseIds = new ArrayList<Long>(16);
        for (DynamicObject wareHose : wareHouses) {
            Long wareHosePkValue = (Long)wareHose.getPkValue();
            wareHouseIds.add(wareHosePkValue);
        }
        return new QFilter("id", "in", wareHouseIds);
    }

    public static List<DynamicObject> getWarehouseByUserIdAndOrgId(Long userId, List<Long> orgIds) {
        ArrayList<DynamicObject> warehouses = new ArrayList<DynamicObject>(16);
        if (orgIds.isEmpty()) {
            return warehouses;
        }
        Set<Long> operatorIds = WareHouseIsolateHelper.getOperatorIds(userId);
        DynamicObject[] warehouseSetups = WareHouseIsolateHelper.getWarehouseSetups(orgIds, operatorIds, null);
        WareHouseIsolateHelper.warehouseCorrection(orgIds, warehouses, warehouseSetups);
        return warehouses;
    }

    public static List<DynamicObject> getWarehouseByUserIdAndOrgId(Long userId, List<Long> orgIds, String formId) {
        ArrayList<DynamicObject> warehouses = new ArrayList<DynamicObject>(16);
        if (orgIds.isEmpty()) {
            return warehouses;
        }
        Set<Long> operatorIds = WareHouseIsolateHelper.getOperatorIds(userId);
        DynamicObject[] warehouseSetups = WareHouseIsolateHelper.getWarehouseSetups(orgIds, operatorIds, formId);
        WareHouseIsolateHelper.warehouseCorrection(orgIds, warehouses, warehouseSetups);
        return warehouses;
    }

    private static void warehouseCorrection(List<Long> orgIds, List<DynamicObject> warehouses, DynamicObject[] warehouseSetups) {
        ArrayList<Long> notOperatorOrgIds = new ArrayList<Long>(orgIds);
        for (DynamicObject warehouseSetup : warehouseSetups) {
            warehouses.add(warehouseSetup.getDynamicObject("warehouse"));
            DynamicObject org = warehouseSetup.getDynamicObject("org");
            Object orgId = org.getPkValue();
            notOperatorOrgIds.remove(orgId);
        }
        if (!notOperatorOrgIds.isEmpty()) {
            QFilter orgf = new QFilter("org", "in", (Object)notOperatorOrgIds.toArray());
            orgf.and(new QFilter("startstatus", "=", (Object)"B"));
            Map warehouseDycs = BusinessDataServiceHelper.loadFromCache((String)"im_warehousesetup", (String)"warehouse", (QFilter[])new QFilter[]{orgf});
            for (Map.Entry objectEntry : warehouseDycs.entrySet()) {
                DynamicObject warehouse = ((DynamicObject)objectEntry.getValue()).getDynamicObject("warehouse");
                warehouses.add(warehouse);
            }
        }
    }

    private static DynamicObject[] getWarehouseSetups(List<Long> orgIds, Set<Long> operatorIds, String formId) {
        QFilter qFilter = new QFilter("org", "in", orgIds);
        qFilter.and(new QFilter("operatorentity.operatoruser", "in", operatorIds));
        qFilter.and(new QFilter("startstatus", "=", (Object)"B"));
        if ("im_invcountscheme".equals(formId) || "im_invcountbill".equals(formId)) {
            qFilter.and(new QFilter("initstatus", "=", (Object)"B"));
        }
        return BusinessDataServiceHelper.load((String)"im_warehousesetup", (String)"org,warehouse", (QFilter[])qFilter.toArray());
    }

    private static Set<Long> getOperatorIds(Long userId) {
        QFilter qFilter1 = new QFilter("operatorid", "=", (Object)userId);
        qFilter1.and(new QFilter("opergrptype", "=", (Object)"KCZ"));
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bd_operator", (String)"id", (QFilter[])qFilter1.toArray());
        HashSet<Long> operatorIds = new HashSet<Long>(ids.length);
        if (ids.length <= 0) {
            return operatorIds;
        }
        for (DynamicObject id : ids) {
            operatorIds.add(Long.parseLong(id.getPkValue().toString()));
        }
        return operatorIds;
    }
}

