/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.business.helper.change;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.property.FlexProp;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.flex.FlexService;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.AttachmentEdit;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataSourceHelper;
import kd.scmc.msmob.business.helper.change.EntryMappingIndex;
import kd.scmc.msmob.business.helper.change.IEntryPage;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.business.helper.change.VisitingContext;
import kd.scmc.msmob.business.helper.change.context.AbstractDataChangedContext;
import kd.scmc.msmob.business.helper.change.context.PropertyChangedContext;
import kd.scmc.msmob.business.helper.change.context.RowAddedContext;
import kd.scmc.msmob.business.helper.change.context.RowDeletedContext;
import kd.scmc.msmob.business.helper.change.extension.EntryPageFieldsExtension;
import kd.scmc.msmob.business.helper.change.extension.EntryRowAddedExtension;
import kd.scmc.msmob.business.helper.change.extension.EntryRowDeletedExtension;
import kd.scmc.msmob.business.helper.change.extension.PropertyChangedExtension;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowAddedHandler;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowDeletedHandler;
import kd.scmc.msmob.business.helper.change.handler.IPropertyChangedHandler;
import kd.scmc.msmob.business.helper.change.handler.ManualChangeEntryValueHandler;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.EntryMappingRelationship;
import kd.scmc.msmob.pojo.PropertyNode;

public class DataChangedHandlerHelper {
    private static Log LOG = LogFactory.getLog(DataChangedHandlerHelper.class);

    public static <P extends AbstractFormPlugin, H extends IPropertyChangedHandler> void onPropertyChanged(P pluginPage, H handler, PropertyChangedArgs e) {
        IFormView pcEntityStorageView = ((IMobilePage)pluginPage).getPcEntityStorageView();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        DynamicObject changedDataEntity = changeData.getDataEntity();
        boolean isMain = changedDataEntity.getDataEntityType().getParent() == null;
        int rowIndex = changeData.getRowIndex();
        rowIndex = ((IMobilePage)pluginPage).getIndex(rowIndex);
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        String mobileFieldName = e.getProperty().getName();
        VisitingContext visitingContext = ((IMobilePage)pluginPage).getVisitingContext();
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)pluginPage);
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache(pcEntityStorageView, dataSourceConfig.getPcEntityKey());
        Map<String, PropertyNode> fieldMapping = dataSourceConfig.getFieldMapping();
        PropertyNode pcPropertyNode = fieldMapping.get(mobileFieldName);
        if (pcPropertyNode == null) {
            return;
        }
        String pcFieldKey = pcPropertyNode.getFieldKey();
        if (DataChangedHandlerHelper.equals(oldValue, newValue, pcFieldKey)) {
            LOG.info("\u65e7\u503c\u548c\u65b0\u503c\u76f8\u540c\uff0c\u672a\u89e6\u53d1\u503c\u6539\u53d8");
            return;
        }
        LOG.info("\u65e7\u503c\u548c\u65b0\u503c\u4e0d\u76f8\u540c\uff0c\u89e6\u53d1\u503c\u6539\u53d8");
        PropertyChangedContext context = new PropertyChangedContext(pcEntityFromCache, visitingContext);
        context.setPropertyChangedArgs(e);
        context.setRowIndex(rowIndex);
        context.setNewValue(newValue);
        context.setOldValue(oldValue);
        context.setMobileFieldName(mobileFieldName);
        context.setMain(isMain);
        if (isMain) {
            context.setPcFieldName(pcFieldKey);
            pcEntityFromCache.set(pcFieldKey, DataChangedHandlerHelper.getValue(pcFieldKey, newValue));
            context.setChangePcData(pcEntityFromCache);
        } else {
            String pcEntryName = pcPropertyNode.getParentNode().getFieldKey();
            String pcFieldName = pcPropertyNode.getType().getName();
            context.setPcEntryName(pcEntryName);
            context.setPcFieldName(pcFieldName);
            DynamicObject visitingData = DataChangedHandlerHelper.getVisitingDataByContext(pcEntityFromCache, visitingContext);
            DynamicObjectCollection pcEntryCollection = visitingData.getDynamicObjectCollection(pcEntryName);
            DynamicObject changedData = (DynamicObject)pcEntryCollection.get(rowIndex);
            changedData.set(pcFieldName, newValue);
            context.setChangePcData(changedData);
        }
        if (handler != null) {
            handler.onPropertyChanged(context);
        }
        DataChangedHandlerHelper.invokePropertyChangedExtension(pluginPage, context);
        DynamicObject calculatedResult = context.getCalculatedResult();
        EntityCacheHelper.savePcEntityToPageCache(pcEntityStorageView, calculatedResult);
        boolean isLoad = ((IMobilePage)pluginPage).isLoadPcEntityToMobilePage();
        if (isLoad) {
            LOG.info("\u89e6\u53d1\u6267\u884c\u65b9\u6cd5loadPcEntityToMobilePage\u7684key :{}", (Object)mobileFieldName);
            DataSourceHelper.loadPcEntityToMobilePage(pluginPage, calculatedResult, true);
        }
    }

    public static <P extends AbstractFormPlugin> DynamicObject purgeUnchangedEntries(P pluginPage, IEntryRowDeletedHandler entryRowDeletedHandler) {
        IFormView pcEntityStorageView = ((IMobilePage)pluginPage).getPcEntityStorageView();
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)pluginPage);
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache(pcEntityStorageView, dataSourceConfig.getPcEntityKey());
        IDataModel model = pluginPage.getView().getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        Map allEntities = dataEntityType.getAllEntities();
        AbstractDataChangedContext rowDeletedContext = null;
        for (Map.Entry entityTypeEntry : allEntities.entrySet()) {
            Optional<EntryMappingRelationship> any;
            EntityType entityType = (EntityType)entityTypeEntry.getValue();
            if (!(entityType instanceof EntryType) || !(any = dataSourceConfig.getEntryMappingRelationships().stream().filter(relationship -> relationship.getMobEntryKey().equals(entityTypeEntry.getKey())).findAny()).isPresent()) continue;
            String pcEntryName = any.get().getPcEntryKey();
            VisitingContext visitingContext = ((IMobilePage)pluginPage).getVisitingContext();
            DynamicObject visitingDataByContext = DataChangedHandlerHelper.getVisitingDataByContext(pcEntityFromCache, visitingContext);
            DynamicObjectCollection entryList = visitingDataByContext.getDynamicObjectCollection(pcEntryName);
            for (int i = entryList.size() - 1; i >= 0; --i) {
                DynamicObject entry = (DynamicObject)entryList.get(i);
                DataEntityState entryState = entry.getDataEntityState();
                if (entryState.getFromDatabase() || entryState.isBizChanged() && DataChangedHandlerHelper.isChangeEntry(entryState)) continue;
                rowDeletedContext = DataChangedHandlerHelper.deleteEntry(pluginPage, entryRowDeletedHandler, any.get().getMobEntryKey(), i, dataSourceConfig);
            }
        }
        if (rowDeletedContext == null) {
            return pcEntityFromCache;
        }
        DynamicObject calculatedResult = rowDeletedContext.getCalculatedResult();
        DataSourceHelper.loadPcEntityToMobilePage(pluginPage, calculatedResult, true);
        return calculatedResult;
    }

    private static boolean isChangeEntry(DataEntityState entryState) {
        Iterator iterator = entryState.getBizChangedProperties().iterator();
        boolean isChange = false;
        while (iterator.hasNext()) {
            IDataEntityProperty property = (IDataEntityProperty)iterator.next();
            if ("seq".equals(property.getName())) continue;
            isChange = true;
        }
        return isChange;
    }

    public static boolean equals(Object oldValue, Object newValue, String pcFieldKey) {
        if (oldValue == null && newValue == null) {
            return true;
        }
        if (oldValue == null && newValue != null) {
            return false;
        }
        if (oldValue != null && newValue == null) {
            return false;
        }
        if (newValue instanceof LocaleDynamicObjectCollection) {
            Map convertedNewMap = (Map)DataChangedHandlerHelper.getValue(pcFieldKey, newValue);
            Map convertedOldMap = (Map)DataChangedHandlerHelper.getValue(pcFieldKey, oldValue);
            return convertedNewMap.entrySet().stream().filter(stringStringEntry -> ((String)stringStringEntry.getValue()).equals(convertedOldMap.get(stringStringEntry.getKey()))).findAny().isPresent();
        }
        if (newValue instanceof DynamicObject) {
            LOG.info("\u201c\u503c\u6539\u53d8\u89e6\u53d1\uff1akey\u4e3a{}\u201d", (Object)pcFieldKey);
            return DataChangedHandlerHelper.equalsByDynamicObject((DynamicObject)oldValue, (DynamicObject)newValue);
        }
        if (newValue instanceof MulBasedataDynamicObjectCollection) {
            return DataChangedHandlerHelper.equalsByMulBaseData((MulBasedataDynamicObjectCollection)oldValue, (MulBasedataDynamicObjectCollection)newValue);
        }
        return oldValue.equals(newValue);
    }

    private static boolean equalsByDynamicObject(DynamicObject oldValue, DynamicObject newValue) {
        Object newPkValue = newValue.getPkValue();
        Object oldPkValue = oldValue.getPkValue();
        String newId = String.valueOf(newPkValue);
        String oldId = String.valueOf(oldPkValue);
        LOG.info("\u52a8\u6001\u5bf9\u8c61\u7684id,newId\uff1a{},oldId\uff1a{},equals\u7ed3\u679c\u4e3a\uff1a{}", new Object[]{newId, oldId, newId.equals(oldId)});
        return newId.equals(oldId);
    }

    private static boolean equalsByMulBaseData(MulBasedataDynamicObjectCollection oldValue, MulBasedataDynamicObjectCollection newValue) {
        MulBasedataDynamicObjectCollection newCol = newValue;
        ArrayList<Long> newIds = new ArrayList<Long>(16);
        for (DynamicObject newDyn : newCol) {
            long newId = newDyn.getLong("fbasedataid_id");
            newIds.add(newId);
        }
        MulBasedataDynamicObjectCollection oldCol = oldValue;
        ArrayList<Long> oldIds = new ArrayList<Long>(16);
        for (DynamicObject oldDyn : oldCol) {
            long oldId = oldDyn.getLong("fbasedataid_id");
            oldIds.add(oldId);
        }
        return newIds.equals(oldIds);
    }

    public static Object getValue(String fieldName, Object newValue) {
        if (newValue == null) {
            return null;
        }
        if (newValue instanceof LocaleDynamicObjectCollection) {
            LocaleDynamicObjectCollection localeDynamicObjectCollection = (LocaleDynamicObjectCollection)newValue;
            HashMap<String, String> langMap = new HashMap<String, String>();
            if (!localeDynamicObjectCollection.isEmpty()) {
                for (DynamicObject object : localeDynamicObjectCollection) {
                    String localeid = object.getString("localeid");
                    String name = object.getString(fieldName);
                    langMap.put(localeid, name);
                }
            }
            return langMap;
        }
        return newValue;
    }

    private static void invokePropertyChangedExtension(AbstractFormPlugin plugin, PropertyChangedContext context) {
        PluginProxy pluginProxy = PluginProxy.create(PropertyChangedExtension.class, (String)"mpscmm.msmob.tpl.extension.property.changed");
        pluginProxy.callReplace(p -> {
            p.onPropertyChanged(plugin.getView().getEntityId(), context.getPcEntityName(), plugin, context);
            return null;
        });
    }

    private static void invokeEntryRowAddedExtension(AbstractFormPlugin plugin, RowAddedContext context) {
        PluginProxy pluginProxy = PluginProxy.create(EntryRowAddedExtension.class, (String)"mpscmm.msmob.tpl.extension.entry.added");
        pluginProxy.callReplace(p -> {
            p.afterEntryAddedOperation(plugin.getView().getEntityId(), context.getPcEntityName(), context.getPcEntryKey(), plugin, context);
            return null;
        });
    }

    private static void invokeEntryDeletedExtension(AbstractFormPlugin plugin, RowDeletedContext context) {
        PluginProxy pluginProxy = PluginProxy.create(EntryRowDeletedExtension.class, (String)"mpscmm.msmob.tpl.extension.entry.deleted");
        pluginProxy.callReplace(p -> {
            p.onEntryDeleted(plugin.getView().getEntityId(), context.getPcEntityName(), context.getPcEntryKey(), plugin, context);
            return null;
        });
    }

    public static <P extends AbstractFormPlugin, H extends IEntryRowDeletedHandler> void deleteEntry(P plugin, H handler, String mobileEntryKey, int deletedRowIndex) {
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)plugin);
        RowDeletedContext rowDeletedContext = DataChangedHandlerHelper.deleteEntry(plugin, handler, mobileEntryKey, deletedRowIndex, dataSourceConfig);
        DynamicObject calculatedResult = rowDeletedContext.getCalculatedResult();
        DataSourceHelper.loadPcEntityToMobilePage(plugin, calculatedResult, true);
    }

    public static <P extends AbstractFormPlugin, H extends IEntryRowDeletedHandler> RowDeletedContext deleteEntry(P plugin, H handler, String mobileEntryKey, int deletedRowIndex, DataSourceConfig dataSourceConfig) {
        int deletedPcRowIndex = ((IMobilePage)plugin).getIndex(deletedRowIndex);
        plugin.getView().getModel().deleteEntryRow(mobileEntryKey, deletedRowIndex);
        DynamicObject pcEntity = EntityCacheHelper.getPcEntityFromCache(((IMobilePage)plugin).getPcEntityStorageView(), dataSourceConfig.getPcEntityKey());
        DynamicObject visitingDataByContext = DataChangedHandlerHelper.getVisitingDataByContext(pcEntity, ((IMobilePage)plugin).getVisitingContext());
        String pcEntryKey = DataChangedHandlerHelper.getPcEntryNameByMobileEntryName(mobileEntryKey, dataSourceConfig);
        DynamicObjectCollection billEntry = visitingDataByContext.getDynamicObjectCollection(pcEntryKey);
        DynamicObject deletedEntry = (DynamicObject)billEntry.get(deletedPcRowIndex);
        RowDeletedContext rowDeletedContext = new RowDeletedContext(pcEntity, pcEntryKey, deletedEntry, deletedPcRowIndex, ((IMobilePage)plugin).getVisitingContext());
        if (handler != null) {
            handler.onEntryRowDeleted(rowDeletedContext);
        }
        DataChangedHandlerHelper.invokeEntryDeletedExtension(plugin, rowDeletedContext);
        DynamicObject billentryDeleteEntry = billEntry.stream().filter(dynamicObject -> dynamicObject.getPkValue() == deletedEntry.getPkValue()).findAny().orElse(null);
        if (billentryDeleteEntry != null && ((DynamicObject)billEntry.get(deletedPcRowIndex)).getPkValue().equals(deletedEntry.getPkValue())) {
            billEntry.remove(deletedPcRowIndex);
        }
        DataEntityState dataEntityState = pcEntity.getDataEntityState();
        dataEntityState.setRemovedItems(Boolean.TRUE);
        for (int i = 0; i < billEntry.size(); ++i) {
            DynamicObject entryData = (DynamicObject)billEntry.get(i);
            entryData.set("seq", (Object)(i + 1));
        }
        EntityCacheHelper.savePcEntityToPageCache(((IMobilePage)plugin).getPcEntityStorageView(), rowDeletedContext.getCalculatedResult());
        return rowDeletedContext;
    }

    public static String getPcEntryNameByMobileEntryName(String mobileEntryKey, DataSourceConfig dataSourceConfig) {
        List<EntryMappingRelationship> entryMappingRelationships = dataSourceConfig.getEntryMappingRelationships();
        Optional<EntryMappingRelationship> any = entryMappingRelationships.stream().filter(relationship -> relationship.getMobEntryKey().equals(mobileEntryKey)).findAny();
        if (any.isPresent()) {
            return any.get().getPcEntryKey();
        }
        Map<String, PropertyNode> fieldMapping = dataSourceConfig.getFieldMapping();
        for (Map.Entry<String, PropertyNode> mapEntry : fieldMapping.entrySet()) {
            PropertyNode propertyNode = mapEntry.getValue();
            PropertyNode parentNode = propertyNode.getParentNode();
            if (parentNode == null || !(parentNode.getType() instanceof EntryType)) continue;
            return parentNode.getFieldKey();
        }
        return null;
    }

    public static DynamicObject getVisitingDataByContext(DynamicObject pcEntityFromCache, VisitingContext visitingContext) {
        return DataChangedHandlerHelper.getVisitingDataByContext(pcEntityFromCache, visitingContext, 0);
    }

    private static DynamicObject getVisitingDataByContext(DynamicObject pcEntityFromCache, VisitingContext visitingContext, int index) {
        if (visitingContext == null || visitingContext.getEntryMappingIndices().isEmpty()) {
            return pcEntityFromCache;
        }
        List<EntryMappingIndex> entryMappingIndices = visitingContext.getEntryMappingIndices();
        if (index == entryMappingIndices.size()) {
            return pcEntityFromCache;
        }
        EntryMappingIndex entryMappingIndex = entryMappingIndices.get(index);
        DynamicObject dynamicObject = (DynamicObject)pcEntityFromCache.getDynamicObjectCollection(entryMappingIndex.getPcEntryName()).get(entryMappingIndex.getEntryIndex());
        return DataChangedHandlerHelper.getVisitingDataByContext(dynamicObject, visitingContext, index + 1);
    }

    public static <P extends AbstractFormPlugin, H extends IEntryRowAddedHandler> void afterEntryAddedOperation(P plugin, H handler, String mobileEntryKey, AfterDoOperationEventArgs args) {
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)plugin);
        String pcEntityKey = dataSourceConfig.getPcEntityKey();
        String pcEntryKey = DataChangedHandlerHelper.getPcEntryNameByMobileEntryName(mobileEntryKey, dataSourceConfig);
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache(((IMobilePage)plugin).getPcEntityStorageView(), pcEntityKey);
        VisitingContext visitingContext = ((IMobilePage)plugin).getVisitingContext();
        DynamicObject entryHolder = DataChangedHandlerHelper.getVisitingDataByContext(pcEntityFromCache, visitingContext);
        DynamicObjectCollection pcEntryCollection = entryHolder.getDynamicObjectCollection(pcEntryKey);
        DynamicObject newPcEntryRow = pcEntryCollection.addNew();
        int currentEntryRowCount = pcEntryCollection.getRowCount();
        long generatedNewEntryId = DB.genLongId((String)pcEntityKey);
        newPcEntryRow.set("id", (Object)generatedNewEntryId);
        if (newPcEntryRow.containsProperty("seq")) {
            newPcEntryRow.set("seq", (Object)currentEntryRowCount);
        }
        RowAddedContext rowAddedContext = new RowAddedContext(pcEntityFromCache, ((IMobilePage)plugin).getVisitingContext());
        rowAddedContext.setArgs(args);
        rowAddedContext.setPcEntityKey(pcEntityKey);
        rowAddedContext.setPcEntryKey(pcEntryKey);
        rowAddedContext.setMobileEntryKey(mobileEntryKey);
        rowAddedContext.setNewEntryRowData(newPcEntryRow);
        if (handler != null) {
            handler.onEntryRowAdded(rowAddedContext);
        }
        DataChangedHandlerHelper.invokeEntryRowAddedExtension(plugin, rowAddedContext);
        newPcEntryRow.getDataEntityState().setBizChanged(false);
        EntityCacheHelper.savePcEntityToPageCache(((IMobilePage)plugin).getPcEntityStorageView(), pcEntityFromCache);
        DataSourceHelper.loadPcEntityToMobilePage(plugin, pcEntityFromCache, false);
        plugin.getView().getModel().setEntryCurrentRowIndex(mobileEntryKey, pcEntryCollection.size() - 1);
    }

    public static <P extends AbstractMobFormPlugin, H extends IPropertyChangedHandler> void onEntryPagePropertyChanged(P plugin, H handler, PropertyChangedArgs e, int changeEntryRowIndex) {
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        String mobileFieldName = e.getProperty().getName();
        IFormView pcEntityStorageView = ((IMobilePage)plugin).getPcEntityStorageView();
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)plugin);
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache(pcEntityStorageView, dataSourceConfig.getPcEntityKey());
        VisitingContext visitingContext = ((IMobilePage)plugin).getVisitingContext();
        PropertyChangedContext context = new PropertyChangedContext(pcEntityFromCache, visitingContext);
        context.setPropertyChangedArgs(e);
        context.setRowIndex(changeEntryRowIndex);
        context.setNewValue(newValue);
        context.setOldValue(oldValue);
        context.setMobileFieldName(mobileFieldName);
        context.setMain(false);
        Map<String, String> relationship = DataChangedHandlerHelper.getRelationshipOfEntryPage(plugin);
        String pcFieldName = relationship.get(mobileFieldName);
        if (DataChangedHandlerHelper.equals(oldValue, newValue, pcFieldName)) {
            return;
        }
        context.setPcEntryName(visitingContext.getPcEntryName());
        context.setPcFieldName(pcFieldName);
        DynamicObject entryData = DataChangedHandlerHelper.getVisitingDataByContext(pcEntityFromCache, visitingContext);
        boolean isFlexField = mobileFieldName.startsWith("$$");
        if (isFlexField) {
            String flexFieldName = mobileFieldName.split("_")[0].substring(2);
            IFormView view = plugin.getView();
            DynamicObject auxptyValue = DataChangedHandlerHelper.getFlexFieldValue(view, flexFieldName);
            entryData.set(flexFieldName, (Object)auxptyValue);
            context.setPcFieldName(flexFieldName);
        } else {
            entryData.set(pcFieldName, newValue);
        }
        context.setChangePcData(entryData);
        if (handler != null) {
            handler.onPropertyChanged(context);
        }
        DataChangedHandlerHelper.invokePropertyChangedExtension(plugin, context);
        DynamicObject calculatedResult = context.getCalculatedResult();
        EntityCacheHelper.savePcEntityToPageCache(pcEntityStorageView, calculatedResult);
        if (!isFlexField) {
            DataChangedHandlerHelper.setEntryPageFieldsFromCache(plugin, changeEntryRowIndex);
        }
    }

    public static DynamicObject getFlexFieldValue(IFormView view, String flexFieldName) {
        FlexEdit flexEdit = (FlexEdit)view.getControl(flexFieldName);
        IDataModel fModel = flexEdit.getFlexModel();
        MainEntityType flexFieldEntityType = fModel.getDataEntityType();
        DynamicObject flexFieldVal = fModel.getDataEntity();
        FlexEntireData flexEntireData = new FlexEntireData();
        flexEntireData.setFlexData(flexFieldEntityType, flexFieldVal);
        long id = FlexService.saveFlexData((MainEntityType)flexFieldEntityType, (FlexEntireData)flexEntireData);
        flexFieldEntityType.getPrimaryKey().setValue((Object)flexFieldVal, (Object)id);
        DynamicObject flexObject = (DynamicObject)((FlexProp)flexEdit.getProperty()).getComplexType().createInstance();
        flexObject.set("id", (Object)id);
        Map values = flexEntireData.getFlexValue();
        flexObject.set("value", (Object)SerializationUtils.toJsonString((Object)values));
        return flexFieldVal;
    }

    private static <P extends AbstractMobFormPlugin> Map<String, String> getRelationshipOfEntryPage(P plugin) {
        Map<String, String> relationship = ((IEntryPage)plugin).getRelationship();
        String mobileEntityId = ((IMobilePage)plugin).getPcEntityStorageView().getEntityId();
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)plugin);
        String pcFormId = dataSourceConfig.getPcEntityKey();
        PluginProxy pluginProxy = PluginProxy.create(EntryPageFieldsExtension.class, (String)"mpscmm.msmob.tpl.extension.entry.fields");
        List maps = pluginProxy.callReplace(p -> {
            Map<String, String> fieldRelationship = p.getFieldRelationship(mobileEntityId, pcFormId, ((IMobilePage)plugin).getVisitingContext().getPcEntryName());
            return fieldRelationship;
        });
        if (maps != null) {
            maps.forEach(stringStringMap -> {
                if (stringStringMap != null) {
                    relationship.putAll((Map<String, String>)stringStringMap);
                }
            });
        }
        return relationship;
    }

    public static <P extends AbstractMobFormPlugin> DataSourceConfig setEntryPageFieldsFromCache(P plugin, int rowIndex) {
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)plugin);
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache((IMobilePage)plugin);
        Map<String, String> relationship = DataChangedHandlerHelper.getRelationshipOfEntryPage(plugin);
        DynamicObject visitingDataByContext = DataChangedHandlerHelper.getVisitingDataByContext(pcEntityFromCache, ((IMobilePage)plugin).getVisitingContext());
        IDataModel model = plugin.getView().getModel();
        model.beginInit();
        for (Map.Entry<String, String> fieldKey : relationship.entrySet()) {
            String pcFieldName = fieldKey.getValue();
            Object pcValue = DataChangedHandlerHelper.findField(visitingDataByContext, pcFieldName);
            Control control = plugin.getControl(fieldKey.getKey());
            if (pcValue instanceof MulBasedataDynamicObjectCollection && control instanceof AttachmentEdit) {
                int size = ((MulBasedataDynamicObjectCollection)pcValue).size();
                Object[] attachIds = new Object[size];
                for (int i = 0; i < size; ++i) {
                    Object attachId;
                    DynamicObject attachDynObj = (DynamicObject)((MulBasedataDynamicObjectCollection)pcValue).get(i);
                    attachIds[i] = attachId = attachDynObj.getDynamicObject("fbasedataid").getPkValue();
                }
                model.setValue(fieldKey.getKey(), (Object)attachIds);
                continue;
            }
            model.setValue(fieldKey.getKey(), pcValue);
        }
        model.endInit();
        plugin.getView().updateView();
        return dataSourceConfig;
    }

    private static Object findField(DynamicObject data, String pcFieldName) {
        if (data.containsProperty(pcFieldName)) {
            return data.get(pcFieldName);
        }
        DynamicObject parent = (DynamicObject)data.getParent();
        if (parent == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bbe\u7f6e\u5b57\u6bb5\u201c%s\u201d\u7684\u503c\u3002", (String)"Exception_field_not_found_error", (String)"scmc-msmob-form", (Object[])new Object[0]), pcFieldName));
        }
        return DataChangedHandlerHelper.findField(parent, pcFieldName);
    }

    public static <P extends AbstractMobFormPlugin> void setEntryValueManual(P plugin, String pcEntityKey, int changedRowIndex, ManualChangeEntryValueHandler handler) {
        IFormView pcEntityStorageView = ((IMobilePage)plugin).getPcEntityStorageView();
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache(pcEntityStorageView, pcEntityKey);
        VisitingContext visitingContext = ((IMobilePage)plugin).getVisitingContext();
        DynamicObject changedEntry = DataChangedHandlerHelper.getVisitingDataByContext(pcEntityFromCache, visitingContext);
        handler.setEntityValue(pcEntityFromCache, changedEntry);
        EntityCacheHelper.savePcEntityToPageCache(pcEntityStorageView, pcEntityFromCache);
        DataChangedHandlerHelper.setEntryPageFieldsFromCache(plugin, changedRowIndex);
    }

    public static Map<String, String> getRelationshipByFieldArray(IEntryPage iEntryPage, List<String> fieldKeys) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (fieldKeys == null) {
            return map;
        }
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig(iEntryPage);
        Map<String, PropertyNode> fieldMapping = dataSourceConfig.getFieldMapping();
        for (String fieldKey : fieldKeys) {
            PropertyNode propertyNode = fieldMapping.get(fieldKey);
            if (propertyNode == null) continue;
            map.put(fieldKey, propertyNode.getType().getName());
        }
        return map;
    }

    public static <P extends AbstractFormPlugin> void refreshPageOnEntryEditPageClosed(P plugin) {
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache((IMobilePage)plugin);
        DataSourceHelper.loadPcEntityToMobilePage(plugin, pcEntityFromCache, true);
    }
}

