/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.business.helper.change;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.msmob.business.helper.BaseDataFieldBizHelper;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.business.helper.change.EntryMappingIndex;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.business.helper.change.VisitingContext;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.EntryMappingRelationship;
import kd.scmc.msmob.pojo.PropertyNode;
import kd.scmc.msmob.service.mservice.baseset.IDataSourceConfigService;
import kd.scmc.msmob.service.mservice.baseset.impl.DataSourceConfigServiceImpl;
import org.apache.commons.lang3.StringUtils;

public class DataSourceHelper {
    private static final IDataSourceConfigService DATA_SOURCE_CONFIG_SERVICE = new DataSourceConfigServiceImpl();

    public static <T extends AbstractMobBillPlugIn> DataSourceConfig getDataSourceConfig(IMobilePage iMobilePage) {
        return DataSourceHelper.getDataSourceConfig(iMobilePage.getDatasourceConfigMobileKey());
    }

    private static <T extends AbstractMobBillPlugIn> DataSourceConfig getDataSourceConfig(String mobileFormId) {
        return DATA_SOURCE_CONFIG_SERVICE.getDataSourceConfig(mobileFormId);
    }

    private static void constructEntryMapping(AbstractFormPlugin plugin, DataSourceConfig dataSourceConfig) {
        IDataModel model = plugin.getView().getModel();
        Map allMobileEntities = model.getDataEntityType().getAllEntities();
        Set mobileEntryKeys = allMobileEntities.keySet().stream().filter(entityKey -> allMobileEntities.get(entityKey) instanceof EntryType).collect(Collectors.toSet());
        HashMap<String, List<String>> mobEntryKeyToFieldKeys = new HashMap<String, List<String>>();
        ArrayList<EntryMappingRelationship> relationships = new ArrayList<EntryMappingRelationship>();
        Map<String, PropertyNode> fieldMapping = dataSourceConfig.getFieldMapping();
        for (Map.Entry<String, PropertyNode> propertyNodeEntry : fieldMapping.entrySet()) {
            String mobileFiledKey = propertyNodeEntry.getKey();
            PropertyNode propertyNode = propertyNodeEntry.getValue();
            PropertyNode parentNode = propertyNode.getParentNode();
            if (parentNode == null || !(parentNode.getType() instanceof EntryType)) continue;
            mobileEntryKeys.stream().filter(mobileKeyX -> {
                EntryProp property = (EntryProp)model.getProperty(mobileKeyX);
                return property.getDynamicCollectionItemPropertyType().getProperties().get((Object)mobileFiledKey) != null;
            }).findAny().ifPresent(mobileKeyX -> {
                List mobileEntryFields = mobEntryKeyToFieldKeys.getOrDefault(mobileKeyX, new ArrayList());
                mobileEntryFields.add(mobileFiledKey);
                mobEntryKeyToFieldKeys.put((String)mobileKeyX, mobileEntryFields);
                Optional<EntryMappingRelationship> any = relationships.stream().filter(relationship1 -> relationship1.getMobEntryKey().equals(mobileKeyX)).findAny();
                if (any.isPresent()) {
                    return;
                }
                EntryMappingRelationship relationship = new EntryMappingRelationship();
                relationship.setPcEntryKey(parentNode.getFieldKey());
                relationship.setMobEntryKey((String)mobileKeyX);
                relationships.add(relationship);
            });
        }
        dataSourceConfig.setEntryMappingRelationships(relationships);
        dataSourceConfig.setMobEntryKeyToFieldKeys(mobEntryKeyToFieldKeys);
    }

    private static <T extends AbstractFormPlugin> void setMultiEntryModelValue(T plugin, DynamicObject pcBill, DataSourceConfig dataSourceConfig) {
        Map<String, PropertyNode> fieldMapping = dataSourceConfig.getFieldMapping();
        IDataModel model = plugin.getView().getModel();
        Map<String, List<String>> mobEntryKeyToFiledKeys = dataSourceConfig.getMobEntryKeyToFieldKeys();
        List<EntryMappingRelationship> entryMappingRelationships = dataSourceConfig.getEntryMappingRelationships();
        if (mobEntryKeyToFiledKeys == null || mobEntryKeyToFiledKeys.isEmpty() || entryMappingRelationships == null || entryMappingRelationships.isEmpty()) {
            DataSourceHelper.constructEntryMapping(plugin, dataSourceConfig);
            mobEntryKeyToFiledKeys = dataSourceConfig.getMobEntryKeyToFieldKeys();
            entryMappingRelationships = dataSourceConfig.getEntryMappingRelationships();
            if (mobEntryKeyToFiledKeys == null || mobEntryKeyToFiledKeys.isEmpty() || entryMappingRelationships == null || entryMappingRelationships.isEmpty()) {
                return;
            }
        }
        HashMap<String, String> entryKeyMapping = new HashMap<String, String>(16);
        for (EntryMappingRelationship entryMappingRelationship : entryMappingRelationships) {
            String mobEntryKey = entryMappingRelationship.getMobEntryKey();
            String pcEntryKey = entryMappingRelationship.getPcEntryKey();
            entryKeyMapping.put(mobEntryKey, pcEntryKey);
            DynamicObjectCollection pcEntryColl = DataChangedHandlerHelper.getVisitingDataByContext(pcBill, ((IMobilePage)plugin).getVisitingContext()).getDynamicObjectCollection(pcEntryKey);
            if (pcEntryColl != null && pcEntryColl.size() > 0) {
                String mobEntryIdKey = entryMappingRelationship.getMobEntryIdKey();
                List<String> mobEntryFieldKeys = mobEntryKeyToFiledKeys.get(mobEntryKey);
                if (mobEntryFieldKeys == null || mobEntryKeyToFiledKeys.isEmpty()) continue;
                int size = pcEntryColl.size();
                model.deleteEntryData(mobEntryKey);
                model.batchCreateNewEntryRow(mobEntryKey, size);
                DynamicObjectCollection mobileEntry = model.getDataEntity(true).getDynamicObjectCollection(mobEntryKey);
                for (int i = 0; i < size; ++i) {
                    DynamicObject entryRow = (DynamicObject)pcEntryColl.get(i);
                    DynamicObject mobileEntryRow = (DynamicObject)mobileEntry.get(i);
                    for (String mobFieldKey : mobEntryFieldKeys) {
                        PropertyNode propertyNode = fieldMapping.get(mobFieldKey);
                        if (propertyNode == null) continue;
                        String fullPathPcFieldKey = propertyNode.getFieldKey();
                        String pcFieldKey = StringUtils.substringAfter((String)fullPathPcFieldKey, (String)(pcEntryKey + "."));
                        Object pcFieldValue = entryRow.get(pcFieldKey);
                        IMetadata pcFieldType = propertyNode.getType();
                        if (pcFieldType instanceof MulBasedataProp) {
                            Object[] mulBaseDataIdArr = BaseDataFieldBizHelper.getMultiBaseDataIdArr(pcFieldValue);
                            if (mulBaseDataIdArr.length <= 0) continue;
                            model.setValue(mobFieldKey, (Object)mulBaseDataIdArr, i);
                            continue;
                        }
                        mobileEntryRow.set(mobFieldKey, pcFieldValue);
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)mobEntryIdKey)) continue;
                    model.setValue(mobEntryIdKey, entryRow.getPkValue(), i);
                }
                continue;
            }
            model.deleteEntryData(mobEntryKey);
        }
        plugin.getPageCache().put(entryKeyMapping);
    }

    public static <T extends AbstractFormPlugin> void setMainValue(T plugin, Map.Entry<String, PropertyNode> fieldMappingItem, PropertyNode pcField, DynamicObject pcEntity) {
        String mobileFieldKey = fieldMappingItem.getKey();
        PropertyNode parentNode = pcField.getParentNode();
        if (parentNode.getType() instanceof MainEntityType) {
            String fieldKey = fieldMappingItem.getValue().getFieldKey();
            plugin.getView().getModel().setValue(mobileFieldKey, DataChangedHandlerHelper.getValue(fieldKey, pcEntity.get(fieldKey)));
            return;
        }
        if (parentNode.getType() instanceof EntryType) {
            VisitingContext visitingContext = ((IMobilePage)plugin).getVisitingContext();
            Optional<EntryMappingIndex> any = visitingContext.getEntryMappingIndices().stream().filter(entryMappingIndex -> entryMappingIndex.getPcEntryName().equals(parentNode.getFieldKey())).findAny();
            if (!any.isPresent()) {
                return;
            }
            String fieldKey = fieldMappingItem.getValue().getType().getName();
            DynamicObject visitingDataByContext = DataChangedHandlerHelper.getVisitingDataByContext(pcEntity, visitingContext);
            plugin.getView().getModel().setValue(mobileFieldKey, DataChangedHandlerHelper.getValue(fieldKey, visitingDataByContext.get(fieldKey)));
            return;
        }
        DataSourceHelper.setMainValue(plugin, fieldMappingItem, pcField.getParentNode(), pcEntity);
    }

    public static <T extends AbstractFormPlugin> void loadPcEntityToMobilePage(T plugin, DynamicObject pcEntity, boolean updateView) {
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)plugin);
        Map<String, PropertyNode> fieldMapping = dataSourceConfig.getFieldMapping();
        model.beginInit();
        for (Map.Entry<String, PropertyNode> fieldMappingItem : fieldMapping.entrySet()) {
            PropertyNode pcField = fieldMappingItem.getValue();
            DataSourceHelper.setMainValue(plugin, fieldMappingItem, pcField, pcEntity);
        }
        model.endInit();
        model.beginInit();
        DataSourceHelper.setMultiEntryModelValue(plugin, pcEntity, dataSourceConfig);
        model.endInit();
        ((IMobilePage)plugin).loadCacheDataBeforeUpdateView(pcEntity);
        view.updateView();
    }

    public static String getEntryProperty(DataSourceConfig dataSourceConfig) {
        HashSet<String> names = new HashSet<String>();
        Map<String, PropertyNode> mobEntryKeyToFieldKeys = dataSourceConfig.getFieldMapping();
        Set<Map.Entry<String, PropertyNode>> entries = mobEntryKeyToFieldKeys.entrySet();
        for (Map.Entry<String, PropertyNode> entry : entries) {
            PropertyNode propertyNode = entry.getValue();
            DataSourceHelper.addPcEntryName(names, propertyNode);
        }
        if (names.size() == 1) {
            return (String)names.stream().findFirst().get();
        }
        return null;
    }

    private static void addPcEntryName(Set<String> names, PropertyNode propertyNode) {
        if (propertyNode.getType() instanceof EntryType) {
            names.add(propertyNode.getFieldKey());
            return;
        }
        PropertyNode parentNode = propertyNode.getParentNode();
        if (parentNode != null) {
            DataSourceHelper.addPcEntryName(names, parentNode);
        }
    }
}

