/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.business.helper.scan.impl;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.msmob.business.helper.OperationHandleHelper;
import kd.scmc.msmob.business.helper.scan.ICodeParse;
import kd.scmc.msmob.common.enums.BillStatusEnum;
import kd.scmc.msmob.common.enums.EnableStatusEnum;
import kd.scmc.msmob.plugin.op.skill.ISkillFamily;
import kd.scmc.msmob.pojo.QrCodeResult;

public class CodeParseImpl
implements ICodeParse {
    private static final String[] KEYS = new String[]{"entityId", "no", "type"};

    @Override
    public void codeParse(Long orgId, String code, QrCodeResult result) {
        if (StringUtils.isBlank((CharSequence)code)) {
            String errMsg = ResManager.loadKDString((String)"\u626b\u63cf\u503c\u4e3a\u7a7a\u3002", (String)"code_empty", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        Map<String, String> map = CodeParseImpl.checkCodeFormat(code);
        CodeParseImpl.convertResultByCode(orgId, code, result, map);
    }

    private static void convertResultByCode(Long orgId, String code, QrCodeResult result, Map<String, String> map) {
        String type = map.get("type");
        QFilter filter = new QFilter("number", "=", (Object)type);
        filter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        filter.and("status", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObject skillFamily = QueryServiceHelper.queryOne((String)"msmob_skill_family", (String)"number,parsing_result_plugin", (QFilter[])filter.toArray());
        if (skillFamily == null) {
            String errMsg = ResManager.loadKDString((String)"\u672a\u5b9a\u4e49\u7801\u7c7b\u578b\uff0c\u8bf7\u524d\u5f80\u914d\u7f6e\u3002", (String)"no_exist_skill", (String)"scmc-msmob-form", (Object[])new Object[0]);
            String format = String.format(errMsg, type);
            throw new KDBizException(format);
        }
        String parsingPlugin = skillFamily.getString("parsing_result_plugin");
        if (StringUtils.isBlank((CharSequence)parsingPlugin)) {
            String errMsg = ResManager.loadKDString((String)"\u6280\u80fd\u65cf\u7f16\u7801\u4e3a%s\u7684\u89e3\u6790\u7ed3\u679c\u63d2\u4ef6\u4e3a\u7a7a\u3002", (String)"no_exist_plugin", (String)"scmc-msmob-form", (Object[])new Object[0]);
            String format = String.format(errMsg, type);
            throw new KDBizException(format);
        }
        ISkillFamily skillFamilyImpl = OperationHandleHelper.getOperationInstance(parsingPlugin, ISkillFamily.class);
        skillFamilyImpl.parse(orgId, code, result, map);
    }

    public static Map<String, String> checkCodeFormat(String code) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            String[] split = code.split("\\|");
            String errMsg = ResManager.loadKDString((String)"\u7801\u683c\u5f0f\u6709\u8bef\uff0c\u65e0\u6cd5\u89e3\u6790\u3002", (String)"code_format_error", (String)"scmc-msmob-form", (Object[])new Object[0]);
            for (String str : split) {
                int keyValueSize;
                String[] keyValue = str.split(":");
                if (keyValue.length != (keyValueSize = 2)) {
                    throw new KDBizException(errMsg);
                }
                String key = keyValue[0];
                String value = keyValue[1];
                if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)value)) {
                    throw new KDBizException(errMsg);
                }
                map.put(key.trim(), value.trim());
            }
            for (String key : KEYS) {
                boolean isContain = map.containsKey(key);
                if (isContain) {
                    String value = (String)map.get(key);
                    if (!StringUtils.isBlank((CharSequence)value)) continue;
                    throw new KDBizException(errMsg);
                }
                throw new KDBizException(errMsg);
            }
        }
        return map;
    }
}

