/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.common.design.homepage.region;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.scmc.msmob.business.helper.CustomHomePageHelper;
import kd.scmc.msmob.common.design.homepage.region.CheckPermissionRegion;
import kd.scmc.msmob.pojo.Card;
import kd.scmc.msmob.pojo.CardData;
import kd.scmc.msmob.pojo.CardEntry;
import kd.sdk.mpscmm.msmob.expoint.IMobHomePageCustomDataPlugin;
import org.apache.commons.collections.CollectionUtils;

public abstract class CheckPermissionMultipleRegion
extends CheckPermissionRegion {
    static final String SIZE = "3";

    public CheckPermissionMultipleRegion(String id, String parentId, String homePageId, IFormView view) {
        super(id, parentId, homePageId, view);
    }

    @Override
    public void buildCardData(CardData setting, IFormView view, Boolean isPresent) {
        ContainerAp regionContainerAp = (ContainerAp)CustomHomePageHelper.getChildControlAp(Objects.requireNonNull(CustomHomePageHelper.getFormMetaData(this.getHomePageId())).getRootAp(), this.getRegionId());
        if (regionContainerAp == null) {
            return;
        }
        List<ControlAp<?>> allItems = this.getAllSortRegionItems(regionContainerAp);
        List<String> allSortRegionKeys = this.getAllSortRegionKeys(this.checkPermission(), allItems, view);
        List<CardEntry> selectedCardEntries = this.getSelectedRegionCardEntries(setting, this.getRegionId(), allSortRegionKeys);
        allItems.removeIf(a -> selectedCardEntries.stream().map(CardEntry::getId).collect(Collectors.toList()).contains(a.getKey()));
        List<CardEntry> notSelectedCardEntries = allItems.stream().map(item -> new CardEntry(item.getKey(), null)).collect(Collectors.toList());
        if (!isPresent.booleanValue()) {
            setting.getSelectedCards().add(new Card(this.getRegionId(), null, null, null));
        }
        this.buildCard(setting.getSelectedCards(), selectedCardEntries, notSelectedCardEntries);
        this.buildCard(setting.getNotSelectedCards(), selectedCardEntries, notSelectedCardEntries);
    }

    @Override
    public void buildControl(ContainerAp<?> homePageContainer, CardData setting, IFormView view) {
        ContainerAp childControlAp = (ContainerAp)CustomHomePageHelper.getChildControlAp(homePageContainer, this.getRegionId());
        if (childControlAp != null) {
            List allItem = childControlAp.getItems();
            List<String> allSortRegionKeys = this.getAllSortRegionKeys(this.checkPermission(), allItem, this.getView());
            List<CardEntry> cardItems = this.getSelectedRegionCardEntries(setting, this.getRegionId(), allSortRegionKeys);
            this.sortControl(cardItems, allItem);
        }
    }

    protected void buildCard(List<Card> setting, List<CardEntry> selectedCardEntries, List<CardEntry> notSelectedCardEntries) {
        setting.stream().filter(card -> card.getId().equals(this.getRegionId())).findFirst().ifPresent(item -> {
            item.setSelectedCardEntries(selectedCardEntries);
            item.setNotSelectedCardEntries(notSelectedCardEntries);
        });
    }

    protected List<CardEntry> getSelectedRegionCardEntries(CardData cardData, String regionKey, List<String> allRegionKeys) {
        Card card;
        Card card2 = card = cardData != null ? (Card)cardData.getSelectedCards().stream().filter(a -> regionKey.equals(a.getId())).findAny().orElse(null) : null;
        if (card != null && card.getSelectedCardEntries() != null) {
            List<CardEntry> cardItems = card.getSelectedCardEntries();
            cardItems.removeIf(item -> !allRegionKeys.contains(item.getId()));
            return cardItems;
        }
        return this.buildRegionCardEntries(allRegionKeys);
    }

    private List<CardEntry> buildRegionCardEntries(List<String> allRegionKeys) {
        return allRegionKeys.stream().map(key -> new CardEntry((String)key, null)).collect(Collectors.toList());
    }

    public List<String> getAllSortRegionKeys(Map<String, Boolean> checkResult, List<ControlAp<?>> allSortRegionItems, IFormView view) {
        List<String> allSortRegionKeys = allSortRegionItems.stream().map(AbstractElement::getKey).collect(Collectors.toList());
        List withoutPermKeys = checkResult.entrySet().stream().filter(entry -> ((Boolean)entry.getValue()).equals(Boolean.FALSE)).map(Map.Entry::getKey).collect(Collectors.toList());
        allSortRegionKeys.removeIf(withoutPermKeys::contains);
        Set extKeys = allSortRegionItems.stream().filter(AbstractElement::isExt).map(AbstractElement::getKey).collect(Collectors.toSet());
        PluginProxy pluginProxy = PluginProxy.create(IMobHomePageCustomDataPlugin.class, (String)"SCMC_MSMOB_CUSTOM_DELETE_REGION");
        List sets = pluginProxy.callReplace(plugin -> {
            String appId = this.getView().getModel().getDataEntityType().getAppId();
            if (plugin.getAppId().equals(appId)) {
                return plugin.deleteWithoutPermissionCard(view, extKeys);
            }
            return null;
        });
        if (CollectionUtils.isNotEmpty((Collection)sets)) {
            sets.forEach(allSortRegionKeys::removeAll);
        }
        return allSortRegionKeys;
    }

    protected List<ControlAp<?>> getAllSortRegionItems(ContainerAp<?> containerAp) {
        List allItems = containerAp.getItems();
        List originalItems = allItems.stream().filter(item -> !item.isExt()).collect(Collectors.toList());
        List extItems = allItems.stream().filter(AbstractElement::isExt).collect(Collectors.toList());
        Map<String, Boolean> checkRegionResult = this.checkPermission();
        List withPermissionKeys = checkRegionResult.entrySet().stream().filter(entry -> Boolean.TRUE.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        List<ControlAp<?>> originalWithPermissionItems = originalItems.stream().filter(item -> withPermissionKeys.contains(item.getKey())).collect(Collectors.toList());
        originalWithPermissionItems.addAll(extItems);
        return originalWithPermissionItems;
    }
}

