/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.common.design.homepage.region;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.bos.metadata.form.ContainerAp;
import kd.scmc.msmob.common.design.homepage.region.CheckPermissionRegion;
import kd.scmc.msmob.pojo.Card;
import kd.scmc.msmob.pojo.CardData;
import kd.scmc.msmob.pojo.CardEntry;

public abstract class CheckPermissionSingleRegion
extends CheckPermissionRegion {
    public CheckPermissionSingleRegion(String id, String parentId, String homePageId, IFormView view) {
        super(id, parentId, homePageId, view);
    }

    @Override
    public Map<String, Boolean> checkPermission() {
        Boolean isPermission = this.singleCheckPermission();
        HashMap<String, Boolean> checkResult = new HashMap<String, Boolean>(4);
        checkResult.put(this.getRegionId(), isPermission);
        return checkResult;
    }

    public abstract Boolean singleCheckPermission();

    @Override
    public void buildCardData(CardData setting, IFormView view, Boolean isPresent) {
        if (!isPresent.booleanValue()) {
            setting.getSelectedCards().add(new Card(this.getRegionId(), null, new ArrayList<CardEntry>(0), new ArrayList<CardEntry>(0)));
        }
        if (this.isInvisible()) {
            setting.getSelectedCards().removeIf(card -> this.getRegionId().equals(card.getId()));
            setting.getNotSelectedCards().removeIf(card -> this.getRegionId().equals(card.getId()));
        }
    }

    @Override
    public void buildControl(ContainerAp<?> homePageContainer, CardData setting, IFormView view) {
        Boolean isPermission = this.singleCheckPermission();
        if (!this.isPresent(setting) || !isPermission.booleanValue()) {
            homePageContainer.getItems().removeIf(item -> this.getRegionId().equals(item.getKey()));
        }
    }

    public boolean isPresent(CardData setting) {
        boolean isInvisible = this.isInvisible();
        boolean isPresentInCardData = this.isPresentInCardData(setting);
        return !isInvisible && isPresentInCardData;
    }

    private boolean isInvisible() {
        return this.getView().getControl(this.getRegionId()).isInvisible();
    }

    private boolean isPresentInCardData(CardData setting) {
        return setting == null || setting.getSelectedCards().stream().anyMatch(card -> card.getId().equals(this.getRegionId()));
    }
}

