/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.common.design.homepage.region;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.util.StringUtils;
import kd.scmc.msmob.business.helper.CustomHomePageHelper;
import kd.scmc.msmob.common.design.homepage.handle.HomePageBuilder;
import kd.scmc.msmob.common.design.homepage.region.RegionRelationShip;
import kd.scmc.msmob.pojo.Card;
import kd.scmc.msmob.pojo.CardData;

public class HomePageParentRegion
extends RegionRelationShip {
    private HomePageBuilder handleHomePage;
    public String morePageId;

    public String getMorePageId() {
        return this.morePageId;
    }

    public void setMorePageId(String morePageId) {
        this.morePageId = morePageId;
    }

    public HomePageParentRegion(String id, String homePageId, String morePageId, HomePageBuilder handleHomePage, IFormView view) {
        super(id, null, homePageId, view);
        this.morePageId = morePageId;
        this.handleHomePage = handleHomePage;
    }

    @Override
    public void buildControl(ContainerAp<?> homePageContainer, CardData setting, IFormView view) {
        List<Card> selectedCards = setting != null ? setting.getSelectedCards() : null;
        List controlAps = homePageContainer.getItems();
        Container parentContainer = (Container)view.getControl(this.getRegionId());
        String[] keys = (String[])parentContainer.getItems().stream().map(Control::getKey).filter(key -> !key.equals("toporgflex")).toArray(String[]::new);
        parentContainer.deleteControls(keys);
        parentContainer.getItems().removeIf(item -> Arrays.asList(keys).contains(item.getKey()));
        controlAps.removeIf(controlAp -> controlAp.isHidden() || controlAp.isInvisible() || "toporgflex".equals(controlAp.getKey()));
        if (selectedCards != null) {
            controlAps.removeIf(controlAp -> selectedCards.stream().noneMatch(card -> card.getId().equals(this.getChildControlKey(this.handleHomePage.getAllRegions(), controlAp.getKey()))));
            List selectedKeys = selectedCards.stream().map(Card::getId).collect(Collectors.toList());
            controlAps.sort((previous, last) -> {
                String previousKeys = this.getChildControlKey(this.handleHomePage.getAllRegions(), previous.getKey());
                String lastKeys = this.getChildControlKey(this.handleHomePage.getAllRegions(), last.getKey());
                return selectedKeys.indexOf(previousKeys) - selectedKeys.indexOf(lastKeys);
            });
        }
        List collect = controlAps.stream().map(ControlAp::createControl).collect(Collectors.toList());
        parentContainer.addControls(collect);
    }

    @Override
    public void buildCardData(CardData setting, IFormView view, Boolean isPresent) {
        this.buildCardDataTitle(setting);
    }

    private void buildCardDataTitle(CardData cardData) {
        FormMetadata moreMeta = CustomHomePageHelper.getFormMetaData(this.getMorePageId());
        FormMetadata mainMeta = CustomHomePageHelper.getFormMetaData(this.getHomePageId());
        cardData.getSelectedCards().forEach(card -> this.buildCardTitle((Card)card, moreMeta, mainMeta));
        cardData.getNotSelectedCards().forEach(card -> this.buildCardTitle((Card)card, moreMeta, mainMeta));
    }

    private void buildCardTitle(Card card, FormMetadata moreMeta, FormMetadata mainMeta) {
        String parentId = this.handleHomePage.getAllRegions().stream().filter(cardInfo -> card.getId().equals(cardInfo.getRegionId())).map(RegionRelationShip::getHomePageRegionId).findFirst().orElse(null);
        card.setTitle(this.getControlNameByKey(parentId, moreMeta, mainMeta));
        card.getSelectedCardEntries().forEach(cardEntry -> cardEntry.setTitle(this.getControlNameByKey(cardEntry.getId(), moreMeta, mainMeta)));
        card.getNotSelectedCardEntries().forEach(cardEntry -> cardEntry.setTitle(this.getControlNameByKey(cardEntry.getId(), moreMeta, mainMeta)));
    }

    private String getControlNameByKey(String id, FormMetadata moreMeta, FormMetadata mainMeta) {
        return StringUtils.isBlank((String)CustomHomePageHelper.getControlName(id, mainMeta)) ? CustomHomePageHelper.getControlName(id, moreMeta) : CustomHomePageHelper.getControlName(id, mainMeta);
    }

    private String getChildControlKey(List<RegionRelationShip> homePageRelationships, String parentKey) {
        return homePageRelationships.stream().filter(cardInfo -> parentKey.equals(cardInfo.getHomePageRegionId())).map(RegionRelationShip::getRegionId).findFirst().orElse(null);
    }

    public void setHandleHomePage(HomePageBuilder handleHomePage) {
        this.handleHomePage = handleHomePage;
    }
}

