/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.common.design.homepage.region;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.mcontrol.MBlockMenuItemAp;
import kd.scmc.msmob.business.helper.CustomHomePageHelper;
import kd.scmc.msmob.common.design.homepage.region.CheckPermissionRegion;
import kd.scmc.msmob.pojo.Card;
import kd.scmc.msmob.pojo.CardData;
import kd.scmc.msmob.pojo.CardEntry;
import kd.sdk.mpscmm.msmob.expoint.IMobHomePageCustomDataPlugin;

public abstract class MenuRegion
extends CheckPermissionRegion {
    private final String morePageId;

    public String getMorePageId() {
        return this.morePageId;
    }

    public MenuRegion(String id, String parentId, String homePageId, String morePageId, IFormView view) {
        super(id, parentId, homePageId, view);
        this.morePageId = morePageId;
    }

    @Override
    public void buildControl(ContainerAp<?> homePageContainer, CardData setting, IFormView view) {
        ContainerAp menuAp = (ContainerAp)CustomHomePageHelper.getChildControlAp(homePageContainer, this.getRegionId());
        if (menuAp != null) {
            Map<String, Boolean> checkResult = this.checkPermission();
            List<CardEntry> sortMenuCardEntries = this.getSortMenuCardEntries(checkResult, setting);
            List<MBlockMenuItemAp> allMenuItems = CustomHomePageHelper.getAllMenuItems(this.getRegionId(), this.getHomePageId(), this.getMorePageId());
            this.sortControl(sortMenuCardEntries, allMenuItems);
            menuAp.getItems().clear();
            menuAp.getItems().addAll(allMenuItems);
        }
    }

    @Override
    public void buildCardData(CardData setting, IFormView view, Boolean isPresent) {
        Map<String, Boolean> checkResult = this.checkPermission();
        List<CardEntry> selectedItems = this.getSortMenuCardEntries(checkResult, setting);
        List<CardEntry> allItems = this.getAllSortMenuItemCardEntries(checkResult);
        List selectedKeys = selectedItems.stream().map(CardEntry::getId).collect(Collectors.toList());
        allItems.removeIf(a -> selectedKeys.contains(a.getId()));
        if (!isPresent.booleanValue()) {
            setting.getSelectedCards().add(new Card(this.getRegionId(), null, selectedItems, allItems));
            return;
        }
        this.buildMenuData(setting.getSelectedCards(), selectedItems, allItems);
        this.buildMenuData(setting.getNotSelectedCards(), selectedItems, allItems);
    }

    private void buildMenuData(List<Card> setting, List<CardEntry> selectedCardEntries, List<CardEntry> notSelectedItems) {
        setting.stream().filter(card -> card.getId().equals(this.getRegionId())).findFirst().ifPresent(item -> {
            item.setSelectedCardEntries(selectedCardEntries);
            item.setNotSelectedCardEntries(notSelectedItems);
        });
    }

    private List<CardEntry> getAllSortMenuItemCardEntries(Map<String, Boolean> checkResult) {
        Set<String> allItems = this.getAllSortMenuKeys(checkResult);
        List<MBlockMenuItemAp> allMenuItems = CustomHomePageHelper.getAllMenuItems(this.getRegionId(), this.getHomePageId(), this.getMorePageId());
        return allMenuItems.stream().filter(a -> allItems.contains(a.getKey())).map(b -> new CardEntry(b.getKey(), b.getName().getLocaleValue())).collect(Collectors.toList());
    }

    private Set<String> getAllSortMenuKeys(Map<String, Boolean> checkResult) {
        Set<String> keysWithPermission = CustomHomePageHelper.getOriginalMenuItemsWithPermission(checkResult, this.getRegionId(), this.getHomePageId(), this.getMorePageId());
        Set<String> extKeys = CustomHomePageHelper.getExtMenuItems(this.getRegionId(), this.getHomePageId(), this.getMorePageId());
        PluginProxy pluginProxy = PluginProxy.create(IMobHomePageCustomDataPlugin.class, (String)"SCMC_MSMOB_CUSTOM_DELETE_REGION");
        List sets = pluginProxy.callReplace(plugin -> {
            String appId = this.getView().getModel().getDataEntityType().getAppId();
            if (plugin.getAppId().equals(appId)) {
                return plugin.deleteWithoutPermissionMenu(this.getView(), extKeys);
            }
            return null;
        });
        if (extKeys != null && sets != null) {
            sets.forEach(extKeys::removeAll);
            keysWithPermission.addAll(extKeys);
        }
        return keysWithPermission;
    }

    public List<CardEntry> getSortMenuCardEntries(Map<String, Boolean> checkResult, CardData setting) {
        Card card;
        Card card2 = card = setting != null ? (Card)setting.getSelectedCards().stream().filter(item -> this.getRegionId().equals(item.getId())).findAny().orElse(null) : null;
        if (card != null && card.getSelectedCardEntries() != null) {
            Set<String> allSortMenuKeys = this.getAllSortMenuKeys(checkResult);
            List<CardEntry> cardItems = card.getSelectedCardEntries();
            return cardItems.stream().filter(a -> allSortMenuKeys.contains(a.getId())).collect(Collectors.toList());
        }
        return this.buildSortMenuCardEntries(checkResult);
    }

    private List<CardEntry> buildSortMenuCardEntries(Map<String, Boolean> checkMenuResult) {
        List<MBlockMenuItemAp> homePageMenuItemsAp = CustomHomePageHelper.getHomePageMenuItemsAp(this.getRegionId(), this.getHomePageId());
        if (homePageMenuItemsAp == null) {
            return new ArrayList<CardEntry>();
        }
        Set<String> allSortMenuKeys = this.getAllSortMenuKeys(checkMenuResult);
        homePageMenuItemsAp.removeIf(item -> !allSortMenuKeys.contains(item.getKey()));
        return homePageMenuItemsAp.stream().map(menuItemAp -> new CardEntry(menuItemAp.getKey(), menuItemAp.getName().getLocaleValue())).collect(Collectors.toList());
    }
}

