/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.common.design.strategy.colsselect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.tree.TreeNode;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.msmob.common.design.strategy.colsselect.IColsSelectStrategy;
import kd.scmc.msmob.pojo.PropertyNode;
import org.apache.commons.lang3.StringUtils;

public class PcColumnSelectStrategy
implements IColsSelectStrategy {
    @Override
    public PropertyNode buildBaseDataNode(PropertyNode entryNode, PropertyNode subEntryNode, IDataEntityProperty baseProp, boolean needBaseDataSubAttr) {
        PropertyNode baseDataNode;
        if (!this.filterBaseDataPro(baseProp)) {
            return null;
        }
        if (needBaseDataSubAttr) {
            baseDataNode = this.buildLowerTreeNode(entryNode, subEntryNode, baseProp, this.getPorpertyMaxLevel());
        } else {
            IDataEntityType parentProp = baseProp.getParent();
            if (parentProp != null) {
                this.buildPrimaryKeyNode(subEntryNode, parentProp.getPrimaryKey());
            }
            baseDataNode = new PropertyNode();
            TreeNode treeNode = this.getTreeNode(subEntryNode.getTreeNode().getId(), baseProp.getName(), baseProp.getDisplayName().getLocaleValue());
            this.setTxtFieldLenAndEntryKey(treeNode, baseProp);
            String treeNodeType = this.getTreeNodeProType(baseProp);
            treeNode.setType(treeNodeType);
            baseDataNode.setTreeNode(treeNode);
            baseDataNode.setFieldKey(treeNode.getId());
        }
        baseDataNode.setType((IMetadata)baseProp);
        baseDataNode.setParentNode(subEntryNode);
        if (baseProp instanceof FlexProp) {
            return baseDataNode;
        }
        this.fillBaseDataTree(baseDataNode, ((IBasedataField)baseProp).getBaseEntityId(), (IBasedataField)baseProp);
        return baseDataNode;
    }

    @Override
    public PropertyNode buildBaseDataNode(PropertyNode parentNode, IDataEntityProperty baseProp, boolean needBaseDataSubAttr) {
        PropertyNode baseDataNode;
        if (!this.filterBaseDataPro(baseProp)) {
            return null;
        }
        if (needBaseDataSubAttr) {
            baseDataNode = this.buildLowerTreeNode(parentNode, baseProp, this.getPorpertyMaxLevel());
        } else {
            IDataEntityType parentProp = baseProp.getParent();
            if (parentProp != null) {
                this.buildPrimaryKeyNode(parentNode, parentProp.getPrimaryKey());
            }
            baseDataNode = new PropertyNode();
            TreeNode treeNode = this.getTreeNode(parentNode.getTreeNode().getId(), baseProp.getName(), baseProp.getDisplayName().getLocaleValue());
            this.setTxtFieldLenAndEntryKey(treeNode, baseProp);
            String treeNodeType = this.getTreeNodeProType(baseProp);
            treeNode.setType(treeNodeType);
            baseDataNode.setTreeNode(treeNode);
            baseDataNode.setFieldKey(treeNode.getId());
        }
        baseDataNode.setType((IMetadata)baseProp);
        baseDataNode.setParentNode(parentNode);
        if (baseProp instanceof FlexProp) {
            return baseDataNode;
        }
        this.fillBaseDataTree(baseDataNode, ((IBasedataField)baseProp).getBaseEntityId(), (IBasedataField)baseProp);
        return baseDataNode;
    }

    private void fillBaseDataTree(PropertyNode baseDataNode, String baseDataNo, IBasedataField basedataProp) {
        if (StringUtils.isBlank((CharSequence)baseDataNo)) {
            return;
        }
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)baseDataNo);
        Map fields = type.getAllFields();
        Set<String> cols = this.getNeedColsOfBaseData(baseDataNo);
        Set<String> addCols = this.getRefPropsByBaseField(basedataProp);
        if (cols == null) {
            cols = addCols;
        } else if (addCols != null) {
            cols.addAll(addCols);
        }
        if (cols == null) {
            for (IDataEntityProperty pro : fields.values()) {
                if (!this.fixedFilter(pro)) continue;
                PropertyNode lowerPropNode = this.buildLowerTreeNode(baseDataNode, pro, this.getPorpertyMaxLevel());
                lowerPropNode.setParentNode(baseDataNode);
                TreeNode baseDataTreeNode = baseDataNode.getTreeNode();
                this.addPropChildNode(baseDataNode, lowerPropNode);
                TreeNode lowerTreeNode = lowerPropNode.getTreeNode();
                this.addChildNode(baseDataTreeNode, lowerTreeNode);
            }
        } else {
            for (String col : cols) {
                IDataEntityProperty pro = (IDataEntityProperty)fields.get(col);
                if (pro == null || !this.fixedFilter(pro)) continue;
                PropertyNode lowerPropNode = this.buildLowerTreeNode(baseDataNode, pro, this.getPorpertyMaxLevel());
                lowerPropNode.setParentNode(baseDataNode);
                TreeNode baseDataTreeNode = baseDataNode.getTreeNode();
                this.addPropChildNode(baseDataNode, lowerPropNode);
                TreeNode lowerTreeNode = lowerPropNode.getTreeNode();
                this.addChildNode(baseDataTreeNode, lowerTreeNode);
            }
        }
    }

    private void addChildNode(TreeNode treeNode, TreeNode childNode) {
        List children = treeNode.getChildren();
        if (children == null) {
            treeNode.addChild(childNode);
            return;
        }
        ArrayList<String> childrenIds = new ArrayList<String>(10);
        for (TreeNode tNode : children) {
            childrenIds.add(tNode.getId());
        }
        if (!childrenIds.contains(childNode.getId())) {
            treeNode.addChild(childNode);
        }
    }

    private void addPropChildNode(PropertyNode propNode, PropertyNode propChildNode) {
        List<PropertyNode> propChildren = propNode.getChildren();
        if (propChildren == null) {
            propNode.addChild(propChildNode);
            return;
        }
        ArrayList<String> propChildrenIds = new ArrayList<String>(10);
        for (PropertyNode childNode : propChildren) {
            propChildrenIds.add(childNode.getFieldKey());
        }
        if (!propChildrenIds.contains(propChildNode.getFieldKey())) {
            propNode.addChild(propChildNode);
        }
    }

    private Set<String> getRefPropsByBaseField(IBasedataField prop) {
        RefEntityType refEntityType = (RefEntityType)prop.getComplexType();
        HashSet<String> cols = new HashSet<String>(16);
        if (refEntityType == null || refEntityType.getAllFields().isEmpty()) {
            cols.add("name");
            cols.add("number");
        } else {
            cols = refEntityType.getAllFields().keySet();
        }
        return cols;
    }

    private PropertyNode buildLowerTreeNode(PropertyNode parentBaseNode, IDataEntityProperty pro, int maxLevel) {
        IDataEntityType parentProp = pro.getParent();
        if (parentProp != null) {
            this.buildPrimaryKeyNode(parentBaseNode, parentProp.getPrimaryKey());
        }
        PropertyNode propNode = new PropertyNode();
        TreeNode parentBaseTreeNode = parentBaseNode.getTreeNode();
        String parentId = parentBaseTreeNode.getId();
        String parentText = parentBaseTreeNode.getText();
        TreeNode treeNode = this.getTreeNode(parentId, parentId + "." + pro.getName(), parentText + "." + pro.getDisplayName());
        this.setTxtFieldLenAndEntryKey(treeNode, pro);
        String treeNodeType = this.getTreeNodeProType(pro);
        treeNode.setType(treeNodeType);
        propNode.setType((IMetadata)pro);
        propNode.setTreeNode(treeNode);
        propNode.setParentNode(parentBaseNode);
        propNode.setFieldKey(treeNode.getId());
        if (this.filterBaseDataPro(pro) && maxLevel >= 0) {
            IDataEntityType refEntityType = ((IBasedataField)pro).getComplexType();
            Map allFields = ((RefEntityType)refEntityType).getAllFields();
            Collection entityProps = allFields.values();
            for (IDataEntityProperty prop : entityProps) {
                int curMaxLevel = maxLevel - 1;
                PropertyNode lowerNode = this.buildLowerTreeNode(propNode, prop, curMaxLevel);
                lowerNode.setParentNode(propNode);
                TreeNode lowerTreeNode = lowerNode.getTreeNode();
                this.setTxtFieldLenAndEntryKey(lowerTreeNode, prop);
                String lowerTreeNodeType = this.getTreeNodeProType(prop);
                lowerTreeNode.setType(lowerTreeNodeType);
                lowerNode.setFieldKey(lowerTreeNode.getId());
                lowerNode.setType((IMetadata)prop);
                this.addChildNode(treeNode, lowerTreeNode);
                this.addPropChildNode(propNode, lowerNode);
            }
        }
        return propNode;
    }

    private PropertyNode buildLowerTreeNode(PropertyNode grandParentBaseNode, PropertyNode parentBaseNode, IDataEntityProperty pro, int maxLevel) {
        IDataEntityType parentProp = pro.getParent();
        if (parentProp != null) {
            this.buildPrimaryKeyNode(parentBaseNode, parentProp.getPrimaryKey());
        }
        PropertyNode propNode = new PropertyNode();
        IMetadata grandParentBaseType = grandParentBaseNode.getType();
        TreeNode grandParentTreeBaseNode = grandParentBaseNode.getTreeNode();
        TreeNode parentBaseTreeNode = parentBaseNode.getTreeNode();
        String grandParentId = grandParentTreeBaseNode.getId();
        String grandParentText = grandParentTreeBaseNode.getText();
        String parentId = parentBaseTreeNode.getId();
        String grandParent = parentId.contains(".") ? parentId.substring(0, parentId.lastIndexOf(46)) : "";
        String parentText = parentBaseTreeNode.getText();
        String grandParentIdDot = grandParentBaseType instanceof SubEntryType || grandParent.equals(grandParentId) ? "" : grandParentId + ".";
        String grandParentTextDot = StringUtils.isEmpty((CharSequence)grandParentIdDot) ? "" : grandParentText + ".";
        TreeNode treeNode = this.getTreeNode(parentId, grandParentIdDot + parentId + "." + pro.getName(), grandParentTextDot + parentText + "." + pro.getDisplayName());
        this.setTxtFieldLenAndEntryKey(treeNode, pro);
        String treeNodeType = this.getTreeNodeProType(pro);
        treeNode.setType(treeNodeType);
        propNode.setType((IMetadata)pro);
        propNode.setTreeNode(treeNode);
        propNode.setParentNode(parentBaseNode);
        propNode.setFieldKey(treeNode.getId());
        if (this.filterBaseDataPro(pro) && maxLevel >= 0) {
            IDataEntityType refEntityType = ((IBasedataField)pro).getComplexType();
            Map allFields = ((RefEntityType)refEntityType).getAllFields();
            Collection entityProps = allFields.values();
            for (IDataEntityProperty prop : entityProps) {
                PropertyNode lowerNode = this.buildLowerTreeNode(parentBaseNode, propNode, prop, maxLevel--);
                lowerNode.setParentNode(propNode);
                TreeNode lowerTreeNode = lowerNode.getTreeNode();
                this.setTxtFieldLenAndEntryKey(lowerTreeNode, prop);
                String lowerTreeNodeType = this.getTreeNodeProType(prop);
                lowerTreeNode.setType(lowerTreeNodeType);
                lowerNode.setFieldKey(lowerTreeNode.getId());
                lowerNode.setType((IMetadata)prop);
                this.addChildNode(treeNode, lowerTreeNode);
                this.addPropChildNode(propNode, lowerNode);
            }
        }
        return propNode;
    }

    @Override
    public void buildHeadPropNode(PropertyNode root, IDataEntityProperty pro) {
        PropertyNode propNode;
        if (!this.fixedFilter(pro)) {
            return;
        }
        if (!this.filterPro(pro)) {
            return;
        }
        TreeNode treeNode = null;
        if (this.filterBaseDataPro(pro)) {
            propNode = this.buildBaseDataNode(root, pro, false);
        } else {
            IDataEntityType parentProp = pro.getParent();
            if (parentProp != null) {
                this.buildPrimaryKeyNode(root, parentProp.getPrimaryKey());
            }
            propNode = new PropertyNode();
            treeNode = this.getTreeNode(root.getTreeNode().getId(), pro.getName(), pro.getDisplayName().getLocaleValue());
            this.setTxtFieldLenAndEntryKey(treeNode, pro);
            String treeNodeType = this.getTreeNodeProType(pro);
            treeNode.setType(treeNodeType);
            propNode.setType((IMetadata)pro);
            propNode.setTreeNode(treeNode);
            propNode.setFieldKey(treeNode.getId());
        }
        if (propNode == null) {
            return;
        }
        propNode.setParentNode(root);
        TreeNode treeRootNode = root.getTreeNode();
        this.addChildNode(treeRootNode, treeNode == null ? propNode.getTreeNode() : treeNode);
        this.addPropChildNode(root, propNode);
    }

    @Override
    public void buildPrimaryKeyNode(PropertyNode parentPropNode, ISimpleProperty primaryKey) {
        String prefixPrimaryKeyText;
        String primaryKeyNodeId;
        String parentNodeId;
        if (primaryKey == null || parentPropNode == null) {
            return;
        }
        IDataEntityType parent = primaryKey.getParent();
        TreeNode parentTreeNode = parentPropNode.getTreeNode();
        if (parent instanceof SubEntryType) {
            parentTreeNode = parentPropNode.getTreeNode();
            parentNodeId = parentTreeNode.getId();
            PropertyNode grandParentNode = parentPropNode.getParentNode();
            TreeNode grandParentTreeNode = grandParentNode.getTreeNode();
            String grandParentNodeId = grandParentNode.getTreeNode().getId();
            primaryKeyNodeId = grandParentNodeId + "." + parentNodeId + "." + primaryKey.getName();
            prefixPrimaryKeyText = grandParentTreeNode.getText() + "." + parentTreeNode.getText();
        } else if (parent instanceof EntryType) {
            parentTreeNode = parentPropNode.getTreeNode();
            parentNodeId = parentTreeNode.getId();
            primaryKeyNodeId = parentNodeId + "." + primaryKey.getName();
            prefixPrimaryKeyText = parentTreeNode.getText();
        } else {
            primaryKeyNodeId = primaryKey.getName();
            prefixPrimaryKeyText = parentTreeNode.getText();
        }
        PropertyNode primaryKeyPropNode = new PropertyNode();
        String primaryKeyText = String.format(ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"PcColumnSelectStrategy_0", (String)"scmc-msmob-form", (Object[])new Object[0]), prefixPrimaryKeyText);
        TreeNode primaryKeyTreeNode = this.getTreeNode(parentTreeNode.getId(), primaryKeyNodeId, primaryKeyText);
        this.setTxtFieldLenAndEntryKey(primaryKeyTreeNode, (IDataEntityProperty)primaryKey);
        String treeNodeProType = this.getTreeNodeProType((IDataEntityProperty)primaryKey);
        primaryKeyTreeNode.setType(treeNodeProType);
        primaryKeyPropNode.setType((IMetadata)primaryKey);
        primaryKeyPropNode.setParentNode(parentPropNode);
        this.addChildNode(parentTreeNode, primaryKeyTreeNode);
        this.addPropChildNode(parentPropNode, primaryKeyPropNode);
    }

    @Override
    public void buildEntryPropNode(PropertyNode entryNode, IDataEntityProperty prop) {
        if (!this.fixedFilter(prop)) {
            return;
        }
        if (!this.filterPro(prop)) {
            return;
        }
        PropertyNode propNode = this.filterBaseDataPro(prop) ? this.buildBaseDataNode(entryNode, prop, true) : this.buildLowerTreeNode(entryNode, prop, this.getPorpertyMaxLevel());
        if (propNode == null) {
            return;
        }
        propNode.setType((IMetadata)prop);
        propNode.setParentNode(entryNode);
        TreeNode entryTreeNode = entryNode.getTreeNode();
        entryTreeNode.setType("entryentity");
        TreeNode treeNode = propNode.getTreeNode();
        this.addChildNode(entryTreeNode, treeNode);
        this.addPropChildNode(entryNode, propNode);
    }

    @Override
    public void buildSubEntryPropNode(PropertyNode entryNode, PropertyNode subEntryNode, IDataEntityProperty pro) {
        if (!this.fixedFilter(pro)) {
            return;
        }
        if (!this.filterPro(pro)) {
            return;
        }
        PropertyNode propNode = this.filterBaseDataPro(pro) ? this.buildBaseDataNode(entryNode, subEntryNode, pro, true) : this.buildLowerTreeNode(entryNode, subEntryNode, pro, this.getPorpertyMaxLevel());
        if (propNode == null) {
            return;
        }
        propNode.setType((IMetadata)pro);
        propNode.setParentNode(subEntryNode);
        TreeNode subEntryTreeNode = subEntryNode.getTreeNode();
        subEntryTreeNode.setType("entryentity");
        TreeNode treeNode = propNode.getTreeNode();
        this.addChildNode(subEntryTreeNode, treeNode);
        subEntryNode.addChild(propNode);
    }

    @Override
    public boolean isMobForm() {
        return false;
    }
}

