/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.common.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.ConvertResultManager;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.SingleRuleResultManager;
import kd.bos.service.botp.convert.actions.AbstractConvertAction;
import kd.bos.service.botp.convert.actions.CompileRuleAction;
import kd.bos.service.botp.convert.actions.CreateConvertPlugAction;
import kd.bos.service.botp.convert.actions.InitializeAction;
import kd.bos.service.botp.convert.actions.LoadFunctionTypesAction;
import kd.bos.service.botp.convert.actions.RunRuleConditionAction;
import kd.bos.service.botp.convert.compiler.CRConditionCompiler;
import kd.bos.service.botp.convert.compiler.ConvertRuleCompiler;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.scmc.msmob.common.consts.SCMCBaseBillMobConst;

public class BotpFilterUtils {
    public static QFilter getAutoRuleFilters(DynamicObject[] pcEntityArr, String srcEntityKey, String targetEntityKey, String targetMainEntryKey) {
        if (StringUtils.isEmpty((CharSequence)srcEntityKey) || StringUtils.isEmpty((CharSequence)targetEntityKey) || pcEntityArr == null || pcEntityArr.length == 0) {
            return new QFilter("1", "=", (Object)SCMCBaseBillMobConst.IDENT_EQ_VAL);
        }
        List<ListSelectedRow> selectedRows = BotpFilterUtils.getSelectedRows(pcEntityArr, targetMainEntryKey);
        return BotpFilterUtils.getConvertRuleFilters(srcEntityKey, targetEntityKey, selectedRows, null);
    }

    public static QFilter getAvailableRuleFilters(DynamicObject[] pcEntityArr, String srcEntityKey, String targetEntityKey, String targetMainEntryKey) {
        if (StringUtils.isEmpty((CharSequence)srcEntityKey) || StringUtils.isEmpty((CharSequence)targetEntityKey) || pcEntityArr == null || pcEntityArr.length == 0) {
            return new QFilter("1", "=", (Object)SCMCBaseBillMobConst.IDENT_EQ_VAL);
        }
        List convertRuleElements = ConvertMetaServiceHelper.loadRules((String)srcEntityKey, (String)targetEntityKey);
        List<ListSelectedRow> selectedRows = BotpFilterUtils.getSelectedRows(pcEntityArr, targetMainEntryKey);
        ArrayList<String> availableRuleIds = new ArrayList<String>(10);
        for (ConvertRuleElement rule : convertRuleElements) {
            if (!rule.isEnabled()) continue;
            String ruleId = rule.getId();
            availableRuleIds.add(ruleId);
        }
        QFilter qFilter = null;
        if (availableRuleIds.size() == 0) {
            qFilter = new QFilter("1", "!=", (Object)SCMCBaseBillMobConst.IDENT_EQ_VAL);
        } else {
            for (String ruleId : availableRuleIds) {
                QFilter filter = BotpFilterUtils.getConvertRuleFilters(srcEntityKey, targetEntityKey, selectedRows, ruleId);
                if (qFilter == null) {
                    qFilter = filter;
                    continue;
                }
                if (filter == null) continue;
                qFilter.or(filter);
            }
            if (qFilter == null) {
                qFilter = new QFilter("1", "=", (Object)SCMCBaseBillMobConst.IDENT_EQ_VAL);
            }
        }
        return qFilter;
    }

    private static List<ListSelectedRow> getSelectedRows(DynamicObject[] pcEntityArr, String targetMainEntryKey) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(10);
        for (DynamicObject srcBill : pcEntityArr) {
            long billId = srcBill.getLong("id");
            if (StringUtils.isNotEmpty((CharSequence)targetMainEntryKey)) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)billId);
                selectedRows.add(row);
                continue;
            }
            DynamicObjectCollection entryRowColl = srcBill.getDynamicObjectCollection(targetMainEntryKey);
            for (DynamicObject entryRow : entryRowColl) {
                Long billEntryId = entryRow.getLong("id");
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)billId);
                row.setEntryEntityKey(targetMainEntryKey);
                row.setEntryPrimaryKeyValue((Object)billEntryId);
                selectedRows.add(row);
            }
        }
        return selectedRows;
    }

    public static QFilter getConvertRuleFilters(String srcEntityKey, String targetEntityKey, List<ListSelectedRow> selectedRows, String convertRuleId) {
        QFilter allRuleFilter = null;
        if (StringUtils.isEmpty((CharSequence)srcEntityKey) || StringUtils.isEmpty((CharSequence)targetEntityKey) || selectedRows == null || selectedRows.isEmpty()) {
            return new QFilter("1", "=", (Object)SCMCBaseBillMobConst.IDENT_EQ_VAL);
        }
        PushArgs pushArgs = BotpFilterUtils.createPushArgs(srcEntityKey, targetEntityKey, selectedRows);
        if (StringUtils.isNotEmpty((CharSequence)convertRuleId)) {
            pushArgs.setRuleId(convertRuleId);
        }
        ConvertContext context = BotpFilterUtils.createContext(pushArgs);
        ConvertResultManager resultManager = BotpFilterUtils.createConvertResultManager(pushArgs);
        try {
            for (ConvertRuleElement rule : context.getRules()) {
                if (resultManager.isSkipNextRule()) continue;
                SingleRuleContext ruleContext = BotpFilterUtils.createRuleContext(context, rule);
                List<AbstractConvertAction> runAction = BotpFilterUtils.createPushActions(context, resultManager);
                SingleRuleResultManager ruleResultManager = BotpFilterUtils.createRuleResultManager(resultManager);
                for (AbstractConvertAction action : runAction) {
                    action.setRuleContext(ruleContext);
                    action.setRuleResultManager(ruleResultManager);
                    action.action();
                }
                QFilter currRuleFilter = null;
                List<QFilter> singleRuleFilter = BotpFilterUtils.getSingleRuleFilter(ruleContext);
                for (QFilter filter : singleRuleFilter) {
                    if (currRuleFilter == null) {
                        currRuleFilter = filter;
                        continue;
                    }
                    if (filter == null) continue;
                    currRuleFilter.and(filter);
                }
                if (allRuleFilter == null) {
                    allRuleFilter = currRuleFilter;
                    continue;
                }
                if (currRuleFilter == null) continue;
                allRuleFilter.or(currRuleFilter);
            }
        }
        catch (KDBizException exp) {
            throw new KDBizException(exp.getMessage());
        }
        return allRuleFilter;
    }

    private static List<QFilter> getSingleRuleFilter(SingleRuleContext ruleContext) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        ConvertRuleCompiler ruleCompiler = ruleContext.getRuleCompiler();
        CRConditionCompiler ruleCondCompiler = ruleCompiler.getRuleCondCompiler();
        CRConditionCompiler dataFilterCompiler = ruleCompiler.getDataFilterCompiler();
        if (ruleCondCompiler != null) {
            qFilters.addAll(ruleCondCompiler.getGridQFilters());
        }
        if (dataFilterCompiler != null) {
            qFilters.addAll(dataFilterCompiler.getGridQFilters());
        }
        return qFilters;
    }

    private static PushArgs createPushArgs(String srcEntityKey, String targetEntityKey, List<ListSelectedRow> selectedRows) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntityKey);
        pushArgs.setTargetEntityNumber(targetEntityKey);
        pushArgs.setSelectedRows(selectedRows);
        pushArgs.setBuildConvReport(true);
        return pushArgs;
    }

    private static ConvertContext createContext(PushArgs args) {
        ConvertContext context = new ConvertContext();
        if (args == null) {
            return context;
        }
        context.setInputArgs((AbstractConvertServiceArgs)args);
        BillEntityType srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)args.getSourceEntityNumber());
        BillEntityType tgtMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)args.getTargetEntityNumber());
        context.setSourceMainType(srcMainType);
        context.setTargetMainType(tgtMainType);
        List<ConvertRuleElement> rules = BotpFilterUtils.loadRules(context);
        Set ruleIds = args.getRuleIds();
        List convertRuleElements = context.getRules();
        if (ruleIds.isEmpty()) {
            convertRuleElements.addAll(rules);
        } else {
            for (ConvertRuleElement rule : rules) {
                if (!ruleIds.contains(rule.getId())) continue;
                convertRuleElements.add(rule);
            }
        }
        Map customParams = args.getCustomParams();
        if (customParams != null) {
            for (Map.Entry item : customParams.entrySet()) {
                context.getOption().setVariableValue((String)item.getKey(), (String)item.getValue());
            }
        }
        context.setConvertOpType(ConvertOpType.Push);
        return context;
    }

    private static List<ConvertRuleElement> loadRules(ConvertContext context) {
        if (context == null) {
            return new ArrayList<ConvertRuleElement>(10);
        }
        PushArgs pushArgs = (PushArgs)context.getInputArgs();
        String ruleIdOfPushArgs = pushArgs.getRuleId();
        if (StringUtils.isNotBlank((CharSequence)ruleIdOfPushArgs)) {
            ConvertRuleElement rule = ConvertRuleCache.loadRule((String)ruleIdOfPushArgs);
            if (!rule.isEnabled()) {
                return new ArrayList<ConvertRuleElement>(10);
            }
            ArrayList<ConvertRuleElement> rules = new ArrayList<ConvertRuleElement>(10);
            rules.add(rule);
            return rules;
        }
        String sourceEntityNumber = pushArgs.getSourceEntityNumber();
        String targetEntityNumber = pushArgs.getTargetEntityNumber();
        List rules = ConvertRuleCache.loadRules((String)sourceEntityNumber, (String)targetEntityNumber);
        ArrayList<ConvertRuleElement> enableRules = new ArrayList<ConvertRuleElement>(10);
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled() || !rule.isVisibled()) continue;
            enableRules.add(rule);
        }
        BotpFilterUtils.sortRules(enableRules);
        return enableRules;
    }

    private static void sortRules(List<ConvertRuleElement> enableRules) {
        enableRules.sort(new Comparator<ConvertRuleElement>(){

            @Override
            public int compare(ConvertRuleElement ruleElement1st, ConvertRuleElement ruleElement2nd) {
                boolean isEmpty1st = this.isEmptyCondition(ruleElement1st);
                boolean isEmpty2nd = this.isEmptyCondition(ruleElement2nd);
                if (!isEmpty1st && !isEmpty2nd) {
                    if (ruleElement1st.isDefRule()) {
                        return -1;
                    }
                    if (ruleElement2nd.isDefRule()) {
                        return 1;
                    }
                    return 0;
                }
                if (!isEmpty1st) {
                    return -1;
                }
                if (!isEmpty2nd) {
                    return 1;
                }
                if (ruleElement1st.isDefRule()) {
                    return -1;
                }
                if (ruleElement2nd.isDefRule()) {
                    return 1;
                }
                return 0;
            }

            private boolean isEmptyCondition(ConvertRuleElement rule) {
                CRCondition runCondition = rule.getRunCondition();
                if (runCondition == null) {
                    return true;
                }
                FilterCondition filterCondition = runCondition.getFilterCondition();
                if (filterCondition != null && filterCondition.getFilterRow() != null && !filterCondition.getFilterRow().isEmpty()) {
                    return false;
                }
                return StringUtils.isBlank((CharSequence)runCondition.getExpression());
            }
        });
    }

    private static ConvertResultManager createConvertResultManager(PushArgs args) {
        ConvertResultManager resultManager = new ConvertResultManager();
        List selectedRows = args.getSelectedRows();
        resultManager.getReporter().initBillAndRules(selectedRows);
        return resultManager;
    }

    private static SingleRuleContext createRuleContext(ConvertContext context, ConvertRuleElement rule) {
        SingleRuleContext ruleContext = new SingleRuleContext();
        ruleContext.setContext(context);
        ruleContext.setRule(rule);
        return ruleContext;
    }

    private static List<AbstractConvertAction> createPushActions(ConvertContext context, ConvertResultManager resultManager) {
        ArrayList<AbstractConvertAction> convertActions = new ArrayList<AbstractConvertAction>(10);
        convertActions.add((AbstractConvertAction)new CreateConvertPlugAction(context, resultManager));
        convertActions.add((AbstractConvertAction)new LoadFunctionTypesAction(context, resultManager));
        convertActions.add((AbstractConvertAction)new InitializeAction(context, resultManager));
        convertActions.add((AbstractConvertAction)new RunRuleConditionAction(context, resultManager));
        convertActions.add((AbstractConvertAction)new CompileRuleAction(context, resultManager));
        return convertActions;
    }

    private static SingleRuleResultManager createRuleResultManager(ConvertResultManager resultManager) {
        SingleRuleResultManager ruleResultManager = new SingleRuleResultManager();
        ruleResultManager.setConvertResultManager(resultManager);
        return ruleResultManager;
    }
}

