/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    private static final Log log = LogFactory.getLog(DateUtils.class);
    private static final String FORMAT_SHORT_DATE = "yyyy-MM-dd";

    public static Date getDayEndTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getDayStartTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date addDay(Date date, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, amount);
        return calendar.getTime();
    }

    public static Date getThisWeekStartDate() {
        Date thisWeekEndDate = DateUtils.getThisWeekEndDate();
        Date thisWeekStartDate = DateUtils.addDay(thisWeekEndDate, -6);
        return DateUtils.getDayStartTime(thisWeekStartDate);
    }

    public static Date getThisWeekEndDate() {
        Date currDate = new Date();
        Date sundayEndTime = DateUtils.getSundayEndTime();
        return currDate.before(sundayEndTime) ? sundayEndTime : DateUtils.addDay(sundayEndTime, 7);
    }

    public static Date getSundayEndTime() {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 1);
        Date date = cal.getTime();
        return DateUtils.getDayEndTime(date);
    }

    public static Date getStartTimeOfPastThreeMonths(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        calendar.add(2, -3);
        return calendar.getTime();
    }

    public static Date parseShortDate(String dateStr, boolean isThrowEx) {
        Date date;
        log.info("\u201cDateUtils.parseShortDate\u201d\u7684\u5165\u53c2\u201cdateStr\u201d\uff1a{}", (Object)dateStr);
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            if (isThrowEx) {
                String errMsg = ResManager.loadKDString((String)"\u201cDateUtils.parseShortDate\u201d\u7684\u5165\u53c2\u201cdateStr\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u3002", (String)"DateUtils_2", (String)"scmc-msmob-form", (Object[])new Object[0]);
                throw new KDBizException(errMsg);
            }
            return null;
        }
        SimpleDateFormat sd = new SimpleDateFormat(FORMAT_SHORT_DATE);
        try {
            date = sd.parse(dateStr);
        }
        catch (ParseException e) {
            log.warn("\u201cDateUtils.parseDate\u201d\u65b9\u6cd5\uff1a\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            String errMsg = ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"DateUtils_0", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        return date;
    }

    public static String getDateToString(Date date, boolean isThrowEx) {
        log.info("\u201cDateUtils.getDateToString\u201d\u7684\u5165\u53c2\u201cdate\u201d\uff1a{}", (Object)date);
        if (date == null) {
            if (isThrowEx) {
                String errMsg = ResManager.loadKDString((String)"\u201cDateUtils.getDateToString\u201d\u7684\u5165\u53c2\u201cdate\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u3002", (String)"DateUtils_1", (String)"scmc-msmob-form", (Object[])new Object[0]);
                throw new KDBizException(errMsg);
            }
            return "";
        }
        SimpleDateFormat sd = new SimpleDateFormat(FORMAT_SHORT_DATE);
        String dateString = sd.format(date);
        return dateString;
    }
}

