/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.common.utils;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.scmc.msmob.common.enums.AuditStatusEnum;
import kd.scmc.msmob.common.enums.BillStatusEnum;
import kd.scmc.msmob.common.enums.CfmStatusEnum;
import kd.scmc.msmob.plugin.tpl.basetpl.AbstractMobDataModelPlugin;

public class LabelAndToolUtils {
    public static void setLabelAndToolVisible(IFormView view, String billStatus) {
        view.setVisible(Boolean.FALSE, new String[]{"buttonaudit", "buttondelete", "buttonsave", "buttonsubmit", "buttonunaudit", "buttonunsubmit", "buttonpush", "buttonclose", "labelaudit", "labelclose", "labelsubmit", "labelsave"});
        if (billStatus.equals(BillStatusEnum.SAVE.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"labelsave", "buttonsave", "buttondelete", "buttonsubmit"});
        } else if (billStatus.equals(BillStatusEnum.SUBMIT.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"buttonaudit", "buttonunsubmit", "labelsubmit"});
        } else if (billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"buttonpush", "labelaudit"});
        } else if (billStatus.equals(BillStatusEnum.CLOSE.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"labelclose"});
        }
    }

    public static void setCfmStatusLabelVisible(IFormView view, String cfmStatus) {
        view.setVisible(Boolean.FALSE, new String[]{"labelunconfirm", "labelconfirm", "labelreject", "labelchanging", "buttonconfirm"});
        if (cfmStatus.equals(CfmStatusEnum.UNCONFIRM.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"labelunconfirm", "buttonconfirm"});
        } else if (cfmStatus.equals(CfmStatusEnum.CONFIRM.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"labelconfirm"});
        } else if (cfmStatus.equals(CfmStatusEnum.REJECT.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"labelreject"});
        } else if (cfmStatus.equals(CfmStatusEnum.CHANGING.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"labelchanging"});
        } else if (cfmStatus.equals(CfmStatusEnum.AUTO_CONFIRM.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"labelautoconfirm"});
        }
    }

    public static void setAuditStatusLabelVisible(IFormView view, String auditStatus) {
        view.setVisible(Boolean.FALSE, new String[]{"drafted", "submit_approval", "approved", "approval_refusal", "approving"});
        if (auditStatus.equals(AuditStatusEnum.DRAFTED.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"drafted"});
        } else if (auditStatus.equals(AuditStatusEnum.SUBMIT_APPROVAL.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"submit_approval"});
        } else if (auditStatus.equals(AuditStatusEnum.APPROVED.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"approved"});
        } else if (auditStatus.equals(AuditStatusEnum.APPROVAL_REFUSAL.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"approval_refusal"});
        } else if (auditStatus.equals(AuditStatusEnum.APPROVING.getValue())) {
            view.setVisible(Boolean.TRUE, new String[]{"approving"});
        }
    }

    public static void cardEntryHideLabels(AbstractMobDataModelPlugin plugin, int size, String entryKey, String[] labelContainers) {
        CardEntry cardEntry = (CardEntry)plugin.getControl(entryKey);
        for (int i = 0; i < size; ++i) {
            cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, LabelAndToolUtils.getLabelsFromParentContainer(plugin.getView(), labelContainers));
        }
    }

    private static String[] getLabelsFromParentContainer(IFormView view, String[] containers) {
        ArrayList<String> labelKeys = new ArrayList<String>();
        Container[] containersControl = new Container[containers.length];
        for (int i = 0; i < containers.length; ++i) {
            containersControl[i] = (Container)view.getControl(containers[i]);
            if (containersControl[i] == null) continue;
            List labels = containersControl[i].getItems();
            for (Control label : labels) {
                if (!(label instanceof Label)) continue;
                labelKeys.add(label.getKey());
            }
        }
        return labelKeys.toArray(new String[0]);
    }

    public static void selBasedataEditLabelValue(IFormView view, String basedataEditKey, String basedataEditLabelKey) {
        IDataModel model = view.getModel();
        Label label = (Label)view.getControl(basedataEditLabelKey);
        if (label == null) {
            return;
        }
        Control control = view.getControl(basedataEditKey);
        if (control == null || !(control instanceof BasedataEdit)) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u5728kd.scmc.msmob.common.utils.LabelAndToolUtils.selBasedataEditLabelValue\u65b9\u6cd5\u7684\u5165\u53c2\u201cbasedataEditKey\u201d\u4f20\u5165\u6b63\u786e\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u5b57\u6bb5\u6807\u8bc6\u3002", (String)"LabelAndToolUtils_0", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        Object value = model.getValue(basedataEditKey);
        if (value == null) {
            label.setText("");
            return;
        }
        ILocaleString name = ((DynamicObject)value).getLocaleString("name");
        if (name == null) {
            label.setText("");
            return;
        }
        String localeValue = name.getLocaleValue();
        String labelText = localeValue == null ? "" : localeValue;
        label.setText(labelText);
    }
}

