/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.common.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MetaUtils {
    private static final Log LOG = LogFactory.getLog(MetaUtils.class);

    public static boolean isExistFieldKey(DynamicObject dyObject, String fieldKey) {
        DynamicObjectType dyType = dyObject.getDynamicObjectType();
        if (dyType == null) {
            return false;
        }
        DynamicProperty dyProp = dyType.getProperty(fieldKey);
        return dyProp != null;
    }

    public static boolean isExistEntryFieldKey(DynamicObject bill, String entryKey, String fieldKey) {
        if (bill == null || kd.bos.util.StringUtils.isEmpty((String)entryKey) || kd.bos.util.StringUtils.isEmpty((String)fieldKey)) {
            return false;
        }
        IDataEntityType dataEntityType = bill.getDataEntityType();
        if (!(dataEntityType instanceof MainEntityType)) {
            return false;
        }
        MainEntityType mainType = (MainEntityType)dataEntityType;
        Map entityTypeMap = mainType.getAllEntities();
        EntityType entityType = (EntityType)entityTypeMap.get(entryKey);
        if (entityType == null) {
            return false;
        }
        Map propMap = entityType.getFields();
        return propMap.containsKey(fieldKey);
    }

    public static boolean isPersistent(DynamicObject entityObj) {
        DataEntityState dataEntityState = entityObj.getDataEntityState();
        return dataEntityState == null ? false : dataEntityState.getFromDatabase();
    }

    public static boolean isExistsMeta(String entityKey) {
        if (kd.bos.util.StringUtils.isEmpty((String)entityKey)) {
            return false;
        }
        QFilter filter = new QFilter("number", "=", (Object)entityKey);
        boolean exists = QueryServiceHelper.exists((String)"bos_formmeta", (QFilter[])filter.toArray());
        return exists;
    }

    public static String getPcAppId(String pcEntityKey) {
        String entityId = MetadataDao.getIdByNumber((String)pcEntityKey, (MetaCategory)MetaCategory.Entity);
        String appid = MetadataDao.getAppIdByFormId((String)entityId);
        LOG.info("\u6807\u8bc6\u4e3a{}\u7684PC\u7aef\u5b9e\u4f53\u5339\u914d\u7684\u5e94\u7528\u5185\u7801\u4e3a{}\u3002", (Object)pcEntityKey, (Object)appid);
        if (StringUtils.isEmpty((CharSequence)appid)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u6807\u8bc6\u4e3a\u201c%s\u201d\u7684PC\u7aef\u5b9e\u4f53\u5339\u914d\u7684\u5e94\u7528\u5185\u7801\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractMobBillBasePlugin_0", (String)"scmc-msmob-form", (Object[])new Object[0]), pcEntityKey);
            throw new KDBizException(errMsg);
        }
        return appid;
    }

    private static DynamicObjectCollection getBaseForms(List<String> baseFormNumbers) {
        QFilter qFilter = new QFilter("number", "in", baseFormNumbers);
        return QueryServiceHelper.query((String)"bos_formmeta", (String)"id", (QFilter[])qFilter.toArray());
    }

    public static Map<String, String> getMobFormF7Range(List<String> baseFormNumbers) {
        HashMap<String, String> numberToName = new HashMap<String, String>(16);
        DynamicObjectCollection baseForms = MetaUtils.getBaseForms(baseFormNumbers);
        QFilter inheritPathFilter = null;
        for (DynamicObject baseForm : baseForms) {
            QFilter filter = new QFilter("inheritpath", "like", (Object)("%" + baseForm.getString("id") + "%"));
            if (inheritPathFilter == null) {
                inheritPathFilter = filter;
                continue;
            }
            inheritPathFilter.or(filter);
        }
        if (inheritPathFilter != null) {
            DynamicObjectCollection formMetas = QueryServiceHelper.query((String)"bos_formmeta", (String)"number,name", (QFilter[])inheritPathFilter.toArray());
            for (DynamicObject formMeta : formMetas) {
                String name = formMeta.getString("name");
                String number = formMeta.getString("number");
                numberToName.put(number, name);
            }
        }
        return numberToName;
    }

    public static String getBillName(String billType) {
        if (!MetaUtils.isExistsMeta(billType)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScanResultBillPlugin_0", (String)"scmc-msmob-form", (Object[])new Object[0]), billType);
            throw new KDBizException(errMsg);
        }
        String langName = RequestContext.get().getLang().name();
        MainEntityType billFormType = MetadataServiceHelper.getDataEntityType((String)billType);
        return (String)billFormType.getDisplayName().get((Object)langName);
    }

    public static String getMainOrgId(String billType) {
        if (!MetaUtils.isExistsMeta(billType)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScanResultBillPlugin_0", (String)"scmc-msmob-form", (Object[])new Object[0]), billType);
            throw new KDBizException(errMsg);
        }
        MainEntityType billFormType = MetadataServiceHelper.getDataEntityType((String)billType);
        String org = billFormType.getMainOrg();
        if (org != null) {
            return org + ".id";
        }
        return "";
    }
}

