/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;

public class MobileControlUtils {
    private static final String BORDER_COLOR = "borc";

    public static void setCardEntryRowProperties(CardEntry cardEntry, int rowIndex, Map<String, Object> proData, String ... keys) {
        if (proData == null || proData.size() == 0) {
            return;
        }
        for (String key : keys) {
            HashMap<String, Map<String, Object>> keyToProData = new HashMap<String, Map<String, Object>>(16);
            keyToProData.put(key, proData);
            cardEntry.setCustomProperties(key, rowIndex, keyToProData);
        }
    }

    public static void setCardEntryRowProperty(CardEntry cardEntry, String key, int rowIndex, Map<String, Object> proData) {
        if (proData == null || proData.size() == 0) {
            return;
        }
        HashMap<String, Map<String, Object>> keyToProData = new HashMap<String, Map<String, Object>>(16);
        keyToProData.put(key, proData);
        cardEntry.setCustomProperties(key, rowIndex, keyToProData);
    }

    public static void setEntryLabelVisible(CardEntry cardEntry, Map<String, String> fieldToLabelKey, int startRowIndex, int endRowIndex) {
        if (cardEntry == null || fieldToLabelKey == null || fieldToLabelKey.isEmpty()) {
            return;
        }
        DynamicObject[] entryArr = cardEntry.getEntryData().getDataEntitys();
        for (int i = startRowIndex; i < endRowIndex; ++i) {
            DynamicObject entryRow = entryArr[i];
            for (Map.Entry<String, String> entry : fieldToLabelKey.entrySet()) {
                String fieldKey = entry.getKey();
                String labelKey = entry.getValue();
                Object fieldValue = entryRow.get(fieldKey);
                MobileControlUtils.setLabelVisibleByFieldValue(cardEntry, i, fieldValue, labelKey);
            }
        }
    }

    private static void setLabelVisibleByFieldValue(CardEntry cardEntry, int index, Object fieldValue, String labelKey) {
        if (fieldValue == null) {
            cardEntry.setChildVisible(true, index, new String[]{labelKey});
        } else {
            cardEntry.setChildVisible(false, index, new String[]{labelKey});
        }
    }

    public static void updateLabelText(IFormView view, String labelKey, String newText) {
        if (view == null || StringUtils.isEmpty((CharSequence)labelKey) || StringUtils.isEmpty((CharSequence)newText)) {
            return;
        }
        Label control = (Label)view.getControl(labelKey);
        if (control == null) {
            return;
        }
        control.setText(newText);
        HashMap<String, Object> metaDataInfo = new HashMap<String, Object>(16);
        HashMap itemMap = new HashMap(16);
        HashMap<String, String> nameMap = new HashMap<String, String>(16);
        nameMap.put("zh_CN", newText);
        itemMap.put("text", nameMap);
        metaDataInfo.put("id", labelKey);
        metaDataInfo.put("item", itemMap);
        view.updateControlMetadata(labelKey, metaDataInfo);
    }

    public static void addComboItems(ComboEdit comboEdit, Map<String, LocaleString> comboItemInfo) {
        if (comboEdit == null || comboItemInfo == null) {
            return;
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        for (Map.Entry<String, LocaleString> comboItemEntry : comboItemInfo.entrySet()) {
            String comboValue = comboItemEntry.getKey();
            LocaleString title = comboItemEntry.getValue();
            ComboItem comboItem = new ComboItem(title, comboValue);
            comboItems.add(comboItem);
        }
        comboEdit.setComboItems(comboItems);
    }

    public static Map<String, Object> buildBasicPropOfLabel(String labelName, String foreColor, String backColor, String borderColor) {
        HashMap<String, Object> propMap = new HashMap<String, Object>(16);
        propMap.put("text", labelName);
        propMap.put("fc", foreColor);
        propMap.put("bc", backColor);
        propMap.put(BORDER_COLOR, borderColor);
        return propMap;
    }
}

