/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.common.utils;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.util.StringUtils;
import kd.scmc.msmob.business.helper.MetaHelper;
import kd.scmc.msmob.common.design.strategy.colsselect.IColsSelectStrategy;
import kd.scmc.msmob.pojo.SelectParams;

public class PageUtils {
    public static void showColsTreePage(IFormView view, String entityNumber, IColsSelectStrategy selectStrategy, CloseCallBack callBack) {
        MetaHelper metaHelper = new MetaHelper(selectStrategy, entityNumber);
        PageUtils.showMetaColsTreePage(view, callBack, metaHelper);
    }

    public static void showEntryIdTreePage(IFormView view, String entityNumber, IColsSelectStrategy selectStrategy, CloseCallBack callBack) {
        MetaHelper metaHelper = new MetaHelper(selectStrategy, entityNumber);
        metaHelper.setOnlyDisplayEntryId(Boolean.TRUE);
        PageUtils.showMetaColsTreePage(view, callBack, metaHelper);
    }

    private static void showMetaColsTreePage(IFormView view, CloseCallBack callBack, MetaHelper metaHelper) {
        SelectParams params = new SelectParams();
        String jsonTree = metaHelper.buildTree2JSON();
        params.setJsonTree(jsonTree);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mob_colstree_select");
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(callBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public static void showFormPage(IFormView view, String mobFormKey, Map<String, Object> customParams, CloseCallBack closeCallBack) {
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        if (StringUtils.isEmpty((String)mobFormKey)) {
            String errMsg = ResManager.loadKDString((String)"\u201cPageUtils.showFormPage\u201d\u65b9\u6cd5\u7684\u5165\u53c2\u79fb\u52a8\u8868\u5355\u6807\u8bc6\u201cmobFormKey\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PageUtils_0", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        formShowParameter.setFormId(mobFormKey);
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        if (closeCallBack != null) {
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        if (customParams != null) {
            formShowParameter.setCustomParams(customParams);
        }
        if (view != null) {
            view.showForm((FormShowParameter)formShowParameter);
        }
    }
}

