/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.common.utils;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.msmob.business.helper.BarcodeParseHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.common.enums.BillStatusEnum;
import kd.scmc.msmob.common.enums.EnableStatusEnum;
import kd.scmc.msmob.common.utils.MetaUtils;
import kd.scmc.msmob.common.utils.PageUtils;
import kd.scmc.msmob.pojo.QrCodeResult;

public class ScanResultParseUtils {
    public static void scanResultParseByType(IFormView view, Object barCode, Long orgId, CloseCallBack closeCallBack) {
        String code;
        QrCodeResult result;
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("orgid", orgId);
        if (barCode == null || StringUtils.isBlank((Object)barCode)) {
            PageUtils.showFormPage(view, "msmob_scan_no_result", null, closeCallBack);
        }
        if ((result = BarcodeParseHelper.qrCodeParse(code = String.valueOf(barCode))) == null) {
            PageUtils.showFormPage(view, "msmob_scan_no_result", null, closeCallBack);
            return;
        }
        if (!result.isSuccess()) {
            String message = result.getMessage();
            String tip = ResManager.loadKDString((String)"\u626b\u63cf\u89e3\u6790\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u3002", (String)"ScanResultParseUtils_3", (String)"scmc-msmob-form", (Object[])new Object[0]);
            customParams.put("scanResultTips", tip);
            customParams.put("scanResultMessage", message);
            PageUtils.showFormPage(view, "msmob_scan_undefined", customParams, null);
            return;
        }
        String type = result.getCodeType();
        if (StringUtils.isBlank((CharSequence)type)) {
            customParams.put("scanResultMessage", code);
            String tip = ResManager.loadKDString((String)"\u4ee5\u4e0b\u626b\u7801\u5185\u5bb9\u4e3a\u672a\u5b9a\u4e49\u6761\u7801\uff0c\u8bf7\u8c28\u614e\u4f7f\u7528\u3002", (String)"ScanResultParseUtils_2", (String)"scmc-msmob-form", (Object[])new Object[0]);
            customParams.put("scanResultTips", tip);
            PageUtils.showFormPage(view, "msmob_scan_undefined", customParams, null);
            return;
        }
        QFilter familyFilter = new QFilter("number", "=", (Object)type.trim());
        familyFilter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        familyFilter.and("status", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObject skillFamily = BusinessDataServiceHelper.loadSingle((String)"msmob_skill_family", (QFilter[])familyFilter.toArray());
        if (skillFamily == null) {
            customParams.put("scanResultMessage", code);
            String tip = ResManager.loadKDString((String)"\u4ee5\u4e0b\u626b\u7801\u5185\u5bb9\u4e3a\u672a\u5b9a\u4e49\u6761\u7801\uff0c\u8bf7\u8c28\u614e\u4f7f\u7528\u3002", (String)"ScanResultParseUtils_2", (String)"scmc-msmob-form", (Object[])new Object[0]);
            customParams.put("scanResultTips", tip);
            PageUtils.showFormPage(view, "msmob_scan_undefined", customParams, null);
            return;
        }
        QFilter filter = new QFilter("skill_family.number", "=", (Object)type);
        filter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        filter.and("status", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DynamicObject resultsConfig = BusinessDataServiceHelper.loadSingle((String)"msmob_scan_result_cfg", (QFilter[])filter.toArray());
        if (resultsConfig == null || resultsConfig.getDynamicObject("resultpage") == null) {
            PageUtils.showFormPage(view, "msmob_scan_not_cfg", customParams, closeCallBack);
            return;
        }
        DynamicObject pageDyn = resultsConfig.getDynamicObject("resultpage");
        String pageNumber = pageDyn.getString("number");
        if (!MetaUtils.isExistsMeta(pageNumber)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u9875\u9762\u5143\u6570\u636e\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataSourceConfigServiceImpl_notExists", (String)"scmc-msmob-form", (Object[])new Object[0]), pageNumber);
            view.showErrorNotification(errMsg);
            return;
        }
        customParams.put("scanResultData", JSON.toJSONString((Object)result));
        customParams.put("scanResultType", type);
        String entityToString = EntityCacheHelper.serializeFromEntityToString(resultsConfig);
        view.getPageCache().put("scanResultConfig", entityToString);
        PageUtils.showFormPage(view, pageNumber, customParams, null);
    }
}

