/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.mvccore;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    private static final JsonMapper jsonMapper = new JsonMapper();

    public static String serialize(Object value) {
        try {
            String s = jsonMapper.writeValueAsString(value);
            return s;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T deserialize(String jsonString, Class<T> resultClass) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)jsonMapper.readValue(jsonString, resultClass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> deserializeList(String jsonString, Class<T> resultClass) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return new ArrayList();
        }
        try {
            CollectionType javaType = jsonMapper.getTypeFactory().constructCollectionType(List.class, resultClass);
            List list = (List)jsonMapper.readValue(jsonString, (JavaType)javaType);
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

