/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.mvccore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.result.ApiSaveItemData;
import kd.bos.openapi.api.result.ApiSaveResult;
import kd.bos.openapi.api.result.ApiSubmitResult;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.OpenApiSdkUtil;
import kd.scmc.msmob.mvccore.IMobileApiSearch;
import kd.scmc.msmob.mvccore.JsonUtils;
import kd.scmc.msmob.mvccore.OpenApiDataSource;
import kd.scmc.msmob.mvccore.UrlMappingUtils;

public class MobileApiCRUDUtils {
    private static final Log log = LogFactory.getLog(MobileApiCRUDUtils.class);

    public static <P extends AbstractFormPlugin> void addOperationParameter(P plugin, BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String pcEntityCacheStr = plugin.getPageCache().getBigObject("API_PAGE_CACHE_KEY");
        OperateOption option = formOperate.getOption();
        option.setVariableValue("API_PAGE_CACHE_KEY", pcEntityCacheStr);
        OpenApiDataSource openApiDataSource = ((IMobileApiSearch)plugin).getDatasourceConfig();
        if (openApiDataSource == null || openApiDataSource.getAddress() == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"OPENAPI\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a\u3002", (String)"Exception_openapi_address_not_found", (String)"scmc-msmob-form", (Object[])new Object[0]), new Object[0]));
        }
        Class mappingClass = openApiDataSource.getMappingClass();
        option.setVariableValue("API_MAPPING_CLASS_NAME", mappingClass.getName());
    }

    public static void checkOpenapiResultException(OpenApiResult result) {
        Object resultData = result.getData();
        if (!result.isStatus()) {
            ArrayList errorMessages = new ArrayList();
            if (resultData instanceof ApiSaveResult) {
                ApiSaveResult apiSaveResult = (ApiSaveResult)resultData;
                List apiSaveItemDataList = apiSaveResult.getResult();
                apiSaveItemDataList.forEach(apiSaveItemData -> {
                    List errors = apiSaveItemData.getErrors();
                    errors.forEach(apiSaveRowErrorData -> {
                        Set rowMsg = apiSaveRowErrorData.getRowMsg();
                        errorMessages.addAll(rowMsg);
                    });
                });
            }
            if (errorMessages.isEmpty()) {
                throw new KDBizException(result.getMessage());
            }
            throw new KDBizException(errorMessages.stream().collect(Collectors.joining("\n")));
        }
    }

    public static OpenApiResult callCRUDApi(Object vo, String url, boolean wrap) {
        OpenApiResult result;
        String jsonString = JsonUtils.serialize(vo);
        HashMap dataMap = JsonUtils.deserialize(jsonString, HashMap.class);
        if (wrap) {
            HashMap<String, HashMap> parameterMap = new HashMap<String, HashMap>();
            parameterMap.put("data", dataMap);
            result = OpenApiSdkUtil.invoke((String)UrlMappingUtils.getUrl(url), parameterMap);
        } else {
            result = OpenApiSdkUtil.invoke((String)UrlMappingUtils.getUrl(url), (Map)dataMap);
        }
        MobileApiCRUDUtils.checkOpenapiResultException(result);
        Object resultData = result.getData();
        if (resultData instanceof ApiSaveResult) {
            List saveItemData = ((ApiSaveResult)resultData).getResult();
            ApiSaveItemData apiSaveItemData = (ApiSaveItemData)saveItemData.get(0);
            String string = apiSaveItemData.getId();
        }
        if (resultData instanceof ApiSubmitResult) {
            ApiSubmitResult apiSubmitResult = (ApiSubmitResult)resultData;
            List list = apiSubmitResult.getResult();
        }
        return result;
    }
}

