/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.mvccore;

import java.lang.reflect.Field;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.msmob.mvccore.JsonUtils;
import kd.scmc.msmob.mvccore.MobileApiRendererUtils;
import kd.scmc.msmob.mvccore.MobileFieldMapping;
import kd.scmc.msmob.mvccore.MobileReflectionUtils;

public class MobileApiDataChangedListener<P extends AbstractFormPlugin>
implements IDataModelChangeListener {
    protected final P formPlugin;

    public MobileApiDataChangedListener(P formPlugin) {
        this.formPlugin = formPlugin;
    }

    protected void reSerialize(Object vo) {
        String jsonString = JsonUtils.serialize(vo);
        IPageCache pageCache = this.formPlugin.getView().getPageCache();
        pageCache.putBigObject("API_PAGE_CACHE_KEY", jsonString);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        MobileFieldMapping mobileFieldMapping = MobileFieldMapping.construct(this.formPlugin.getView());
        Object newValue = e.getChangeSet()[0].getNewValue();
        boolean isInEntryGrid = e.getProperty().getParent() instanceof EntryType;
        String mobileFieldName = e.getProperty().getName();
        Object cachedObject = MobileApiRendererUtils.getCachedObject(this.formPlugin.getView());
        if (isInEntryGrid) {
            String entryName = e.getProperty().getParent().getName();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            Field entryCollectionField = (Field)mobileFieldMapping.get(entryName);
            List entryList = (List)MobileReflectionUtils.getFieldValue(entryCollectionField, cachedObject);
            Field entryField = mobileFieldMapping.getEntryField(entryName, mobileFieldName);
            Object changedEntryRow = entryList.get(rowIndex);
            if (entryField != null) {
                MobileReflectionUtils.setFieldValue(entryField, changedEntryRow, newValue);
            }
        } else {
            Field field = (Field)mobileFieldMapping.get(mobileFieldName);
            if (field != null) {
                if (newValue instanceof DynamicObject) {
                    MobileReflectionUtils.setFieldValue(field, cachedObject, ((DynamicObject)newValue).getPkValue());
                } else {
                    MobileReflectionUtils.setFieldValue(field, cachedObject, newValue);
                }
            }
        }
        this.reSerialize(cachedObject);
    }
}

