/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.mvccore;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.mvccore.IMobileApiEntryPage;
import kd.scmc.msmob.mvccore.IMobileApiPage;
import kd.scmc.msmob.mvccore.IMobileApiResultHandler;
import kd.scmc.msmob.mvccore.IMobileApiSearch;
import kd.scmc.msmob.mvccore.JsonUtils;
import kd.scmc.msmob.mvccore.MobileApiDataChangedListener;
import kd.scmc.msmob.mvccore.MobileApiEntryDataChangedListener;
import kd.scmc.msmob.mvccore.MobileApiUtils;
import kd.scmc.msmob.mvccore.MobileElement;
import kd.scmc.msmob.mvccore.MobileFieldMapping;
import kd.scmc.msmob.mvccore.MobileReflectionUtils;
import kd.scmc.msmob.mvccore.MobileViewModelUtils;
import kd.scmc.msmob.mvccore.context.MobileApiVisitingContext;
import kd.scmc.msmob.mvccore.context.VisitingContextElement;
import kd.scmc.msmob.mvccore.element.AbstractElementHandler;
import kd.scmc.msmob.mvccore.element.AbstractFieldHandler;
import kd.scmc.msmob.mvccore.element.AttachmentHandler;
import kd.scmc.msmob.mvccore.element.HtmlHandler;
import kd.scmc.msmob.mvccore.element.LabelHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class MobileApiRendererUtils {
    private static final Set<Class<? extends AbstractElementHandler>> elementHandlers = new HashSet<Class<? extends AbstractElementHandler>>();
    private static final Set<Class<? extends AbstractFieldHandler>> fieldHandlers = new HashSet<Class<? extends AbstractFieldHandler>>();

    public static <T extends AbstractFormPlugin & IMobileApiPage, M> void renderListPage(T formPlugin) {
        String entryName = MobileViewModelUtils.getFirstEntryName(formPlugin);
        List<M> voList = MobileApiRendererUtils.renderListPage(formPlugin, entryName);
        formPlugin.getView().updateView();
        MobileApiRendererUtils.renderListView(formPlugin, entryName, voList);
    }

    public static <T extends AbstractFormPlugin & IMobileApiPage, M> void renderListPageOnPageSwitched(T formPlugin, PagerClickEvent pagerClickEvent) {
        List cachedObjectList;
        CardEntry cardEntry;
        int pageRow;
        IFormView view = formPlugin.getView();
        String entryName = MobileViewModelUtils.getFirstEntryName(formPlugin);
        int currentPageIndex = pagerClickEvent.getCurrentPageIndex();
        int startIndex = (currentPageIndex - 1) * (pageRow = (cardEntry = (CardEntry)view.getControl(entryName)).getPageRow());
        int endIndex = startIndex + pageRow;
        if (endIndex > (cachedObjectList = MobileApiRendererUtils.getCachedObjectList(view)).size()) {
            endIndex = cachedObjectList.size();
        }
        for (int index = startIndex; index < endIndex; ++index) {
            Object vo = cachedObjectList.get(index);
            MobileApiRendererUtils.renderView((IMobileApiPage)formPlugin, vo, index);
        }
    }

    public static <T extends AbstractFormPlugin & IMobileApiPage, M> List<M> renderListPage(T formPlugin, String entryName) {
        List voList = MobileApiUtils.getDataListFromOpenApi((IMobileApiSearch)formPlugin);
        IPageCache pageCache = formPlugin.getView().getPageCache();
        pageCache.putBigObject("API_PAGE_CACHE_KEY", JsonUtils.serialize(voList));
        pageCache.put("API_MAPPING_CLASS_NAME", voList.isEmpty() ? null : voList.get(0).getClass().getName());
        MobileApiRendererUtils.renderEntries(formPlugin, entryName, voList);
        return voList;
    }

    public static <T extends AbstractFormPlugin & IMobileApiPage, M> void renderListView(T plugin, String entryName, List<M> voList) {
        for (int index = 0; index < voList.size(); ++index) {
            M vo = voList.get(index);
            MobileApiRendererUtils.renderView((IMobileApiPage)plugin, vo, index);
        }
    }

    public static <M, T extends AbstractFormPlugin & IMobileApiPage> M renderSingDataPage(T formPlugin) {
        return MobileApiRendererUtils.renderSingDataPage(formPlugin, null);
    }

    public static <T extends AbstractFormPlugin & IMobileApiPage, M> M renderSingDataPage(T formPlugin, IMobileApiResultHandler<M> resultHandler) {
        MobileApiRendererUtils.checkPermission(formPlugin);
        M vo = MobileApiUtils.getSingleData((IMobileApiSearch)formPlugin, resultHandler);
        IPageCache pageCache = formPlugin.getView().getPageCache();
        pageCache.putBigObject("API_PAGE_CACHE_KEY", JsonUtils.serialize(vo));
        pageCache.put("API_MAPPING_CLASS_NAME", vo.getClass().getName());
        MobileApiRendererUtils.renderData((IMobileApiPage)formPlugin, vo, -1);
        return vo;
    }

    private static <T extends AbstractFormPlugin & IMobileApiPage, M> void checkPermission(T formPlugin) {
        MainEntityType dataEntityType;
        String pcEntity = ((IMobileApiPage)formPlugin).getPcEntity();
        if (StringUtils.isEmpty((CharSequence)pcEntity)) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasSpecificPerm = PermissionHelper.userHasSpecificPerm(currUserId, (dataEntityType = MetadataServiceHelper.getDataEntityType((String)pcEntity)).getBizAppNumber(), pcEntity, "47150e89000000ac");
        if (!hasSpecificPerm) {
            IFormView view = formPlugin.getView();
            String message = String.format(ResManager.loadKDString((String)"\u65e0%s\u7684\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MobileApiRendererUtils_0", (String)"scmc-msmob-form", (Object[])new Object[0]), dataEntityType.getDisplayName());
            view.showErrorNotification(message);
            view.close();
        }
    }

    public static <T extends IMobileApiPage> Object refreshSingleDataPageOnClose(T formPlugin, ClosedCallBackEvent closedCallBackEvent) {
        IFormView view = formPlugin.getView();
        Object vo = MobileApiRendererUtils.getCachedObject(view);
        if (!closedCallBackEvent.getActionId().equals("API_ENTRY_CLOSED_CALLBACK")) {
            return vo;
        }
        IPageCache pageCache = view.getPageCache();
        pageCache.putBigObject("API_PAGE_CACHE_KEY", JsonUtils.serialize(vo));
        pageCache.put("API_MAPPING_CLASS_NAME", vo.getClass().getName());
        view.getModel().beginInit();
        MobileApiRendererUtils.renderData(formPlugin, vo, -1);
        view.getModel().endInit();
        view.updateView();
        return vo;
    }

    public static <T extends AbstractFormPlugin, M, E1, E2> M renderEntryPage(T formPlugin) {
        Object vo = MobileApiRendererUtils.getCachedObject(((IMobileApiEntryPage)formPlugin).getCachedObjectStorageView());
        MobileApiVisitingContext visitingContext = MobileApiRendererUtils.getVisitingContext(formPlugin);
        MobileApiRendererUtils.renderData((IMobileApiPage)formPlugin, vo, -1);
        Object entryVo = vo;
        for (VisitingContextElement element : visitingContext.getElements()) {
            Field field = MobileReflectionUtils.getField(entryVo.getClass(), element.getEntryFieldName());
            entryVo = ((List)MobileReflectionUtils.getFieldValue(field, entryVo)).get(element.getEntryIndex());
            MobileApiRendererUtils.renderData((IMobileApiPage)formPlugin, entryVo, -1);
        }
        Object entry = ((IMobileApiEntryPage)formPlugin).constructEntryViewObject(vo, entryVo);
        IPageCache pageCache = formPlugin.getView().getPageCache();
        pageCache.putBigObject("API_PAGE_CACHE_KEY", JsonUtils.serialize(entry));
        pageCache.put("API_MAPPING_CLASS_NAME", entry.getClass().getName());
        MobileApiRendererUtils.renderData((IMobileApiPage)formPlugin, entry, -1);
        return (M)vo;
    }

    public static <T extends AbstractFormPlugin, M, E1, E2> E1 saveEntryPage(T formPlugin) {
        Object vo = MobileApiRendererUtils.getCachedObject(((IMobileApiEntryPage)formPlugin).getCachedObjectStorageView());
        Object ev = MobileApiRendererUtils.getCachedObject(formPlugin.getView());
        MobileApiVisitingContext visitingContext = MobileApiRendererUtils.getVisitingContext(formPlugin);
        Object entryVo = vo;
        List entryList = new ArrayList();
        int index = 0;
        for (VisitingContextElement element : visitingContext.getElements()) {
            Field field = MobileReflectionUtils.getField(entryVo.getClass(), element.getEntryFieldName());
            entryList = (List)MobileReflectionUtils.getFieldValue(field, entryVo);
            index = element.getEntryIndex();
            entryVo = entryList.get(index);
        }
        Object e1 = ((IMobileApiEntryPage)formPlugin).constructEntrySaveObject(vo, entryVo, ev);
        entryList.set(index, e1);
        String jsonString = JsonUtils.serialize(vo);
        ((IMobileApiEntryPage)formPlugin).getCachedObjectStorageView().getPageCache().putBigObject("API_PAGE_CACHE_KEY", jsonString);
        return (E1)e1;
    }

    public static <T extends AbstractFormPlugin> MobileApiVisitingContext getVisitingContext(T formPlugin) {
        String mobileEntryName;
        IFormView view = formPlugin.getView();
        IFormView parentView = view.getParentView();
        IPageCache pageCache = parentView.getPageCache();
        String jsonString = pageCache.getBigObject("API_VISITING_CONTEXT");
        MobileApiVisitingContext context = JsonUtils.deserialize(jsonString, MobileApiVisitingContext.class);
        if (context == null) {
            context = new MobileApiVisitingContext();
        }
        if (StringUtils.isNotEmpty((CharSequence)(mobileEntryName = (String)view.getFormShowParameter().getCustomParam("SELECTED_ENTRY_NAME")))) {
            VisitingContextElement element = new VisitingContextElement();
            element.setEntryIndex(((IMobileApiEntryPage)formPlugin).getCurrentEntryIndex());
            element.setMobileEntryName(mobileEntryName);
            MobileFieldMapping mobileFieldMapping = MobileFieldMapping.construct(((IMobileApiEntryPage)formPlugin).getCachedObjectStorageView());
            Field field = (Field)mobileFieldMapping.get(mobileEntryName);
            element.setEntryFieldName(field.getName());
            context.addElement(element);
        }
        jsonString = JsonUtils.serialize(context);
        view.getPageCache().putBigObject("API_VISITING_CONTEXT", jsonString);
        return context;
    }

    private static <T extends IMobileApiPage> void renderEntries(T plugin, String entryName, List voList) {
        IDataModel model = plugin.getView().getModel();
        model.deleteEntryData(entryName);
        if (voList == null || voList.isEmpty()) {
            return;
        }
        model.batchCreateNewEntryRow(entryName, voList.size());
        for (int index = 0; index < voList.size(); ++index) {
            Object vo = voList.get(index);
            MobileApiRendererUtils.renderData(plugin, vo, index);
        }
    }

    public static <P extends IMobileApiPage> void renderData(P plugin, Object value, int entryIndex) {
        if (value == null) {
            return;
        }
        Class<?> apiResultClass = value.getClass();
        Field[] fields = FieldUtils.getAllFields(apiResultClass);
        IDataModel model = plugin.getView().getModel();
        for (Field field : fields) {
            MobileElement mobileElement = field.getDeclaredAnnotation(MobileElement.class);
            String mobileFieldName = null;
            if (mobileElement != null) {
                if (mobileElement.ignored()) continue;
                mobileFieldName = mobileElement.value();
            }
            if (StringUtils.isEmpty(mobileFieldName)) {
                mobileFieldName = field.getName();
            }
            Object fieldValue = MobileReflectionUtils.getFieldValue(field, value);
            IDataModel mobilePageModel = model;
            IDataEntityProperty mobilePageElement = mobilePageModel.getProperty(mobileFieldName);
            if (mobilePageElement != null) {
                if (mobilePageElement instanceof EntryProp) {
                    MobileApiRendererUtils.renderEntries(plugin, mobileFieldName, (List)fieldValue);
                    continue;
                }
                if (mobilePageElement instanceof BasedataProp && fieldValue != null && fieldValue.equals(0L)) {
                    fieldValue = null;
                }
                if (entryIndex == -1) {
                    boolean handled = MobileApiRendererUtils.handleField(plugin, field, mobilePageElement, fieldValue);
                    if (handled) continue;
                    mobilePageModel.setValue(mobileFieldName, fieldValue);
                    continue;
                }
                mobilePageModel.setValue(mobileFieldName, fieldValue, entryIndex);
                continue;
            }
            if (plugin.getView().getControl(mobileFieldName) instanceof TabPage) {
                MobileApiRendererUtils.renderData(plugin, fieldValue, -1);
                continue;
            }
            MobileApiRendererUtils.handleElement(plugin, field, mobileFieldName, fieldValue, entryIndex);
        }
    }

    private static <P extends IMobileApiPage> void renderView(P plugin, Object value, int entryIndex) {
        if (value == null) {
            return;
        }
        Class<?> apiResultClass = value.getClass();
        Field[] fields = FieldUtils.getAllFields(apiResultClass);
        IDataModel model = plugin.getView().getModel();
        for (Field field : fields) {
            MobileElement mobileElement = field.getDeclaredAnnotation(MobileElement.class);
            String mobileFieldName = null;
            if (mobileElement != null) {
                if (mobileElement.ignored()) continue;
                mobileFieldName = mobileElement.value();
            }
            if (StringUtils.isEmpty(mobileFieldName)) {
                mobileFieldName = field.getName();
            }
            Object fieldValue = MobileReflectionUtils.getFieldValue(field, value);
            IDataModel mobilePageModel = model;
            IDataEntityProperty mobilePageElement = mobilePageModel.getProperty(mobileFieldName);
            if (mobilePageElement != null) continue;
            MobileApiRendererUtils.handleElement(plugin, field, mobileFieldName, fieldValue, entryIndex);
        }
    }

    private static <P extends IMobileApiPage> void handleElement(P plugin, Field field, String mobileFieldName, Object fieldValue, int entryIndex) {
        Control control = plugin.getView().getControl(mobileFieldName);
        if (control == null) {
            return;
        }
        elementHandlers.stream().filter(aClass -> {
            Set<Type> genericTypeArguments = MobileReflectionUtils.getGenericTypeArguments(aClass);
            return genericTypeArguments.contains(control.getClass());
        }).forEach(aClass -> {
            AbstractElementHandler abstractElementHandler = (AbstractElementHandler)MobileReflectionUtils.newInstance(aClass);
            abstractElementHandler.handle(control, plugin, field, fieldValue, entryIndex);
        });
    }

    private static <P extends IMobileApiPage> boolean handleField(P plugin, Field field, IDataEntityProperty mobilePageElement, Object fieldValue) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        fieldHandlers.stream().filter(aClass -> {
            Set<Type> genericTypeArguments = MobileReflectionUtils.getGenericTypeArguments(aClass);
            return genericTypeArguments.contains(mobilePageElement.getClass());
        }).forEach(aClass -> {
            AbstractFieldHandler abstractFieldHandler = (AbstractFieldHandler)MobileReflectionUtils.newInstance(aClass);
            abstractFieldHandler.handle(mobilePageElement, plugin, field, fieldValue);
            atomicBoolean.set(true);
        });
        return atomicBoolean.get();
    }

    public static <P extends AbstractFormPlugin, V> V getCachedObject(IFormView formView) {
        IPageCache pageCache = formView.getPageCache();
        String jsonString = pageCache.getBigObject("API_PAGE_CACHE_KEY");
        return (V)JsonUtils.deserialize(jsonString, MobileReflectionUtils.forName(pageCache.get("API_MAPPING_CLASS_NAME")));
    }

    public static <P extends AbstractFormPlugin, V> List<V> getCachedObjectList(IFormView formView) {
        IPageCache pageCache = formView.getPageCache();
        String jsonString = pageCache.getBigObject("API_PAGE_CACHE_KEY");
        Class aClass = MobileReflectionUtils.forName(pageCache.get("API_MAPPING_CLASS_NAME"));
        return JsonUtils.deserializeList(jsonString, aClass);
    }

    public static <P extends AbstractFormPlugin> void addDataModelChangeListener(P formPlugin) {
        IDataModel model = formPlugin.getView().getModel();
        if (formPlugin instanceof IMobileApiEntryPage) {
            model.addDataModelChangeListener(new MobileApiEntryDataChangedListener(formPlugin));
        } else {
            model.addDataModelChangeListener(new MobileApiDataChangedListener<P>(formPlugin));
        }
    }

    static {
        elementHandlers.add(LabelHandler.class);
        elementHandlers.add(HtmlHandler.class);
        fieldHandlers.add(AttachmentHandler.class);
    }
}

