/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.mvccore;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.result.ApiQueryResult;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.OpenApiSdkUtil;
import kd.scmc.msmob.mvccore.ApiResultTransformer;
import kd.scmc.msmob.mvccore.IMobileApiResultHandler;
import kd.scmc.msmob.mvccore.IMobileApiSearch;
import kd.scmc.msmob.mvccore.JsonUtils;
import kd.scmc.msmob.mvccore.MobileApiCRUDUtils;
import kd.scmc.msmob.mvccore.MobileSearchParameter;
import kd.scmc.msmob.mvccore.OpenApiDataSource;
import kd.scmc.msmob.mvccore.UrlMappingUtils;

public class MobileApiUtils {
    private static final Log log = LogFactory.getLog(MobileApiUtils.class);

    public static <T extends IMobileApiSearch<M>, M> M getSingleData(T t, IMobileApiResultHandler<M> resultHandler, ApiResultTransformer<M> resultTransformer) {
        OpenApiDataSource<M> datasourceConfig = t.getDatasourceConfig();
        if (datasourceConfig.isUseQuery()) {
            Object vo;
            List dataList = MobileApiUtils.getDataListFromOpenApi(t);
            if (resultTransformer != null) {
                vo = resultTransformer.transformResult(dataList);
            } else if (dataList.isEmpty()) {
                vo = null;
            } else {
                if (dataList.size() > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u201c%s\u201d\u8fd4\u56de\u4e86\u591a\u6761\u6570\u636e\u3002", (String)"Exception_openapi_data_too_many", (String)"scmc-msmob-form", (Object[])new Object[0]), datasourceConfig.getAddress()));
                }
                vo = dataList.get(0);
            }
            if (resultHandler != null) {
                resultHandler.handle(vo);
            }
            return vo;
        }
        String address = datasourceConfig.getAddress();
        MobileSearchParameter parameter = MobileApiUtils.getParameterMap(t);
        OpenApiResult result = OpenApiSdkUtil.invoke((String)UrlMappingUtils.getUrl(address), (Map)parameter);
        if (!result.isStatus()) {
            throw new KDBizException(result.getMessage());
        }
        Object data = result.getData();
        Class<M> mappingClass = datasourceConfig.getMappingClass();
        return JsonUtils.deserialize(JsonUtils.serialize(data), mappingClass);
    }

    public static <T extends IMobileApiSearch<M>, M> M getSingleData(T t, IMobileApiResultHandler<M> resultHandler) {
        return MobileApiUtils.getSingleData(t, resultHandler, null);
    }

    private static <P extends IMobileApiSearch, V> MobileSearchParameter getParameterMap(P p) {
        OpenApiDataSource datasourceConfig = p.getDatasourceConfig();
        Class mappingClass = datasourceConfig.getMappingClass();
        MobileSearchParameter parameter = new MobileSearchParameter();
        if ((parameter = p.getApiSearchParameters(parameter)) == null) {
            parameter = new MobileSearchParameter();
        }
        MobileApiUtils.handleQueryParameter(parameter);
        return parameter;
    }

    public static void handleQueryParameter(Map<String, Object> parameter) {
        parameter.entrySet().iterator().forEachRemaining(stringObjectEntry -> {
            Object value = stringObjectEntry.getValue();
            if (value == null || value.equals("")) {
                stringObjectEntry.setValue("*");
            }
        });
    }

    public static <P extends IMobileApiSearch, V> List<V> getDataListFromOpenApi(P p) {
        ArrayList voList;
        OpenApiDataSource datasourceConfig = p.getDatasourceConfig();
        Class mappingClass = datasourceConfig.getMappingClass();
        MobileSearchParameter parameter = MobileApiUtils.getParameterMap(p);
        log.info("the search parameter is: " + JSON.toJSONString((Object)parameter));
        if (parameter != null && !parameter.isAllowSearch()) {
            return new ArrayList();
        }
        if (datasourceConfig.isUseQuery()) {
            int pageSize = 500;
            boolean pageNo = true;
            String address = datasourceConfig.getAddress();
            OpenApiResult result = OpenApiSdkUtil.query((String)UrlMappingUtils.getUrl(address), (Map)parameter, (int)500, (int)1);
            if (!result.isStatus()) {
                throw new KDBizException(result.getMessage());
            }
            ApiQueryResult data = (ApiQueryResult)result.getData();
            List rows = data.getRows();
            voList = new ArrayList(rows.size());
            for (Map resultMap : rows) {
                String jsonString = JsonUtils.serialize(resultMap);
                Object vo = JsonUtils.deserialize(jsonString, mappingClass);
                voList.add(vo);
            }
        } else {
            String address = datasourceConfig.getAddress();
            OpenApiResult result = OpenApiSdkUtil.invoke((String)UrlMappingUtils.getUrl(address), (Map)parameter);
            MobileApiCRUDUtils.checkOpenapiResultException(result);
            String serialize = JsonUtils.serialize(result.getData());
            ApiQueryResult data = JsonUtils.deserialize(serialize, ApiQueryResult.class);
            List rows = data.getRows();
            voList = new ArrayList(rows.size());
            for (Map resultMap : rows) {
                String jsonString = JsonUtils.serialize(resultMap);
                Object vo = JsonUtils.deserialize(jsonString, mappingClass);
                voList.add(vo);
            }
        }
        log.info("search result length: " + voList.size());
        return voList;
    }
}

