/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.mvccore;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.scmc.msmob.mvccore.MobileElement;
import kd.scmc.msmob.mvccore.MobileEntryFieldMapping;
import kd.scmc.msmob.mvccore.MobileReflectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class MobileFieldMapping
extends HashMap<String, Field> {
    private final Map<String, MobileEntryFieldMapping> entryFieldMapping = new HashMap<String, MobileEntryFieldMapping>();

    public Field getEntryField(String mobileEntryName, String mobileFieldName) {
        MobileEntryFieldMapping mobileEntryFieldMapping = this.entryFieldMapping.get(mobileEntryName);
        return (Field)mobileEntryFieldMapping.get(mobileFieldName);
    }

    public static MobileFieldMapping construct(IFormView view) {
        String mappingClassName = view.getPageCache().get("API_MAPPING_CLASS_NAME");
        Class mappingClass = MobileReflectionUtils.forName(mappingClassName);
        return new MobileFieldMapping(mappingClass);
    }

    public MobileFieldMapping(Class mappingClass) {
        Field[] fields;
        for (Field field : fields = FieldUtils.getAllFields((Class)mappingClass)) {
            MobileElement mobileElement = field.getDeclaredAnnotation(MobileElement.class);
            String mobileFieldName = null;
            if (mobileElement != null) {
                if (mobileElement.ignored()) continue;
                mobileFieldName = mobileElement.value();
            }
            if (StringUtils.isEmpty(mobileFieldName)) {
                mobileFieldName = field.getName();
            }
            this.put(mobileFieldName, field);
            if (!Collection.class.isAssignableFrom(field.getType())) continue;
            this.entryFieldMapping.put(mobileFieldName, new MobileEntryFieldMapping(field));
        }
    }
}

