/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.mvccore;

import java.util.List;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.MobileSearchCancelListener;
import kd.bos.form.control.events.MobileSearchFocusListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.MobileSearch;
import kd.scmc.msmob.mvccore.IMobileApiPage;
import kd.scmc.msmob.mvccore.IPageCondition;
import kd.scmc.msmob.mvccore.MobileApiRendererUtils;
import kd.scmc.msmob.mvccore.MobileSearchParameter;
import kd.scmc.msmob.mvccore.MobileViewModelUtils;

public class MobileOpenApiPluginHelper {
    public static <T extends AbstractFormPlugin & IMobileApiPage, M> void addMobileSearchTextListener(T plugin) {
        MobileOpenApiPluginHelper.addMobileSearchTextListener(plugin, MobileViewModelUtils.getFirstMobileSearch(plugin));
    }

    public static <T extends AbstractFormPlugin & IMobileApiPage, M> void addMobileSearchTextListener(T plugin, MobileSearchFocusListener focusListener, MobileSearchCancelListener cancelListener) {
        MobileOpenApiPluginHelper.addMobileSearchTextListener(plugin, MobileViewModelUtils.getFirstMobileSearch(plugin));
        MobileOpenApiPluginHelper.addMobileSearchFocusCancelListener(plugin, MobileViewModelUtils.getFirstMobileSearch(plugin), focusListener, cancelListener);
    }

    public static <T extends AbstractFormPlugin & IMobileApiPage, M> void addEntryPageListener(T plugin) {
        IFormView view = plugin.getView();
        CardEntry cardEntry = (CardEntry)view.getControl(MobileViewModelUtils.getFirstEntryName(plugin));
        cardEntry.addPagerClickListener(pagerClickEvent -> MobileApiRendererUtils.renderListPageOnPageSwitched(plugin, pagerClickEvent));
    }

    public static <T extends AbstractFormPlugin & IMobileApiPage, M> void addMobileSearchTextListener(T plugin, String searchTextField) {
        MobileSearch search = (MobileSearch)plugin.getControl(searchTextField);
        search.addMobileSearchTextChangeListener(changeEvent -> {
            String searchText = search.getText();
            plugin.getPageCache().put("search_text", searchText);
            MobileApiRendererUtils.renderListPage(plugin);
        });
    }

    public static <T extends AbstractFormPlugin & IMobileApiPage, M> void addMobileSearchFocusCancelListener(T plugin, String searchTextField, MobileSearchFocusListener focusListener, MobileSearchCancelListener cancelListener) {
        MobileSearch search = (MobileSearch)plugin.getControl(searchTextField);
        search.addMobileSearchFocusListener(focusListener);
        search.addMobileSearchCancelListener(cancelListener);
    }

    public static <T extends AbstractFormPlugin, V> void addRowClickListener(final T plugin, String entryName, final IPageCondition<V> pageCondition) {
        EntryGrid entryGrid = (EntryGrid)plugin.getControl(entryName);
        entryGrid.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                IFormView view = plugin.getView();
                List cachedObjectList = MobileApiRendererUtils.getCachedObjectList(plugin.getView());
                MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
                mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                int row = evt.getRow();
                MobileFormShowParameter entryPageParameter = pageCondition.getEntryPageParameter(cachedObjectList.get(row), mobileFormShowParameter);
                if (entryPageParameter == null) {
                    return;
                }
                view.showForm((FormShowParameter)entryPageParameter);
            }
        });
    }

    public static <T extends AbstractFormPlugin, V> void addRowClickListener(T plugin, IPageCondition<V> pageCondition) {
        MobileOpenApiPluginHelper.addRowClickListener(plugin, MobileViewModelUtils.getFirstEntryName(plugin), pageCondition);
    }

    public static void addIdParameter(AbstractFormPlugin formPlugin, MobileSearchParameter parameterMap) {
        MobileFormShowParameter param = (MobileFormShowParameter)formPlugin.getView().getFormShowParameter();
        Long id = Long.valueOf(param.getCustomParam("id").toString());
        if (id == null || id == 0L) {
            parameterMap.forbiddenSearch();
        } else {
            parameterMap.put("id", id);
        }
    }
}

