/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.mvccore;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileSearch;
import kd.scmc.msmob.mvccore.IPageCondition;
import kd.scmc.msmob.mvccore.MobileApiRendererUtils;
import kd.scmc.msmob.mvccore.direction.DataSwitchDirection;
import kd.scmc.msmob.mvccore.direction.DataSwitchListener;

public class MobileViewModelUtils {
    public static <P extends AbstractFormPlugin> void addPreviousAndNextListener(P plugin, String previousButton, String nextButton) {
        IFormView view = plugin.getView();
        Control previousButtonCtl = view.getControl(previousButton);
        Control nextButtonCtl = view.getControl(nextButton);
        if (!(previousButtonCtl instanceof ISuportClick) || !(nextButtonCtl instanceof ISuportClick)) {
            throw new RuntimeException();
        }
        ISuportClick button1 = (ISuportClick)previousButtonCtl;
        ISuportClick button2 = (ISuportClick)nextButtonCtl;
        button1.addClickListener(new DataSwitchListener<P>(DataSwitchDirection.PREVIOUS, plugin));
        button2.addClickListener(new DataSwitchListener<P>(DataSwitchDirection.NEXT, plugin));
    }

    public static <P extends AbstractFormPlugin> void addEntryClickListenerForMultiComponent(final P plugin, final Map<String, String> componentInfo, final String entryDisplayMode) {
        final IFormView view = plugin.getView();
        Set<String> keySet = componentInfo.keySet();
        for (String entryName : keySet) {
            EntryGrid componentEntry = (EntryGrid)view.getControl(entryName);
            componentEntry.addRowClickListener(new RowClickEventListener(){

                public void entryRowClick(RowClickEvent evt) {
                    super.entryRowClick(evt);
                    String componentName = ((EntryGrid)evt.getSource()).getKey();
                    MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
                    formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                    formShowParameter.setCustomParam("SELECTED_ENTRY_NAME", (Object)componentName);
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "API_ENTRY_CLOSED_CALLBACK"));
                    formShowParameter.setFormId((String)componentInfo.get(componentName));
                    formShowParameter.setCustomParam("entry_display_mode", (Object)entryDisplayMode);
                    view.showForm((FormShowParameter)formShowParameter);
                }
            });
        }
    }

    public static <P extends AbstractFormPlugin, V> void addEntryToPageListener(final P plugin, final String mobileEntryName, final IPageCondition<V> pageCondition) {
        final IFormView view = plugin.getView();
        Control control = view.getControl(mobileEntryName);
        if (control instanceof EntryGrid) {
            EntryGrid entryGrid = (EntryGrid)control;
            entryGrid.addRowClickListener(new RowClickEventListener(){

                public void entryRowClick(RowClickEvent evt) {
                    Object cachedObject = MobileApiRendererUtils.getCachedObject(plugin.getView());
                    MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
                    formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                    formShowParameter.setCustomParam("SELECTED_ENTRY_NAME", (Object)mobileEntryName);
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "API_ENTRY_CLOSED_CALLBACK"));
                    formShowParameter = pageCondition.getEntryPageParameter(cachedObject, formShowParameter);
                    view.showForm((FormShowParameter)formShowParameter);
                }
            });
        } else {
            final String entryName = MobileViewModelUtils.getEntryNameOfElement(control);
            if (!(control instanceof ISuportClick)) {
                throw new RuntimeException();
            }
            ISuportClick editButton = (ISuportClick)control;
            editButton.addClickListener(new ClickListener(){

                public void click(EventObject evt) {
                    BeforeClickEvent event = (BeforeClickEvent)evt;
                    int entryCurrentRowIndex = view.getModel().getEntryCurrentRowIndex(entryName);
                    Object cachedObject = MobileApiRendererUtils.getCachedObject(plugin.getView());
                    MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
                    formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                    formShowParameter.setCustomParam("SELECTED_ENTRY_NAME", (Object)entryName);
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "API_ENTRY_CLOSED_CALLBACK"));
                    formShowParameter = pageCondition.getEntryPageParameter(cachedObject, formShowParameter);
                    view.showForm((FormShowParameter)formShowParameter);
                }
            });
        }
    }

    public static <T extends AbstractFormPlugin> String getFirstEntryName(T formPlugin) {
        return MobileViewModelUtils.getFirstElementOfType(formPlugin, CardEntry.class);
    }

    public static <T extends AbstractFormPlugin> String getFirstMobileSearch(T formPlugin) {
        return MobileViewModelUtils.getFirstElementOfType(formPlugin, MobileSearch.class);
    }

    public static <T extends AbstractFormPlugin> String getFirstElementOfType(T formPlugin, Class<? extends Control> elementType) {
        IFormView view = formPlugin.getView();
        Control rootControl = view.getRootControl();
        return MobileViewModelUtils.getFirstElementOfType(rootControl, elementType);
    }

    public static String getFirstElementOfType(Control control, Class<? extends Control> elementType) {
        if (control == null) {
            return null;
        }
        boolean equals = control.getClass().equals(elementType);
        if (equals) {
            return control.getKey();
        }
        if (control instanceof Container) {
            Container container = (Container)control;
            List items = container.getItems();
            if (items == null) {
                return null;
            }
            for (Control child : items) {
                String elementName = MobileViewModelUtils.getFirstElementOfType(child, elementType);
                if (!StringUtils.isNotEmpty((CharSequence)elementName)) continue;
                return elementName;
            }
        }
        return null;
    }

    public static String getEntryNameOfElement(Control control) {
        IFormView view = control.getView();
        Control rootControl = view.getRootControl();
        return MobileViewModelUtils.getEntryNameOfElement(rootControl, control.getKey(), null);
    }

    private static String getEntryNameOfElement(Control control, String controlName, String entryName) {
        if (control == null) {
            return null;
        }
        if (control instanceof Container) {
            boolean isEntry = control.getClass().equals(CardEntry.class);
            Container container = (Container)control;
            List items = container.getItems();
            if (items == null) {
                return null;
            }
            for (Control child : items) {
                if (child.getKey().equals(controlName)) {
                    return entryName;
                }
                String elementName = MobileViewModelUtils.getEntryNameOfElement(child, controlName, isEntry && entryName == null ? control.getKey() : entryName);
                if (!StringUtils.isNotEmpty((CharSequence)elementName)) continue;
                return elementName;
            }
        }
        return null;
    }

    public static void addClickListener(IFormView view, String key, ClickListener clickListener) {
        Control c = view.getControl(key);
        if (c instanceof ISuportClick) {
            ((ISuportClick)c).addClickListener(clickListener);
        }
    }
}

