/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.mvccore.element;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.msmob.mvccore.IMobileApiPage;
import kd.scmc.msmob.mvccore.MobileViewModelUtils;
import kd.scmc.msmob.mvccore.element.AbstractElementHandler;
import kd.scmc.msmob.mvccore.label.ILabelInterface;
import kd.scmc.msmob.mvccore.label.MobileLabel;
import org.apache.commons.lang3.StringUtils;

public class LabelHandler
extends AbstractElementHandler<Label> {
    @Override
    public <P extends IMobileApiPage> void handle(Label label, P plugin, Field field, Object fieldValue, int entryIndex) {
        MobileLabel mobileLabel = field.getDeclaredAnnotation(MobileLabel.class);
        String labelDisplayText = this.getLabelDisplayText(plugin, field, fieldValue);
        if (StringUtils.isEmpty((CharSequence)labelDisplayText)) {
            return;
        }
        ILabelInterface matchedEnum = null;
        if (mobileLabel != null) {
            Enum[] enumConstants;
            Class<? extends Enum> enumClass = mobileLabel.value();
            for (Enum enumConstant : enumConstants = enumClass.getEnumConstants()) {
                if (!(enumConstant instanceof ILabelInterface)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u679a\u4e3e\u7c7b\u201c%s\u201d\u5fc5\u987b\u5b9e\u73b0\u201cILabelInterface\u201d\u3002", (String)"Exception_label_enum_error", (String)"scmc-msmob-form", (Object[])new Object[0]), enumClass.getSimpleName()));
                }
                ILabelInterface labelEnum = (ILabelInterface)((Object)enumConstant);
                if (!labelEnum.getFieldValue().equals(fieldValue)) continue;
                matchedEnum = labelEnum;
            }
        }
        HashMap<String, Object> labelProperties = new HashMap<String, Object>(1);
        labelProperties.put("text", labelDisplayText);
        if (matchedEnum != null) {
            labelProperties.putAll(matchedEnum.getCustomProperties());
        }
        IFormView view = plugin.getView();
        if (entryIndex >= 0) {
            String entryName = MobileViewModelUtils.getEntryNameOfElement((Control)label);
            CardEntry cardEntry = (CardEntry)view.getControl(entryName);
            HashMap<String, HashMap<String, Object>> entryFieldsMap = new HashMap<String, HashMap<String, Object>>(1);
            entryFieldsMap.put(label.getKey(), labelProperties);
            cardEntry.setCustomProperties(cardEntry.getKey(), entryIndex, entryFieldsMap);
        } else {
            label.setText(labelDisplayText);
            this.rebuildLabelProperties(labelProperties);
            view.updateControlMetadata(label.getKey(), labelProperties);
        }
    }

    private <P extends IMobileApiPage> String getLabelDisplayText(P plugin, Field field, Object fieldValue) {
        if (fieldValue == null || fieldValue.equals("")) {
            return null;
        }
        MobileLabel mobileLabel = field.getDeclaredAnnotation(MobileLabel.class);
        String pcEntityName = mobileLabel.pcEntity();
        String fieldName = mobileLabel.pcComboField();
        if (StringUtils.isEmpty((CharSequence)fieldName)) {
            fieldName = field.getName();
        }
        if (StringUtils.isEmpty((CharSequence)pcEntityName)) {
            pcEntityName = plugin.getPcEntity();
        }
        if (StringUtils.isEmpty((CharSequence)pcEntityName)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5b57\u6bb5\u201c%s\u201d\u5bf9\u5e94\u7684PC\u5b9e\u4f53\u3002", (String)"Exception_label_pcentity_error", (String)"scmc-msmob-form", (Object[])new Object[0]), fieldName));
        }
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)pcEntityName);
        ComboProp combo = (ComboProp)type.getAllFields().get(fieldName);
        if (combo == null) {
            throw new RuntimeException();
        }
        List comboItems = combo.getComboItems();
        Optional<ValueMapItem> valueMapItemOptional = comboItems.stream().filter(valueMapItem -> valueMapItem.getValue().equals(fieldValue)).findAny();
        if (!valueMapItemOptional.isPresent()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u4e2d\u4e0d\u5305\u542b\u201c%3$s\u201d\u503c\u3002", (String)"Exception_label_combo_error", (String)"scmc-msmob-form", (Object[])new Object[0]), pcEntityName, fieldName, fieldValue));
        }
        return valueMapItemOptional.get().getName().getLocaleValue();
    }

    private void rebuildLabelProperties(Map<String, Object> labelProperties) {
        String borderColor = (String)labelProperties.get("borc");
        if (StringUtils.isEmpty((CharSequence)borderColor)) {
            return;
        }
        labelProperties.remove("borc");
        String border = "1px_solid_" + borderColor;
        HashMap<String, String> borderProperties = new HashMap<String, String>();
        borderProperties.put("b", border);
        borderProperties.put("l", border);
        borderProperties.put("r", border);
        borderProperties.put("t", border);
        HashMap<String, HashMap<String, String>> reLabelProperties = new HashMap<String, HashMap<String, String>>();
        reLabelProperties.put("b", borderProperties);
        labelProperties.put("s", reLabelProperties);
    }
}

