/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.form.baseset;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.msmob.common.enums.EnableStatusEnum;

public class CodeParsingServiceFormPlugin
extends AbstractBasePlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.controlEnableAndVisibleByFormCreateAndCopy();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("priority", (Object)BigDecimal.ZERO);
        this.getModel().setValue("ispreset", (Object)"0");
        this.controlEnableAndVisibleByFormCreateAndCopy();
    }

    private void controlEnableAndVisibleByFormCreateAndCopy() {
        this.getView().setEnable(Boolean.TRUE, new String[]{"name", "number", "condition", "priority", "explanation", "cloudid", "appid", "servicename", "methodname"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        boolean isPreset = (Boolean)this.getModel().getValue("ispreset");
        if (isPreset) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"name", "number", "condition", "priority", "explanation", "cloudid", "appid", "servicename", "methodname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "customsave": {
                this.checkEnableBySave(operateKey);
                break;
            }
            case "customenable": {
                this.checkRepeatPriorityBySaveAndEnable(operateKey);
                break;
            }
            case "disable": 
            case "delete": {
                this.checkAllDataDisableByDeleteAndDisable(args);
                break;
            }
        }
    }

    private void checkEnableBySave(String operateKey) {
        String enable = (String)this.getModel().getValue("enable");
        if (EnableStatusEnum.ENABLE.getValue().equals(enable)) {
            this.checkRepeatPriorityBySaveAndEnable(operateKey);
        } else if (EnableStatusEnum.DISABLE.getValue().equals(enable)) {
            this.invokeFormOperation(operateKey);
        }
    }

    private void checkRepeatPriorityBySaveAndEnable(String operateKey) {
        Long id = (Long)this.getModel().getValue("id");
        Integer priority = (Integer)this.getModel().getValue("priority");
        QFilter qFilter = new QFilter("priority", "=", (Object)priority);
        qFilter.and(new QFilter("id", "!=", (Object)id));
        qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        boolean exists = QueryServiceHelper.exists((String)"msmob_parseserviceconfig", (QFilter[])new QFilter[]{qFilter});
        if (exists) {
            this.openConfirmDialog(operateKey);
        } else {
            this.invokeFormOperation(operateKey);
        }
    }

    private void checkAllDataDisableByDeleteAndDisable(BeforeDoOperationEventArgs args) {
        Long id = (Long)this.getModel().getValue("id");
        QFilter enable = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        enable.and(new QFilter("id", "!=", (Object)id));
        boolean existEnableData = QueryServiceHelper.exists((String)"msmob_parseserviceconfig", (QFilter[])new QFilter[]{enable});
        if (!existEnableData) {
            args.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u6700\u5c11\u8981\u6709\u4e00\u6761\u7801\u89e3\u6790\u670d\u52a1\u5904\u4e8e\u542f\u7528\u72b6\u6001\u3002", (String)"CodeParsingServiceFormPlugin_0", (String)"scmc-msmob-form", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        }
    }

    private void openConfirmDialog(String operateKey) {
        String msg = ResManager.loadKDString((String)"\u5f53\u524d\u4f18\u5148\u7ea7\u5df2\u542f\u7528\uff0c\u662f\u5426\u7ee7\u7eed\u4f7f\u7528\uff1f", (String)"CodeParsingServiceFormPlugin_1", (String)"scmc-msmob-form", (Object[])new Object[0]);
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, callBackListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        int value = result.getValue();
        if (MessageBoxResult.Yes.getValue() == value) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isrepeat", "true");
            if ("customsave".equals(callBackId)) {
                this.getView().invokeOperation("save", option);
            } else if ("customenable".equals(callBackId)) {
                this.getView().invokeOperation("enable", option);
            }
        }
    }

    private void invokeFormOperation(String operateKey) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isrepeat", "false");
        if ("customsave".equals(operateKey)) {
            this.getView().invokeOperation("save", option);
        } else if ("customenable".equals(operateKey)) {
            this.getView().invokeOperation("enable", option);
        }
    }
}

