/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.form.baseset;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.msmob.common.enums.EnableStatusEnum;

public class CodeParsingServiceListPlugin
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        boolean selectOneRow = this.checkSelectRowsCount();
        switch (operateKey) {
            case "customenable": {
                if (selectOneRow) {
                    this.checkRepeatPriorityByEnable();
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u540c\u65f6\u542f\u7528\u4e00\u6761\u6570\u636e\u3002", (String)"CodeParsingServiceListPlugin_0", (String)"scmc-msmob-form", (Object[])new Object[0]));
                break;
            }
            case "disable": {
                if (selectOneRow) {
                    this.checkAllDataDisableByDeleteAndDisable(args);
                    break;
                }
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u540c\u65f6\u7981\u7528\u4e00\u6761\u6570\u636e\u3002", (String)"CodeParsingServiceListPlugin_1", (String)"scmc-msmob-form", (Object[])new Object[0]));
                break;
            }
            case "delete": {
                this.checkAllDataDisableByDeleteAndDisable(args);
                break;
            }
        }
    }

    private boolean checkSelectRowsCount() {
        int size = this.getSelectedRows().size();
        boolean isSelectOneRow = size <= 1;
        return isSelectOneRow;
    }

    private void checkRepeatPriorityByEnable() {
        Long id = (Long)this.getSelectedRows().get(0).getPrimaryKeyValue();
        DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"msmob_parseserviceconfig");
        int priority = config.getInt("priority");
        QFilter qFilter = new QFilter("priority", "=", (Object)priority);
        qFilter.and(new QFilter("id", "!=", (Object)id));
        qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        boolean exists = QueryServiceHelper.exists((String)"msmob_parseserviceconfig", (QFilter[])new QFilter[]{qFilter});
        if (exists) {
            this.openConfirm();
        } else {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isrepeat", "false");
            this.getView().invokeOperation("enable", option);
        }
    }

    private void checkAllDataDisableByDeleteAndDisable(BeforeDoOperationEventArgs args) {
        Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        QFilter enable = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        enable.and(new QFilter("id", "not in", (Object)primaryKeyValues));
        boolean existEnableData = QueryServiceHelper.exists((String)"msmob_parseserviceconfig", (QFilter[])new QFilter[]{enable});
        if (!existEnableData) {
            args.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u6700\u5c11\u8981\u6709\u4e00\u6761\u7801\u89e3\u6790\u670d\u52a1\u5904\u4e8e\u542f\u7528\u72b6\u6001\u3002", (String)"CodeParsingServiceFormPlugin_0", (String)"scmc-msmob-form", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        }
    }

    private void openConfirm() {
        String msg = ResManager.loadKDString((String)"\u5f53\u524d\u4f18\u5148\u7ea7\u5df2\u542f\u7528\uff0c\u662f\u5426\u7ee7\u7eed\u4f7f\u7528\uff1f", (String)"CodeParsingServiceFormPlugin_1", (String)"scmc-msmob-form", (Object[])new Object[0]);
        ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("enable", (IFormPlugin)this);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, callBackListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        int value = result.getValue();
        if (MessageBoxResult.Yes.getValue() == value && "enable".equals(callBackId)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isrepeat", "true");
            this.getView().invokeOperation("enable", option);
        }
    }
}

